/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.clientproject.AppClientProject;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeFactory;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeImplementation;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceLocationProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeFactory;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeImplementation;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopesProvider;
import org.netbeans.modules.j2ee.persistence.spi.support.EntityMappingsMetadataModelHelper;
import org.netbeans.modules.j2ee.persistence.spi.support.PersistenceScopesHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathProviderImpl;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class AppClientPersistenceProvider
implements PersistenceLocationProvider,
PersistenceScopeProvider,
PersistenceScopesProvider,
EntityClassScopeProvider,
PropertyChangeListener {
    private final AppClientProject project;
    private final PropertyEvaluator evaluator;
    private final ClassPathProviderImpl cpProvider;
    private final ScopeImpl scopeImpl = new ScopeImpl();
    private final PersistenceScope persistenceScope = PersistenceScopeFactory.createPersistenceScope((PersistenceScopeImplementation)this.scopeImpl);
    private final EntityClassScope entityClassScope = EntityClassScopeFactory.createEntityClassScope((EntityClassScopeImplementation)this.scopeImpl);
    private final PersistenceScopesHelper scopesHelper = new PersistenceScopesHelper();
    private final EntityMappingsMetadataModelHelper modelHelper;
    private ClassPath projectSourcesClassPath;
    private final PropertyChangeListener scopeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object newV = evt.getNewValue();
            if (Boolean.TRUE.equals(newV)) {
                AppClientPersistenceProvider.this.puChanged();
            }
        }
    };

    public AppClientPersistenceProvider(AppClientProject project, PropertyEvaluator evaluator, ClassPathProviderImpl cpProvider) {
        this.project = project;
        this.evaluator = evaluator;
        this.cpProvider = cpProvider;
        this.modelHelper = this.createEntityMappingsHelper();
        evaluator.addPropertyChangeListener((PropertyChangeListener)this);
        this.locationChanged();
    }

    public FileObject getLocation() {
        return this.project.getAPICar().getMetaInf();
    }

    public FileObject createLocation() throws IOException {
        return this.project.getAPICar().getMetaInf();
    }

    public PersistenceScope findPersistenceScope(FileObject fo) {
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project != null) {
            AppClientPersistenceProvider provider = (AppClientPersistenceProvider)project.getLookup().lookup(AppClientPersistenceProvider.class);
            return provider.getPersistenceScope();
        }
        return null;
    }

    public EntityClassScope findEntityClassScope(FileObject fo) {
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project != null) {
            AppClientPersistenceProvider provider = (AppClientPersistenceProvider)project.getLookup().lookup(AppClientPersistenceProvider.class);
            return provider.getEntityClassScope();
        }
        return null;
    }

    public PersistenceScopes getPersistenceScopes() {
        return this.scopesHelper.getPersistenceScopes();
    }

    private PersistenceScope getPersistenceScope() {
        FileObject persistenceXml = this.persistenceScope.getPersistenceXml();
        if (persistenceXml != null && persistenceXml.isValid()) {
            return this.persistenceScope;
        }
        return null;
    }

    private EntityClassScope getEntityClassScope() {
        return this.entityClassScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getProjectSourcesClassPath() {
        AppClientPersistenceProvider appClientPersistenceProvider = this;
        synchronized (appClientPersistenceProvider) {
            if (this.projectSourcesClassPath == null) {
                this.projectSourcesClassPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{this.cpProvider.getProjectSourcesClassPath("classpath/source"), this.cpProvider.getProjectSourcesClassPath("classpath/compile")});
            }
            return this.projectSourcesClassPath;
        }
    }

    private EntityMappingsMetadataModelHelper createEntityMappingsHelper() {
        return EntityMappingsMetadataModelHelper.create((ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/source"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propName = event.getPropertyName();
        if (propName == null || propName.equals("meta.inf")) {
            this.locationChanged();
        }
    }

    private void locationChanged() {
        File metaInfFile = this.project.getCarModule().getMetaInfAsFile();
        if (metaInfFile != null) {
            File persistenceXmlFile = new File(metaInfFile, "persistence.xml");
            this.scopesHelper.changePersistenceScope(this.persistenceScope, persistenceXmlFile);
            this.modelHelper.changePersistenceXml(persistenceXmlFile);
            this.scopesHelper.getPersistenceScopes().addPropertyChangeListener(this.scopeListener);
        } else {
            this.scopesHelper.changePersistenceScope(null, null);
            this.modelHelper.changePersistenceXml(null);
        }
    }

    private void puChanged() {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                ProjectManager.mutex().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        Sources sources;
                        SourceGroup[] groups;
                        SourceGroup firstGroup;
                        FileObject fo;
                        ClassPath compile;
                        String approperties;
                        EditableProperties prop = AppClientPersistenceProvider.this.project.getUpdateHelper().getProperties("nbproject/project.properties");
                        String ap = prop.getProperty("annotation.processing.processors.list");
                        if (ap == null) {
                            ap = "";
                        }
                        if ((approperties = prop.getProperty("annotation.processing.processor.options")) == null) {
                            approperties = "";
                        }
                        boolean changed = false;
                        if (approperties.indexOf("eclipselink.canonicalmodel.use_static_factory") == -1) {
                            String toadd = (approperties.length() > 0 ? " " : "") + "-Aeclipselink.canonicalmodel.use_static_factory=false";
                            approperties = approperties + toadd;
                            prop.setProperty("annotation.processing.processor.options", approperties);
                            changed = true;
                        }
                        if (ap.length() > 0 && ap.indexOf("org.eclipse.persistence.internal.jpa.modelgen.CanonicalModelProcessor") == -1 && (compile = ClassPath.getClassPath((FileObject)(fo = (firstGroup = (groups = (sources = ProjectUtils.getSources((Project)AppClientPersistenceProvider.this.project)).getSourceGroups("java"))[0]).getRootFolder()), (String)"classpath/processor")).findResource("org/eclipse/persistence/internal/jpa/modelgen/CanonicalModelProcessor.class") != null) {
                            boolean turnOn = (ap = ap.trim()).length() == 0;
                            ap = ap + (ap.length() > 0 ? "," : "") + "org.eclipse.persistence.internal.jpa.modelgen.CanonicalModelProcessor";
                            prop.setProperty("annotation.processing.processors.list", ap);
                            changed = true;
                            if (turnOn) {
                                prop.setProperty("annotation.processing.run.all.processors", "false");
                            }
                        }
                        if (!"true".equals(prop.getProperty("annotation.processing.enabled.in.editor"))) {
                            prop.setProperty("annotation.processing.enabled.in.editor", "true");
                            changed = true;
                        }
                        if (changed) {
                            AppClientPersistenceProvider.this.project.getUpdateHelper().putProperties("nbproject/project.properties", prop);
                            try {
                                ProjectManager.getDefault().saveProject((Project)AppClientPersistenceProvider.this.project);
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            catch (IllegalArgumentException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                });
            }
        });
    }

    private final class ScopeImpl
    implements PersistenceScopeImplementation,
    EntityClassScopeImplementation {
        private ScopeImpl() {
        }

        public FileObject getPersistenceXml() {
            FileObject location = AppClientPersistenceProvider.this.getLocation();
            if (location == null) {
                return null;
            }
            return location.getFileObject("persistence.xml");
        }

        public ClassPath getClassPath() {
            return AppClientPersistenceProvider.this.getProjectSourcesClassPath();
        }

        public MetadataModel<EntityMappingsMetadata> getEntityMappingsModel(String persistenceUnitName) {
            return AppClientPersistenceProvider.this.modelHelper.getEntityMappingsModel(persistenceUnitName);
        }

        public MetadataModel<EntityMappingsMetadata> getEntityMappingsModel(boolean withDeps) {
            return AppClientPersistenceProvider.this.modelHelper.getDefaultEntityMappingsModel(withDeps);
        }
    }
}

