/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.payara.common.PayaraInstance;
import org.netbeans.modules.payara.common.PayaraLogger;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.CommandListWebServices;
import org.netbeans.modules.payara.tooling.admin.ResultList;
import org.netbeans.modules.payara.tooling.admin.ServerAdmin;
import org.netbeans.modules.payara.tooling.data.PayaraServer;

public class WSDesc {
    private static final Logger LOGGER = PayaraLogger.get(WSDesc.class);
    private static String WSDL_URL_EXTENSION = "?wsdl";
    private static String TEST_URL_EXTENSION = "?Tester";
    private final String wsdlUrl;
    private final String testUrl;
    private final String name;

    private static String buildWsdlUrl(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name shall not be null.");
        }
        StringBuilder sb = new StringBuilder(name.length() + WSDL_URL_EXTENSION.length());
        sb.append(name);
        sb.append(WSDL_URL_EXTENSION);
        return sb.toString();
    }

    private static String buildTestUrl(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name shall not be null.");
        }
        StringBuilder sb = new StringBuilder(name.length() + TEST_URL_EXTENSION.length());
        sb.append(name);
        sb.append(TEST_URL_EXTENSION);
        return sb.toString();
    }

    public static List<WSDesc> getWebServices(PayaraInstance instance) {
        List<WSDesc> wsList;
        List values = null;
        Future future = ServerAdmin.exec((PayaraServer)instance, (Command)new CommandListWebServices());
        try {
            ResultList result = (ResultList)future.get();
            values = result.getValue();
        }
        catch (InterruptedException | CancellationException | ExecutionException ee) {
            LOGGER.log(Level.INFO, ee.getMessage(), ee);
        }
        if (values != null && values.size() > 0) {
            wsList = new ArrayList<WSDesc>(values.size());
            for (String value : values) {
                wsList.add(new WSDesc(value));
            }
        } else {
            wsList = Collections.emptyList();
        }
        return wsList;
    }

    public WSDesc(String name) {
        this.name = name;
        this.wsdlUrl = WSDesc.buildWsdlUrl(name);
        this.testUrl = WSDesc.buildTestUrl(name);
    }

    public String getName() {
        return this.name;
    }

    public String getTestURL() {
        return this.testUrl;
    }

    public String getWsdlUrl() {
        return this.wsdlUrl;
    }
}

