/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ant;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.web.clientproject.env.CommonProjectHelper;
import org.netbeans.modules.web.clientproject.env.Licenses;
import org.netbeans.modules.web.clientproject.env.Values;
import org.netbeans.spi.project.support.ant.ui.CustomizerUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;

final class LicensePanelSupportImpl
extends Licenses
implements CustomizerUtilities.LicensePanelContentHandler {
    private String licenseName;
    private String licensePath;
    private String licenseContent;
    private Values evaluator;
    private CommonProjectHelper antHelper;

    public LicensePanelSupportImpl(Values evaluator, CommonProjectHelper antHelper, String licensePath, String licenseName) {
        this.evaluator = evaluator;
        this.antHelper = antHelper;
        this.licensePath = licensePath;
        this.licenseName = licenseName;
        this.licenseContent = null;
    }

    public String getProjectLicenseLocation() {
        return this.licensePath;
    }

    public String getGlobalLicenseName() {
        return this.licenseName;
    }

    public FileObject resolveProjectLocation(@NonNull String path) {
        String evaluated = this.evaluator.evaluate(path);
        if (evaluated != null) {
            return this.antHelper.resolveFileObject(evaluated);
        }
        return null;
    }

    public void setProjectLicenseLocation(@NullAllowed String newLocation) {
        this.licensePath = newLocation;
    }

    public void setGlobalLicenseName(@NullAllowed String newName) {
        this.licenseName = newName;
    }

    public String getDefaultProjectLicenseLocation() {
        return "./nbproject/licenseheader.txt";
    }

    public void setProjectLicenseContent(@NullAllowed String text) {
        this.licenseContent = text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"DM_DEFAULT_ENCODING"}, justification="No idea how to detect encoding properly, sorry")
    public void saveLicenseFile() throws IOException {
        if (this.licenseContent != null) {
            assert (this.licensePath != null);
            String evaluated = this.evaluator.evaluate(this.licensePath);
            assert (evaluated != null);
            File file = this.antHelper.resolveFile(evaluated);
            FileObject fo = !file.exists() ? FileUtil.createData((File)file) : FileUtil.toFileObject((File)file);
            try (OutputStream out = fo.getOutputStream();){
                FileUtil.copy((InputStream)new ByteArrayInputStream(this.licenseContent.getBytes()), (OutputStream)out);
            }
        }
    }

    @Override
    public void updateProperties(EditableProperties projectProperties) {
        if (this.licensePath != null) {
            projectProperties.setProperty("project.licensePath", this.licensePath);
        } else {
            projectProperties.remove((Object)"project.licensePath");
        }
        if (this.licenseName != null) {
            projectProperties.setProperty("project.license", this.licenseName);
        } else {
            projectProperties.remove((Object)"project.license");
        }
    }
}

