/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ui.wizard;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerManager;
import org.netbeans.modules.javaee.project.api.ui.UserProjectSettings;
import org.netbeans.modules.maven.j2ee.utils.Server;
import org.openide.WizardDescriptor;

public class ServerSelectionHelper {
    private final JComboBox serverModel;
    private final JComboBox j2eeVersion;
    private final ListCellRenderer delegate;
    private final J2eeModule.Type projectType;

    public ServerSelectionHelper(JComboBox serverModel, JComboBox j2eeVersion, J2eeModule.Type projectType) {
        this.serverModel = serverModel;
        this.projectType = projectType;
        this.delegate = j2eeVersion.getRenderer();
        this.j2eeVersion = j2eeVersion;
        this.j2eeVersion.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String profileName = null;
                if (value instanceof Profile) {
                    profileName = ((Profile)value).getDisplayName();
                }
                if (value instanceof String) {
                    profileName = (String)value;
                }
                return ServerSelectionHelper.this.delegate.getListCellRendererComponent(list, profileName, index, isSelected, cellHasFocus);
            }
        });
        this.initServerModel(null);
        this.updatePlatformVersionModel();
    }

    private void initServerModel(String serverToSelectInstanceID) {
        Server serverToSelect = null;
        ArrayList<Server> servers = new ArrayList<Server>();
        for (String instanceID : Deployment.getDefault().getServerInstanceIDs()) {
            if (!this.isServerInstanceValid(instanceID)) continue;
            Server server = new Server(instanceID);
            servers.add(server);
            if (serverToSelectInstanceID == null || !instanceID.equals(serverToSelectInstanceID)) continue;
            serverToSelect = server;
        }
        String lastUsedServer = UserProjectSettings.getDefault().getLastUsedServer();
        if (lastUsedServer != null) {
            serverToSelect = new Server(lastUsedServer);
        }
        Collections.sort(servers);
        servers.add(new Server("DEV-NULL"));
        this.serverModel.setModel(new DefaultComboBoxModel<Object>(servers.toArray()));
        if (serverToSelect != null) {
            this.serverModel.setSelectedItem(serverToSelect);
        }
        this.serverModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerSelectionHelper.this.updatePlatformVersionModel();
            }
        });
    }

    private void updatePlatformVersionModel() {
        Profile lastSelectedProfile = this.getSelectedProfile();
        String serverInstance = this.getSelectedServer().getServerInstanceID();
        TreeSet<Profile> profiles = new TreeSet<Profile>(Profile.UI_COMPARATOR);
        if ("DEV-NULL".equals(serverInstance)) {
            if (J2eeModule.Type.WAR.equals(this.projectType)) {
                profiles.add(Profile.JAKARTA_EE_8_WEB);
                profiles.add(Profile.JAVA_EE_8_WEB);
                profiles.add(Profile.JAVA_EE_7_WEB);
                profiles.add(Profile.JAVA_EE_6_WEB);
            } else {
                profiles.add(Profile.JAKARTA_EE_8_FULL);
                profiles.add(Profile.JAVA_EE_8_FULL);
                profiles.add(Profile.JAVA_EE_7_FULL);
                profiles.add(Profile.JAVA_EE_6_FULL);
            }
            profiles.add(Profile.JAVA_EE_5);
        } else {
            try {
                J2eePlatform pfm = this.findServerInstance(serverInstance).getJ2eePlatform();
                Set supported = pfm.getSupportedProfiles(this.projectType);
                profiles.addAll(this.findServerInstance(serverInstance).getJ2eePlatform().getSupportedProfiles(this.projectType));
            }
            catch (InstanceRemovedException ex) {
                this.initServerModel(null);
            }
            if (profiles.contains(Profile.J2EE_13)) {
                profiles.remove(Profile.J2EE_13);
            }
            if (profiles.contains(Profile.J2EE_14)) {
                profiles.remove(Profile.J2EE_14);
            }
            if (J2eeModule.Type.WAR.equals(this.projectType)) {
                profiles.remove(Profile.JAKARTA_EE_8_FULL);
                profiles.remove(Profile.JAVA_EE_8_FULL);
                profiles.remove(Profile.JAVA_EE_7_FULL);
                profiles.remove(Profile.JAVA_EE_6_FULL);
            } else {
                profiles.remove(Profile.JAKARTA_EE_8_WEB);
                profiles.remove(Profile.JAVA_EE_8_WEB);
                profiles.remove(Profile.JAVA_EE_7_WEB);
                profiles.remove(Profile.JAVA_EE_6_WEB);
            }
        }
        this.j2eeVersion.setModel(new DefaultComboBoxModel<Object>(profiles.toArray()));
        if (lastSelectedProfile != null && profiles.contains(lastSelectedProfile)) {
            this.j2eeVersion.setSelectedItem(lastSelectedProfile);
        }
    }

    public void addServerButtonPressed() {
        String addedServerInstanceID = ServerManager.showAddServerInstanceWizard();
        if (addedServerInstanceID != null) {
            this.initServerModel(addedServerInstanceID);
            this.updatePlatformVersionModel();
        }
    }

    public Profile getSelectedProfile() {
        return (Profile)this.j2eeVersion.getSelectedItem();
    }

    public void storeServerSettings(WizardDescriptor d) {
        Server wrapper = this.getSelectedServer();
        Profile profile = this.getSelectedProfile();
        String instanceID = null;
        String serverID = null;
        String version = null;
        if (wrapper != null) {
            instanceID = wrapper.getServerInstanceID();
            serverID = wrapper.getServerID();
        }
        if (profile != null) {
            version = profile.toPropertiesString();
        }
        if ("DEV-NULL".equals(instanceID)) {
            instanceID = null;
            serverID = null;
        }
        d.putProperty("netbeans.deployment.server.id", (Object)instanceID);
        d.putProperty("netbeans.hint.deploy.server", (Object)serverID);
        d.putProperty("netbeans.hint.j2eeVersion", (Object)version);
    }

    public Server getSelectedServer() {
        return (Server)this.serverModel.getSelectedItem();
    }

    private boolean isServerInstanceValid(String instanceID) {
        ServerInstance instance = this.findServerInstance(instanceID);
        try {
            if (instance != null && instance.getDisplayName() != null && instance.getJ2eePlatform().getSupportedTypes().contains(this.projectType)) {
                return true;
            }
        }
        catch (InstanceRemovedException ex) {
            return false;
        }
        return false;
    }

    private ServerInstance findServerInstance(String instanceID) {
        return Deployment.getDefault().getServerInstance(instanceID);
    }
}

