/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class ModifiersCheckHintError
extends HintErrorRule {
    private List<Hint> hints;
    private FileObject fileObject;
    private BaseDocument doc;
    private boolean currectClassHasAbstractMethod = false;

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        this.hints = hints;
        this.doc = context.doc;
        FileScope fileScope = context.fileScope;
        this.fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileScope != null && this.fileObject != null) {
            Collection<? extends ClassScope> declaredClasses = ModelUtils.getDeclaredClasses(fileScope);
            for (ClassScope classScope : declaredClasses) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.processClassScope(classScope);
            }
            Collection<? extends InterfaceScope> declaredInterfaces = ModelUtils.getDeclaredInterfaces(fileScope);
            for (InterfaceScope interfaceScope : declaredInterfaces) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.processInterfaceScope(interfaceScope);
            }
        }
    }

    public String getDisplayName() {
        return Bundle.ModifiersCheckHintDispName();
    }

    private void processClassScope(ClassScope classScope) {
        Collection<? extends FieldElement> declaredFields = classScope.getDeclaredFields();
        for (FieldElement fieldElement : declaredFields) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processFieldElement(fieldElement);
        }
        Collection<? extends MethodScope> declaredMethods = classScope.getDeclaredMethods();
        for (MethodScope methodScope : declaredMethods) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processMethodScope(methodScope);
        }
        if (this.currectClassHasAbstractMethod) {
            this.processPossibleAbstractClass(classScope);
        }
        this.currectClassHasAbstractMethod = false;
    }

    private void processFieldElement(FieldElement fieldElement) {
        PhpModifiers phpModifiers = fieldElement.getPhpModifiers();
        if (phpModifiers.isAbstract()) {
            String invalidModifier = "abstract";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, fieldElement.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidField(fieldElement.getName(), invalidModifier), fieldElement.getNameRange(), fixes));
        } else if (phpModifiers.isFinal()) {
            String invalidModifier = "final";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, fieldElement.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidField(fieldElement.getName(), invalidModifier), fieldElement.getNameRange(), fixes));
        }
    }

    private void processMethodScope(MethodScope methodScope) {
        PhpModifiers phpModifiers = methodScope.getPhpModifiers();
        if (phpModifiers.isAbstract() && phpModifiers.isFinal()) {
            ArrayList<HintFix> fixes = new ArrayList<HintFix>();
            fixes.add(new RemoveModifierFix(this.doc, "abstract", methodScope.getOffset()));
            fixes.add(new RemoveModifierFix(this.doc, "final", methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.AbstractFinalMethod(methodScope.getName()), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isAbstract() && methodScope.getBlockRange() != null) {
            List<HintFix> fixes = Collections.singletonList(new RemoveBodyFix(this.doc, methodScope));
            this.hints.add(new SimpleHint(Bundle.AbstractWithBlockMethod(methodScope.getName()), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isAbstract() && phpModifiers.isPrivate()) {
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, "private", methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.AbstractPrivateMethod(methodScope.getName()), methodScope.getNameRange(), fixes));
        }
        if (phpModifiers.isAbstract()) {
            this.currectClassHasAbstractMethod = true;
        }
    }

    private void processInterfaceScope(InterfaceScope interfaceScope) {
        Collection<? extends MethodScope> declaredMethods = interfaceScope.getDeclaredMethods();
        for (MethodScope methodScope : declaredMethods) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processInterfaceMethodScope(methodScope);
        }
        Collection<? extends ClassConstantElement> declaredConstants = interfaceScope.getDeclaredConstants();
        for (ClassConstantElement classConstantElement : declaredConstants) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processInterfaceClassConstant(classConstantElement);
        }
    }

    private void processInterfaceMethodScope(MethodScope methodScope) {
        PhpModifiers phpModifiers = methodScope.getPhpModifiers();
        if (phpModifiers.isPrivate()) {
            String invalidModifier = "private";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidIfaceMethod(methodScope.getName(), invalidModifier), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isProtected()) {
            String invalidModifier = "protected";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidIfaceMethod(methodScope.getName(), invalidModifier), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isFinal()) {
            String invalidModifier = "final";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidIfaceMethod(methodScope.getName(), invalidModifier), methodScope.getNameRange(), fixes));
        } else if (methodScope.getBlockRange() != null && methodScope.getBlockRange().getLength() != 1) {
            List<HintFix> fixes = Collections.singletonList(new RemoveBodyFix(this.doc, methodScope));
            this.hints.add(new SimpleHint(Bundle.IfaceMethodWithBlock(methodScope.getName()), methodScope.getNameRange(), fixes));
        }
    }

    private void processInterfaceClassConstant(ClassConstantElement classConstant) {
        PhpModifiers phpModifiers = classConstant.getPhpModifiers();
        if (phpModifiers.isPrivate()) {
            String invalidModifier = "private";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, classConstant.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidIfaceConstant(classConstant.getName(), invalidModifier), classConstant.getNameRange(), fixes));
        } else if (phpModifiers.isProtected()) {
            String invalidModifier = "protected";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, classConstant.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidIfaceConstant(classConstant.getName(), invalidModifier), classConstant.getNameRange(), fixes));
        }
    }

    private void processPossibleAbstractClass(ClassScope classScope) {
        List<HintFix> fixes;
        if (!classScope.isAbstract()) {
            fixes = Collections.singletonList(new AddModifierFix(this.doc, "abstract", classScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.PossibleAbstractClass(classScope.getName()), classScope.getNameRange(), fixes));
        }
        if (classScope.isFinal()) {
            fixes = Collections.singletonList(new RemoveModifierFix(this.doc, "final", classScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.FinalPossibleAbstractClass(classScope.getName()), classScope.getNameRange(), fixes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getStartOffset(BaseDocument doc, int elementOffset) {
        int retval;
        block6: {
            retval = 0;
            doc.readLock();
            try {
                TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, elementOffset);
                if (ts == null) break block6;
                ts.move(elementOffset);
                TokenId lastTokenId = null;
                while (ts.movePrevious()) {
                    Token t = ts.token();
                    if (t.id() != PHPTokenId.PHP_PUBLIC && t.id() != PHPTokenId.PHP_PROTECTED && t.id() != PHPTokenId.PHP_PRIVATE && t.id() != PHPTokenId.PHP_STATIC && t.id() != PHPTokenId.PHP_FINAL && t.id() != PHPTokenId.PHP_ABSTRACT && t.id() != PHPTokenId.PHP_FUNCTION && t.id() != PHPTokenId.WHITESPACE && t.id() != PHPTokenId.PHP_CLASS && t.id() != PHPTokenId.PHP_CONST) {
                        ts.moveNext();
                        if (lastTokenId == PHPTokenId.WHITESPACE) {
                            ts.moveNext();
                        }
                        retval = ts.offset();
                        break;
                    }
                    lastTokenId = t.id();
                }
            }
            finally {
                doc.readUnlock();
            }
        }
        return retval;
    }

    private class AddModifierFix
    extends AbstractHintFix {
        private final String modifier;
        private final int elementOffset;

        public AddModifierFix(BaseDocument doc, String modifier, int elementOffset) {
            super(doc);
            this.modifier = modifier;
            this.elementOffset = elementOffset;
        }

        public String getDescription() {
            return Bundle.AddModifierFixDesc(this.modifier);
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            int startOffset = ModifiersCheckHintError.getStartOffset(this.doc, this.elementOffset);
            int length = this.elementOffset - startOffset;
            String replaceText = this.modifier + " " + this.doc.getText(startOffset, length);
            edits.replace(startOffset, length, replaceText, true, 0);
            edits.apply();
        }
    }

    private class RemoveModifierFix
    extends AbstractHintFix {
        private final String modifier;
        private final int elementOffset;

        public RemoveModifierFix(BaseDocument doc, String modifier, int elementOffset) {
            super(doc);
            this.modifier = modifier;
            this.elementOffset = elementOffset;
        }

        public String getDescription() {
            return Bundle.RemoveModifierFixDesc(this.modifier);
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            int startOffset = ModifiersCheckHintError.getStartOffset(this.doc, this.elementOffset);
            int length = this.elementOffset - startOffset;
            String replaceText = this.doc.getText(startOffset, length).replace(this.modifier, "").replaceAll("^\\s+", "");
            edits.replace(startOffset, length, replaceText, true, 0);
            edits.apply();
        }
    }

    private class RemoveBodyFix
    extends AbstractHintFix {
        private final MethodScope methodScope;

        public RemoveBodyFix(BaseDocument doc, MethodScope methodScope) {
            super(doc);
            this.methodScope = methodScope;
        }

        public String getDescription() {
            return Bundle.RemoveBodyFixDesc(this.methodScope.getName());
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            edits.replace(this.methodScope.getBlockRange().getStart(), this.methodScope.getBlockRange().getLength(), ";", true, 0);
            edits.apply();
        }
    }

    private abstract class AbstractHintFix
    implements HintFix {
        protected final BaseDocument doc;

        public AbstractHintFix(BaseDocument doc) {
            this.doc = doc;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private class SimpleHint
    extends Hint {
        public SimpleHint(String description, OffsetRange range, List<HintFix> fixes) {
            super((Rule)ModifiersCheckHintError.this, description, ModifiersCheckHintError.this.fileObject, range, fixes, 500);
        }

        public SimpleHint(String description, OffsetRange range) {
            this(description, range, null);
        }
    }
}

