/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.lexer;

import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTopTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public final class PHPTopLexer
implements Lexer<PHPTopTokenId> {
    private final PHPTopColoringLexer scanner;
    private TokenFactory<PHPTopTokenId> tokenFactory;

    private PHPTopLexer(LexerRestartInfo<PHPTopTokenId> info) {
        this.scanner = new PHPTopColoringLexer(info, (State)((Object)info.state()));
        this.tokenFactory = info.tokenFactory();
    }

    public static synchronized PHPTopLexer create(LexerRestartInfo<PHPTopTokenId> info) {
        return new PHPTopLexer(info);
    }

    public Token<PHPTopTokenId> nextToken() {
        PHPTopTokenId tokenId = this.scanner.nextToken();
        Token token = null;
        if (tokenId != null) {
            token = this.tokenFactory.createToken((TokenId)tokenId);
        }
        return token;
    }

    public Object state() {
        return this.scanner.getState();
    }

    public void release() {
    }

    private static class PHPTopColoringLexer {
        private State state;
        private final LexerInput input;

        public PHPTopColoringLexer(LexerRestartInfo<PHPTopTokenId> info, State state) {
            this.input = info.input();
            this.state = state == null ? State.OUTER : state;
        }

        /*
         * Enabled aggressive block sorting
         */
        public PHPTopTokenId nextToken() {
            int c = this.input.read();
            int hereDocStart = -1;
            CharSequence hereDocDelimiter = null;
            int hereDocDelimiterLenght = 0;
            if (c == -1) {
                return null;
            }
            while (c != -1) {
                char cc = (char)c;
                CharSequence text = this.input.readText();
                int textLength = text.length();
                switch (this.state) {
                    case OUTER: {
                        if (cc != '<') break;
                        this.state = State.AFTER_GT;
                        break;
                    }
                    case AFTER_GT: {
                        switch (cc) {
                            case '?': {
                                this.state = State.IN_PHP_DELIMITER_SHORT;
                                if (textLength <= 2) break;
                                this.input.backup(2);
                                return PHPTopTokenId.T_HTML;
                            }
                            default: {
                                this.state = State.OUTER;
                                break;
                            }
                        }
                        break;
                    }
                    case IN_PHP_DELIMITER_SHORT: {
                        if (cc == 'p') {
                            this.state = State.IN_PHP_DELIMITER;
                            break;
                        }
                        if (this.input.readLength() != 3) break;
                        this.state = State.IN_PHP;
                        this.input.backup(1);
                        return PHPTopTokenId.T_PHP_OPEN_DELIMITER;
                    }
                    case IN_PHP_DELIMITER: {
                        if (textLength == 5) {
                            if (text.charAt(textLength - 3) != 'p' || text.charAt(textLength - 2) != 'h' || text.charAt(textLength - 1) != 'p') {
                                this.input.backup(3);
                            }
                            this.state = State.IN_PHP;
                            return PHPTopTokenId.T_PHP_OPEN_DELIMITER;
                        }
                        if (!Character.isWhitespace(cc)) break;
                        this.input.backup(textLength - 2);
                        this.state = State.IN_PHP;
                        return PHPTopTokenId.T_PHP_OPEN_DELIMITER;
                    }
                    case IN_PHP: {
                        switch (cc) {
                            case '?': {
                                this.state = State.IN_END_DELIMITER;
                                break;
                            }
                            case '\'': {
                                this.state = State.IN_PHP_CONSTANT_STRING;
                                break;
                            }
                            case '\"': {
                                this.state = State.IN_PHP_STRING;
                                break;
                            }
                            case '<': {
                                if (this.input.readLength() <= 3 || text.charAt(textLength - 3) != '<' || text.charAt(textLength - 2) != '<' || !Character.isWhitespace(text.charAt(textLength - 4))) break;
                                this.state = State.IN_PHP_HEREDOC_STRING;
                                hereDocStart = textLength - 3;
                                break;
                            }
                        }
                        break;
                    }
                    case IN_PHP_CONSTANT_STRING: {
                        char before;
                        if (cc != '\'' || (before = text.charAt(this.input.readLength() - 2)) == '\\') break;
                        this.state = State.IN_PHP;
                        break;
                    }
                    case IN_PHP_STRING: {
                        char before;
                        if (cc != '\"' || (before = text.charAt(this.input.readLength() - 2)) == '\\') break;
                        this.state = State.IN_PHP;
                        break;
                    }
                    case IN_END_DELIMITER: {
                        if (cc == '>') {
                            if (textLength == 2) {
                                this.state = State.OUTER;
                                return PHPTopTokenId.T_PHP_CLOSE_DELIMITER;
                            }
                            this.input.backup(2);
                            return PHPTopTokenId.T_PHP;
                        }
                    }
                    case IN_PHP_HEREDOC_STRING: {
                        switch (cc) {
                            case '\n': 
                            case '\r': {
                                if (hereDocStart > -1) {
                                    int delimiterStart = hereDocStart + 3;
                                    char delimiterChar = text.charAt(delimiterStart);
                                    while (delimiterChar == ' ' && ++delimiterStart < textLength) {
                                        delimiterChar = text.charAt(delimiterStart);
                                    }
                                    if (delimiterChar != '\n' && delimiterChar != '\r') {
                                        hereDocDelimiter = text.subSequence(delimiterStart, text.length() - 1);
                                        if (hereDocDelimiter.charAt(0) == '\'' || hereDocDelimiter.charAt(0) == '\"') {
                                            hereDocDelimiter = hereDocDelimiter.subSequence(1, hereDocDelimiter.length() - 1);
                                        }
                                        hereDocDelimiterLenght = hereDocDelimiter.length();
                                        hereDocStart = -1;
                                        break;
                                    }
                                    this.state = State.IN_PHP;
                                    break;
                                }
                                if (text.charAt(textLength - 2) != ';' || text.charAt(textLength - 3 - hereDocDelimiterLenght) != '\r' && text.charAt(textLength - 3 - hereDocDelimiterLenght) != '\n' || !TokenUtilities.textEquals((CharSequence)hereDocDelimiter, (CharSequence)text.subSequence(textLength - 2 - hereDocDelimiterLenght, textLength - 2))) break;
                                this.state = State.IN_PHP;
                                break;
                            }
                        }
                        break;
                    }
                }
                c = this.input.read();
            }
            switch (this.state) {
                case IN_PHP: 
                case IN_PHP_CONSTANT_STRING: 
                case IN_PHP_STRING: 
                case IN_PHP_HEREDOC_STRING: {
                    return PHPTopTokenId.T_PHP;
                }
                case IN_PHP_DELIMITER_SHORT: 
                case IN_PHP_DELIMITER: {
                    return PHPTopTokenId.T_PHP_OPEN_DELIMITER;
                }
            }
            return PHPTopTokenId.T_HTML;
        }

        Object getState() {
            return new Object();
        }
    }

    private static enum State {
        OUTER,
        AFTER_GT,
        IN_PHP_DELIMITER_SHORT,
        IN_PHP_DELIMITER,
        IN_PHP_STRING,
        IN_PHP_CONSTANT_STRING,
        IN_PHP_HEREDOC_STRING,
        IN_END_DELIMITER,
        AFTER_QUESTION_MARK,
        IN_TEMPLATE_CONTROL,
        IN_PHP;

    }
}

