/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.lang;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.debug.DebuggerTags;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ProvidedTags;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.lang.JSFileTypeDetector;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.ScriptNode;
import com.oracle.truffle.js.nodes.access.InitErrorObjectNodeFactory;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.function.FunctionRootNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.AbstractJavaScriptLanguage;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSAgent;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSContextOptions;
import com.oracle.truffle.js.runtime.JSEngine;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.JSScope;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.truffleinterop.JavaScriptLanguageView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.Context;

@ProvidedTags(value={StandardTags.StatementTag.class, StandardTags.RootTag.class, StandardTags.RootBodyTag.class, StandardTags.ExpressionTag.class, StandardTags.CallTag.class, StandardTags.ReadVariableTag.class, StandardTags.WriteVariableTag.class, StandardTags.TryBlockTag.class, DebuggerTags.AlwaysHalt.class, JSTags.ObjectAllocationTag.class, JSTags.BinaryOperationTag.class, JSTags.UnaryOperationTag.class, JSTags.WriteVariableTag.class, JSTags.ReadElementTag.class, JSTags.WriteElementTag.class, JSTags.ReadPropertyTag.class, JSTags.WritePropertyTag.class, JSTags.ReadVariableTag.class, JSTags.LiteralTag.class, JSTags.FunctionCallTag.class, JSTags.BuiltinRootTag.class, JSTags.EvalCallTag.class, JSTags.ControlFlowRootTag.class, JSTags.ControlFlowBlockTag.class, JSTags.ControlFlowBranchTag.class, JSTags.DeclareTag.class, JSTags.InputNodeTag.class})
@TruffleLanguage.Registration(id="js", name="JavaScript", implementationName="GraalVM JavaScript", characterMimeTypes={"application/javascript", "text/javascript", "application/javascript+module"}, defaultMimeType="application/javascript", contextPolicy=TruffleLanguage.ContextPolicy.SHARED, dependentLanguages={"regex"}, fileTypeDetectors={JSFileTypeDetector.class})
public final class JavaScriptLanguage
extends AbstractJavaScriptLanguage {
    public static final String TEXT_MIME_TYPE = "text/javascript";
    public static final String APPLICATION_MIME_TYPE = "application/javascript";
    public static final String MODULE_MIME_TYPE = "application/javascript+module";
    public static final String SCRIPT_SOURCE_NAME_SUFFIX = ".js";
    public static final String MODULE_SOURCE_NAME_SUFFIX = ".mjs";
    public static final String INTERNAL_SOURCE_URL_PREFIX = "internal:";
    public static final String NAME = "JavaScript";
    public static final String IMPLEMENTATION_NAME = "GraalVM JavaScript";
    public static final String ID = "js";
    private volatile JSContext languageContext;
    private volatile boolean multiContext;
    private final Assumption promiseJobsQueueEmptyAssumption = Truffle.getRuntime().createAssumption("PromiseJobsQueueEmpty");
    public static final OptionDescriptors OPTION_DESCRIPTORS;
    private static final OptionKey<?>[] PREINIT_CONTEXT_PATCHABLE_OPTIONS;

    @CompilerDirectives.TruffleBoundary
    public CallTarget parse(TruffleLanguage.ParsingRequest parsingRequest) {
        Source source = parsingRequest.getSource();
        List argumentNames = parsingRequest.getArgumentNames();
        final JSContext context = this.getJSContext();
        final ScriptNode program = JavaScriptLanguage.parseScript(context, source, "", "", argumentNames);
        if (context.isOptionParseOnly()) {
            return JavaScriptLanguage.createEmptyScript(context).getCallTarget();
        }
        RootNode rootNode = new RootNode(this){
            @Node.Child
            private DirectCallNode directCallNode;
            @Node.Child
            private ExportValueNode exportValueNode;
            @Node.Child
            private ImportValueNode importValueNode;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<JSRealm> contextReference;
            {
                super(x0);
                this.directCallNode = DirectCallNode.create((CallTarget)program.getCallTarget());
                this.exportValueNode = ExportValueNode.create();
                this.importValueNode = ImportValueNode.create();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object execute(VirtualFrame frame) {
                if (this.contextReference == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.contextReference = this.lookupContextReference(JavaScriptLanguage.class);
                }
                JSRealm realm = (JSRealm)this.contextReference.get();
                assert (realm.getContext() == context) : "unexpected JSContext";
                try {
                    JavaScriptLanguage.this.interopBoundaryEnter(realm);
                    Object[] arguments = frame.getArguments();
                    for (int i = 0; i < arguments.length; ++i) {
                        arguments[i] = this.importValueNode.executeWithTarget(arguments[i]);
                    }
                    arguments = program.argumentsToRunWithArguments(realm, arguments);
                    Object result = this.directCallNode.call(arguments);
                    Object object = this.exportValueNode.execute(result);
                    return object;
                }
                finally {
                    JavaScriptLanguage.this.interopBoundaryExit(realm);
                }
            }

            public boolean isInternal() {
                return true;
            }

            protected boolean isInstrumentable() {
                return false;
            }
        };
        return Truffle.getRuntime().createCallTarget(rootNode);
    }

    @CompilerDirectives.TruffleBoundary
    private static ScriptNode createEmptyScript(JSContext context) {
        return ScriptNode.fromFunctionData(context, JSFunction.createEmptyFunctionData(context));
    }

    protected ExecutableNode parse(TruffleLanguage.InlineParsingRequest request) throws Exception {
        final Source source = request.getSource();
        final MaterializedFrame requestFrame = request.getFrame();
        final JSContext context = this.getJSContext();
        final boolean strict = JavaScriptLanguage.isStrictLocation(request.getLocation());
        ExecutableNode executableNode = new ExecutableNode(this){
            @Node.Child
            private JavaScriptNode expression;
            @Node.Child
            private ExportValueNode exportValueNode;
            {
                super(x0);
                this.expression = (JavaScriptNode)this.insert(JavaScriptLanguage.parseInlineScript(context, source, requestFrame, strict));
                this.exportValueNode = ExportValueNode.create();
            }

            public Object execute(VirtualFrame frame) {
                assert (JavaScriptLanguage.getCurrentJSRealm().getContext() == context) : "unexpected JSContext";
                Object result = this.expression.execute(frame);
                return this.exportValueNode.execute(result);
            }
        };
        return executableNode;
    }

    private static boolean isStrictLocation(Node location) {
        RootNode rootNode;
        if (location != null && (rootNode = location.getRootNode()) instanceof FunctionRootNode) {
            return ((FunctionRootNode)rootNode).getFunctionData().isStrict();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    protected static ScriptNode parseScript(JSContext context, Source code, String prolog, String epilog, List<String> argumentNames) {
        boolean profileTime = context.getContextOptions().isProfileTime();
        long startTime = profileTime ? System.nanoTime() : 0L;
        try {
            String[] arguments = null;
            if (!argumentNames.isEmpty()) {
                arguments = argumentNames.toArray(new String[0]);
            }
            ScriptNode scriptNode = context.getEvaluator().parseScript(context, code, prolog, epilog, arguments);
            return scriptNode;
        }
        finally {
            if (profileTime) {
                context.getTimeProfiler().printElapsed(startTime, "parsing " + code.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    protected static JavaScriptNode parseInlineScript(JSContext context, Source code, MaterializedFrame lexicalContextFrame, boolean strict) {
        boolean profileTime = context.getContextOptions().isProfileTime();
        long startTime = profileTime ? System.nanoTime() : 0L;
        try {
            JavaScriptNode javaScriptNode = context.getEvaluator().parseInlineScript(context, code, lexicalContextFrame, strict);
            return javaScriptNode;
        }
        finally {
            if (profileTime) {
                context.getTimeProfiler().printElapsed(startTime, "parsing " + code.getName());
            }
        }
    }

    protected JSRealm createContext(TruffleLanguage.Env env) {
        JSContext context = this.languageContext;
        if (context == null) {
            context = this.initLanguageContext(env);
        }
        JSRealm realm = context.createRealm(env);
        if (env.out() != realm.getOutputStream()) {
            realm.setOutputWriter(null, env.out());
        }
        if (env.err() != realm.getErrorStream()) {
            realm.setErrorWriter(null, env.err());
        }
        return realm;
    }

    private synchronized JSContext initLanguageContext(TruffleLanguage.Env env) {
        JSContext newContext;
        JSContext curContext = this.languageContext;
        if (curContext != null) {
            assert (curContext.getContextOptions().equals(JSContextOptions.fromOptionValues(env.getOptions())));
            return curContext;
        }
        this.languageContext = newContext = this.newJSContext(env);
        return newContext;
    }

    private JSContext newJSContext(TruffleLanguage.Env env) {
        return JSEngine.createJSContext(this, env);
    }

    protected void initializeContext(JSRealm realm) {
        realm.initialize();
    }

    protected boolean patchContext(JSRealm realm, TruffleLanguage.Env newEnv) {
        assert (realm.getContext().getLanguage() == this);
        if (JavaScriptLanguage.optionsAllowPreInitializedContext(realm.getEnv(), newEnv) && realm.patchContext(newEnv)) {
            return true;
        }
        this.languageContext = null;
        return false;
    }

    private static boolean optionsAllowPreInitializedContext(TruffleLanguage.Env preinitEnv, TruffleLanguage.Env env) {
        OptionValues preinitOptions = preinitEnv.getOptions();
        OptionValues options = env.getOptions();
        if (!preinitOptions.hasSetOptions() && !options.hasSetOptions()) {
            return true;
        }
        if (preinitOptions.equals(options)) {
            return true;
        }
        assert (preinitOptions.getDescriptors().equals(options.getDescriptors()));
        List<OptionKey<?>> ignoredOptions = Arrays.asList(PREINIT_CONTEXT_PATCHABLE_OPTIONS);
        for (OptionDescriptor descriptor : options.getDescriptors()) {
            OptionKey key = descriptor.getKey();
            if (!preinitOptions.hasBeenSet(key) && !options.hasBeenSet(key) || ignoredOptions.contains(key) || preinitOptions.get(key).equals(options.get(key))) continue;
            return false;
        }
        return true;
    }

    protected void disposeContext(JSRealm realm) {
        CompilerAsserts.neverPartOfCompilation();
        JSContext context = realm.getContext();
        JSContextOptions options = context.getContextOptions();
        if (options.isProfileTime() && options.isProfileTimePrintCumulative()) {
            context.getTimeProfiler().printCumulative();
        }
        realm.setGlobalObject(Undefined.instance);
    }

    protected void initializeMultipleContexts() {
        this.multiContext = true;
    }

    @Override
    public boolean isMultiContext() {
        return this.multiContext;
    }

    protected boolean areOptionsCompatible(OptionValues firstOptions, OptionValues newOptions) {
        return firstOptions.equals(newOptions);
    }

    protected OptionDescriptors getOptionDescriptors() {
        return OPTION_DESCRIPTORS;
    }

    protected boolean isVisible(JSRealm realm, Object value) {
        return value != Undefined.instance;
    }

    protected Object getLanguageView(JSRealm context, Object value) {
        return JavaScriptLanguageView.create(value);
    }

    protected Iterable<Scope> findLocalScopes(JSRealm realm, Node node, Frame frame) {
        return JSScope.createLocalScopes(node, frame == null ? null : frame.materialize());
    }

    protected Iterable<Scope> findTopScopes(JSRealm realm) {
        return JSScope.createGlobalScopes(realm);
    }

    public static JSContext getJSContext(Context context) {
        return JavaScriptLanguage.getJSRealm(context).getContext();
    }

    public static JSRealm getJSRealm(Context context) {
        context.enter();
        try {
            context.initialize(ID);
            JSRealm jSRealm = (JSRealm)JavaScriptLanguage.getCurrentContext(JavaScriptLanguage.class);
            return jSRealm;
        }
        finally {
            context.leave();
        }
    }

    public void interopBoundaryEnter(JSRealm realm) {
        realm.getAgent().interopBoundaryEnter();
    }

    public void interopBoundaryExit(JSRealm realm) {
        JSAgent agent = realm.getAgent();
        if (agent.interopBoundaryExit()) {
            if (!this.promiseJobsQueueEmptyAssumption.isValid()) {
                agent.processAllPromises(true);
            }
            if (realm.getContext().getContextOptions().isTestV8Mode()) {
                JavaScriptLanguage.processTimeoutCallbacks(realm);
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void processTimeoutCallbacks(JSRealm realm) {
        List callbackList;
        JSAgent agent = realm.getAgent();
        while ((callbackList = (List)realm.getEmbedderData()) != null && !callbackList.isEmpty()) {
            realm.setEmbedderData(null);
            for (Object callback : callbackList) {
                JSRuntime.call(callback, Undefined.instance, JSArguments.EMPTY_ARGUMENTS_ARRAY);
            }
            agent.processAllPromises(true);
        }
    }

    public Assumption getPromiseJobsQueueEmptyAssumption() {
        return this.promiseJobsQueueEmptyAssumption;
    }

    public JSContext getJSContext() {
        return this.languageContext;
    }

    public boolean bindMemberFunctions() {
        return this.getJSContext().getContextOptions().bindMemberFunctions();
    }

    public int getAsyncStackDepth() {
        return super.getAsynchronousStackDepth();
    }

    private static void ensureErrorClassesInitialized() {
        if (JSConfig.SubstrateVM) {
            return;
        }
        try {
            Class.forName(Errors.class.getName());
            Class.forName(JSException.class.getName());
            Class.forName(TruffleStackTrace.class.getName());
            Class.forName(TruffleStackTraceElement.class.getName());
            Class.forName(InitErrorObjectNodeFactory.DefineStackPropertyNodeGen.class.getName());
            Class.forName(TryCatchNode.GetErrorObjectNode.class.getName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        ArrayList<OptionDescriptor> options = new ArrayList<OptionDescriptor>();
        JSContextOptions.describeOptions(options);
        OPTION_DESCRIPTORS = OptionDescriptors.create(options);
        JavaScriptLanguage.ensureErrorClassesInitialized();
        PREINIT_CONTEXT_PATCHABLE_OPTIONS = new OptionKey[]{JSContextOptions.ARRAY_SORT_INHERITED, JSContextOptions.TIMER_RESOLUTION, JSContextOptions.SHELL, JSContextOptions.V8_COMPATIBILITY_MODE, JSContextOptions.GLOBAL_PROPERTY, JSContextOptions.GLOBAL_ARGUMENTS, JSContextOptions.SCRIPTING, JSContextOptions.DIRECT_BYTE_BUFFER, JSContextOptions.INTL_402, JSContextOptions.LOAD, JSContextOptions.PRINT, JSContextOptions.CONSOLE, JSContextOptions.PERFORMANCE, JSContextOptions.CLASS_FIELDS, JSContextOptions.REGEXP_STATIC_RESULT};
    }
}

