/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

public class ServerInstanceLookup
extends Lookup {
    private final ServerInstance instance;
    private final DeploymentFactory factory;
    private final Target target;

    public ServerInstanceLookup(ServerInstance instance, DeploymentFactory factory, Target target) {
        assert (instance != null);
        assert (factory != null);
        this.instance = instance;
        this.factory = factory;
        this.target = target;
    }

    public <T> T lookup(Class<T> clazz) {
        if (DeploymentFactory.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.factory);
        }
        if (DeploymentManager.class.isAssignableFrom(clazz)) {
            if (this.instance.isConnected()) {
                return clazz.cast(this.instance.getDeploymentManager());
            }
            try {
                return clazz.cast(this.instance.getDisconnectedDeploymentManager());
            }
            catch (DeploymentManagerCreationException dmce) {
                Exceptions.printStackTrace((Throwable)dmce);
            }
        } else if (this.target != null && Target.class.isAssignableFrom(clazz)) {
            return clazz.cast(this.target);
        }
        return null;
    }

    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        if (DeploymentFactory.class.isAssignableFrom(template.getType())) {
            return new SimpleResult<DeploymentFactory>(this.factory);
        }
        if (DeploymentManager.class.isAssignableFrom(template.getType())) {
            return new DeploymentManagerResult(this.instance);
        }
        if (Target.class.isAssignableFrom(template.getType())) {
            return new SimpleResult<Target>(this.target);
        }
        return new EmptyResult();
    }

    private static class DeploymentManagerResult
    extends AbstractResult<DeploymentManager>
    implements ChangeListener {
        private final ServerInstance instance;
        private final List<LookupListener> listeners = new ArrayList<LookupListener>();

        public DeploymentManagerResult(ServerInstance instance) {
            this.instance = instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLookupListener(LookupListener l) {
            if (l == null) {
                return;
            }
            List<LookupListener> list = this.listeners;
            synchronized (list) {
                if (this.listeners.isEmpty()) {
                    this.instance.addManagerChangeListener(this);
                }
                this.listeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLookupListener(LookupListener l) {
            if (l == null) {
                return;
            }
            List<LookupListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(l);
                if (this.listeners.isEmpty()) {
                    this.instance.removeManagerChangeListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            ArrayList<LookupListener> toFire = new ArrayList<LookupListener>();
            List<LookupListener> list = this.listeners;
            synchronized (list) {
                toFire.addAll(this.listeners);
            }
            for (LookupListener listener : toFire) {
                listener.resultChanged(new LookupEvent((Lookup.Result)this));
            }
        }

        @Override
        public DeploymentManager getInstance() {
            if (this.instance.isConnected()) {
                return this.instance.getDeploymentManager();
            }
            try {
                return this.instance.getDisconnectedDeploymentManager();
            }
            catch (DeploymentManagerCreationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }
    }

    private static class SimpleResult<T>
    extends AbstractResult<T> {
        private final T instance;

        public SimpleResult(T instance) {
            this.instance = instance;
        }

        public void addLookupListener(LookupListener l) {
        }

        public void removeLookupListener(LookupListener l) {
        }

        @Override
        public T getInstance() {
            return this.instance;
        }
    }

    private static abstract class AbstractResult<T>
    extends Lookup.Result<T> {
        public abstract T getInstance();

        public synchronized Collection<? extends T> allInstances() {
            T instance = this.getInstance();
            if (instance == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(instance);
        }

        public synchronized Set<Class<? extends T>> allClasses() {
            T instance = this.getInstance();
            if (instance == null) {
                return Collections.emptySet();
            }
            Class<?> clazz = instance.getClass();
            return Collections.singleton(clazz);
        }

        public synchronized Collection<? extends Lookup.Item<T>> allItems() {
            T instance = this.getInstance();
            if (instance == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(Lookups.lookupItem(instance, null));
        }
    }

    private static final class EmptyResult<T>
    extends Lookup.Result<T> {
        private EmptyResult() {
        }

        public void addLookupListener(LookupListener l) {
        }

        public void removeLookupListener(LookupListener l) {
        }

        public Collection<? extends T> allInstances() {
            return Collections.emptyList();
        }
    }
}

