/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.extension;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.jd.gui.util.exception.ExceptionUtil;

public class ExtensionService {
    protected static final ExtensionService EXTENSION_SERVICE = new ExtensionService();
    protected static final UrlComparator URL_COMPARATOR = new UrlComparator();
    protected ClassLoader extensionClassLoader;

    public static ExtensionService getInstance() {
        return EXTENSION_SERVICE;
    }

    protected ExtensionService() {
        block4: {
            try {
                URI jarUri = ExtensionService.class.getProtectionDomain().getCodeSource().getLocation().toURI();
                File baseDirectory = new File(jarUri).getParentFile();
                File extDirectory = new File(baseDirectory, "ext");
                if (extDirectory.exists() && extDirectory.isDirectory()) {
                    ArrayList<URL> urls = new ArrayList<URL>();
                    this.searchJarAndMetaInf(urls, extDirectory);
                    if (!urls.isEmpty()) {
                        URL[] array = urls.toArray(new URL[urls.size()]);
                        Arrays.sort(array, URL_COMPARATOR);
                        this.extensionClassLoader = new URLClassLoader(array, ExtensionService.class.getClassLoader());
                    }
                }
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block4;
                throw new AssertionError();
            }
        }
        this.extensionClassLoader = ExtensionService.class.getClassLoader();
    }

    protected void searchJarAndMetaInf(List<URL> urls, File directory) throws Exception {
        File metaInf = new File(directory, "META-INF");
        if (metaInf.exists() && metaInf.isDirectory()) {
            urls.add(directory.toURI().toURL());
        } else {
            for (File child : directory.listFiles()) {
                if (child.isDirectory()) {
                    this.searchJarAndMetaInf(urls, child);
                    continue;
                }
                if (!child.getName().toLowerCase().endsWith(".jar")) continue;
                urls.add(new URL("jar", "", child.toURI().toURL().toString() + "!/"));
            }
        }
    }

    public <T> Collection<T> load(Class<T> service) {
        ArrayList<T> list = new ArrayList<T>();
        Iterator<T> iterator = ServiceLoader.load(service, this.extensionClassLoader).iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    protected static class UrlComparator
    implements Comparator<URL> {
        protected UrlComparator() {
        }

        @Override
        public int compare(URL url1, URL url2) {
            return url1.getPath().compareTo(url2.getPath());
        }
    }
}

