/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.Utils;
import java.util.Objects;

public class IndexInsnNode
extends InsnNode {
    private final Object index;

    public IndexInsnNode(InsnType type, Object index, int argCount) {
        super(type, argCount);
        this.index = index;
    }

    public Object getIndex() {
        return this.index;
    }

    @Override
    public IndexInsnNode copy() {
        return this.copyCommonParams(new IndexInsnNode(this.insnType, this.index, this.getArgsCount()));
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IndexInsnNode) || !super.isSame(obj)) {
            return false;
        }
        IndexInsnNode other = (IndexInsnNode)obj;
        return Objects.equals(this.index, other.index);
    }

    @Override
    public String toString() {
        switch (this.insnType) {
            case CAST: 
            case CHECK_CAST: {
                return InsnUtils.formatOffset(this.offset) + ": " + InsnUtils.insnTypeToString(this.insnType) + this.getResult() + " = (" + InsnUtils.indexToString(this.index) + ") " + Utils.listToString(this.getArguments());
            }
        }
        return super.toString() + ' ' + InsnUtils.indexToString(this.index);
    }
}

