/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.impl;

import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.SendMessageStatusListener;
import net.i2p.data.i2cp.MessageId;
import net.i2p.util.Log;

class MessageState {
    private final I2PAppContext _context;
    private final Log _log;
    private final long _nonce;
    private final String _prefix;
    private MessageId _id;
    private final long _created;
    private final long _expires;
    private final SendMessageStatusListener _listener;
    private final I2PSession _session;
    private State _state = State.INIT;

    public MessageState(I2PAppContext ctx, long nonce, String prefix) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(MessageState.class);
        this._nonce = nonce;
        this._prefix = prefix + '[' + this._nonce + "]: ";
        this._created = ctx.clock().now();
        this._expires = this._created + 60000L;
        this._listener = null;
        this._session = null;
    }

    public MessageState(I2PAppContext ctx, long nonce, I2PSession session, long expires, SendMessageStatusListener listener) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(MessageState.class);
        this._nonce = nonce;
        this._prefix = session.toString() + " [" + this._nonce + "]: ";
        this._created = ctx.clock().now();
        this._expires = expires;
        this._listener = listener;
        this._session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(int status) {
        State newState;
        State oldState;
        MessageState messageState = this;
        synchronized (messageState) {
            oldState = this._state;
            this.locked_update(status);
            newState = this._state;
            this.notifyAll();
        }
        if (this._listener != null && oldState != newState && this._expires > this._context.clock().now()) {
            this._listener.messageStatus(this._session, this._nonce, status);
        }
    }

    public void setMessageId(MessageId id) {
        this._id = id;
    }

    public MessageId getMessageId() {
        return this._id;
    }

    public long getElapsed() {
        return this._context.clock().now() - this._created;
    }

    public long getExpires() {
        return this._expires;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAccept(long expiration) throws InterruptedException {
        while (true) {
            long timeToWait;
            if ((timeToWait = expiration - this._context.clock().now()) <= 0L) {
                if (this._log.shouldLog(30)) {
                    this._log.warn(this._prefix + "Expired waiting for the status");
                }
                return;
            }
            MessageState messageState = this;
            synchronized (messageState) {
                if (this._state != State.INIT) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug(this._prefix + "Received a confirm (one way or the other)");
                    }
                    return;
                }
                if (timeToWait > 5000L) {
                    timeToWait = 5000L;
                }
                this.wait(timeToWait);
            }
        }
    }

    private void locked_update(int status) {
        switch (status) {
            case 1: {
                if (this._state != State.INIT) break;
                this._state = State.ACCEPTED;
                break;
            }
            case 3: 
            case 5: {
                if (this._state == State.FAIL || this._state == State.SUCCESS) break;
                this._state = State.PROBABLE_FAIL;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 256: {
                if (this._state == State.SUCCESS) break;
                this._state = State.FAIL;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                this._state = State.SUCCESS;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasAccepted() {
        MessageState messageState = this;
        synchronized (messageState) {
            return this._state != State.INIT && this._state != State.FAIL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasSuccessful() {
        MessageState messageState = this;
        synchronized (messageState) {
            return this._state == State.SUCCESS;
        }
    }

    public void cancel() {
        this.receive(256);
    }

    private static enum State {
        INIT,
        ACCEPTED,
        PROBABLE_FAIL,
        FAIL,
        SUCCESS;

    }
}

