/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto.ratchet;

import net.i2p.data.Destination;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2cp.SessionConfig;
import net.i2p.router.ClientMessage;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

class ACKTimer
extends SimpleTimer2.TimedEvent {
    private final RouterContext _context;
    private final Log _log;
    private final Destination _from;
    private final Destination _to;
    private static final long EXPIRATION = 60000L;

    public ACKTimer(RouterContext context, Destination from, Destination to) {
        super(context.simpleTimer2());
        this._context = context;
        this._log = context.logManager().getLog(ACKTimer.class);
        this._from = from;
        this._to = to;
    }

    @Override
    public void timeReached() {
        SessionConfig config = this._context.clientManager().getClientSessionConfig(this._from);
        if (config == null) {
            return;
        }
        long now = this._context.clock().now();
        long exp = now + 60000L;
        MessageId msgID = new MessageId();
        ClientMessage cmsg = new ClientMessage(this._to, null, config, this._from, msgID, 0L, exp, 0);
        this._context.clientMessagePool().add(cmsg, true);
        if (this._log.shouldInfo()) {
            this._log.info("Sent ratchet ack from " + this._from.toBase32() + " to " + this._to.toBase32());
        }
    }
}

