/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.descriptor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.net.URI;
import java.util.List;
import org.gradle.api.internal.artifacts.repositories.descriptor.RepositoryDescriptor;

abstract class UrlRepositoryDescriptor
extends RepositoryDescriptor {
    public final URI url;
    public final ImmutableList<String> metadataSources;
    public final boolean authenticated;
    public final ImmutableList<String> authenticationSchemes;

    protected UrlRepositoryDescriptor(String name, URI url, ImmutableList<String> metadataSources, boolean authenticated, ImmutableList<String> authenticationSchemes) {
        super(name);
        this.url = url;
        this.metadataSources = metadataSources;
        this.authenticated = authenticated;
        this.authenticationSchemes = authenticationSchemes;
    }

    @Override
    protected void addProperties(ImmutableSortedMap.Builder<String, Object> builder) {
        if (this.url != null) {
            builder.put((Object)Property.URL.name(), (Object)this.url);
        }
        builder.put((Object)Property.METADATA_SOURCES.name(), this.metadataSources);
        builder.put((Object)Property.AUTHENTICATED.name(), (Object)this.authenticated);
        builder.put((Object)Property.AUTHENTICATION_SCHEMES.name(), this.authenticationSchemes);
    }

    static abstract class Builder<T extends Builder<T>> {
        final String name;
        final URI url;
        ImmutableList<String> metadataSources;
        Boolean authenticated;
        ImmutableList<String> authenticationSchemes;

        Builder(String name, URI url) {
            this.name = name;
            this.url = url;
        }

        protected T self() {
            return (T)this;
        }

        public T setMetadataSources(List<String> metadataSources) {
            this.metadataSources = ImmutableList.copyOf(metadataSources);
            return this.self();
        }

        public T setAuthenticated(boolean authenticated) {
            this.authenticated = authenticated;
            return this.self();
        }

        public T setAuthenticationSchemes(List<String> authenticationSchemes) {
            this.authenticationSchemes = ImmutableList.copyOf(authenticationSchemes);
            return this.self();
        }
    }

    public static enum Property {
        URL,
        METADATA_SOURCES,
        AUTHENTICATED,
        AUTHENTICATION_SCHEMES;

    }
}

