/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.internal.artifacts.ComponentMetadataProcessorFactory;
import org.gradle.api.internal.artifacts.ComponentModuleMetadataProcessor;
import org.gradle.api.internal.artifacts.GlobalDependencyResolutionRules;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionRules;
import org.gradle.internal.Actions;
import org.gradle.util.CollectionUtils;

public class DefaultGlobalDependencyResolutionRules
implements GlobalDependencyResolutionRules {
    private final ComponentMetadataProcessorFactory componentMetadataProcessorFactory;
    private final ComponentModuleMetadataProcessor moduleMetadataProcessor;
    private final DependencySubstitutionRules globalDependencySubstitutionRule;

    public DefaultGlobalDependencyResolutionRules(ComponentMetadataProcessorFactory componentMetadataProcessorFactory, ComponentModuleMetadataProcessor moduleMetadataProcessor, List<DependencySubstitutionRules> ruleProviders) {
        this.componentMetadataProcessorFactory = componentMetadataProcessorFactory;
        this.moduleMetadataProcessor = moduleMetadataProcessor;
        this.globalDependencySubstitutionRule = new CompositeDependencySubstitutionRules(ruleProviders);
    }

    @Override
    public ComponentMetadataProcessorFactory getComponentMetadataProcessorFactory() {
        return this.componentMetadataProcessorFactory;
    }

    @Override
    public ComponentModuleMetadataProcessor getModuleMetadataProcessor() {
        return this.moduleMetadataProcessor;
    }

    @Override
    public DependencySubstitutionRules getDependencySubstitutionRules() {
        return this.globalDependencySubstitutionRule;
    }

    private static class CompositeDependencySubstitutionRules
    implements DependencySubstitutionRules {
        private final List<DependencySubstitutionRules> ruleProviders;

        private CompositeDependencySubstitutionRules(List<DependencySubstitutionRules> ruleProviders) {
            this.ruleProviders = ruleProviders;
        }

        @Override
        public Action<DependencySubstitution> getRuleAction() {
            return Actions.composite((List)CollectionUtils.collect(this.ruleProviders, DependencySubstitutionRules::getRuleAction));
        }

        @Override
        public boolean hasRules() {
            for (DependencySubstitutionRules ruleProvider : this.ruleProviders) {
                if (!ruleProvider.hasRules()) continue;
                return true;
            }
            return false;
        }
    }
}

