/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* Generated by Together */

package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;

/**
 * The <CODE>VariableCommentFieldLocation</CODE> class provides specific information
 * about the stack variable comment field within a program location.
 */

public class VariableCommentFieldLocation extends VariableLocation {

	private String comment;

	/**
	 * Construct a new VariableCommentFieldLocation object.
	 * @param locationAddr the address of the listing location (i.e., referent code unit)
	 * @param var the variable which has its comment in the field.
	 * @param charOffset the position within the variable comment string for this location.
	 * @param the program of the location
	 */
	public VariableCommentFieldLocation(Program program, Address locationAddr, Variable var,
			int charOffset) {

		super(program, locationAddr, var, 0, charOffset);
		this.comment = var.getComment();
	}

	/**
	 * Construct a new VariableCommentFieldLocation object.
	 * Variable function entry point is the assumed listing location (i.e., referent code unit).
	 * Care should be taken if variable corresponds to an EXTERNAL function.
	 * @param the program of the location
	 * @param var the variable which has its comment in the field.
	 * @param charOffset the position within the variable comment string for this location.
	 */
	public VariableCommentFieldLocation(Program program, Variable var, int charOffset) {

		super(program, var, 0, charOffset);
		this.comment = var.getComment();
	}

	/**
	 * Should only be used by XML restoration.
	 */
	public VariableCommentFieldLocation() {
		super();
	}

	/**
	 * Return the function variable comment string at this location.
	 */
	public String getComment() {
		return comment;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((comment == null) ? 0 : comment.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		VariableCommentFieldLocation other = (VariableCommentFieldLocation) obj;
		if (comment == null) {
			if (other.comment != null)
				return false;
		}
		else if (!comment.equals(other.comment))
			return false;
		return true;
	}

	@Override
	public void restoreState(Program p, SaveState obj) {
		super.restoreState(p, obj);
		comment = obj.getString("_COMMENT", "");
	}

	@Override
	public void saveState(SaveState obj) {
		super.saveState(obj);
		obj.putString("_COMMNET", comment);
	}

}
