/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib.fs.hfscommon;

import org.catacombae.hfsexplorer.IOUtil;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogFileRecord;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.jparted.lib.fs.FSAttributes;
import org.catacombae.jparted.lib.fs.FSEntry;
import org.catacombae.jparted.lib.fs.FSLink;
import org.catacombae.jparted.lib.fs.hfscommon.HFSCommonFSAttributes;
import org.catacombae.jparted.lib.fs.hfscommon.HFSCommonFileSystemHandler;

public class HFSCommonFSLink
extends FSLink {
    private final CommonHFSCatalogFileRecord linkRecord;
    private final HFSCommonFileSystemHandler fsHandler;

    public HFSCommonFSLink(HFSCommonFileSystemHandler fsHandler, CommonHFSCatalogFileRecord linkRecord) {
        super(fsHandler);
        this.fsHandler = fsHandler;
        this.linkRecord = linkRecord;
        if (!linkRecord.getData().isSymbolicLink()) {
            throw new IllegalArgumentException("linkRecord is no symbolic link!");
        }
    }

    public String getLinkTargetPosixPath() {
        ReadableRandomAccessStream linkDataStream = this.fsHandler.getReadableDataForkStream(this.linkRecord);
        byte[] linkBytes = IOUtil.readFully((ReadableRandomAccessStream)linkDataStream);
        linkDataStream.close();
        return Util.readString((byte[])linkBytes, (String)"UTF-8");
    }

    public FSEntry getLinkTarget(String[] parentDir) {
        FSEntry res;
        String posixPath = this.getLinkTargetPosixPath();
        Object[] targetPath = this.fsHandler.getTruePathFromPosixPath(posixPath, parentDir);
        if (targetPath != null) {
            res = this.fsHandler.getEntry((String[])targetPath);
            if (res != null && res instanceof FSLink) {
                if ((res = this.fsHandler.resolveLinks((String[])targetPath, (FSLink)res)) == null) {
                    System.err.println("\ngetLinkTarget(): Could not resolve inner link \"" + Util.concatenateStrings((Object[])targetPath, (String)"/") + "\"");
                }
            } else if (res == null) {
                System.err.println("\ngetLinkTarget(): Could not get entry for true path \"" + Util.concatenateStrings((Object[])targetPath, (String)"/") + "\"");
            }
            if (res != null && res instanceof FSLink) {
                throw new RuntimeException("res still instanceof FSLink!");
            }
        } else {
            System.err.println("\ngetLinkTarget(): Could not get true path!");
            res = null;
        }
        if (res == null) {
            System.err.println("getLinkTarget(): FAILED to get entry by posix path for link " + this.linkRecord.getKey().getParentID().toLong() + ":\"" + this.fsHandler.getProperNodeName(this.linkRecord) + "\":");
            System.err.println("getLinkTarget():   posixPath=\"" + posixPath + "\"");
            System.err.println("getLinkTarget():   parentDir=\"" + Util.concatenateStrings((Object[])parentDir, (String)"/") + "\"");
            System.err.println();
        }
        return res;
    }

    public FSAttributes getAttributes() {
        return new HFSCommonFSAttributes(this, this.linkRecord.getData());
    }

    public String getName() {
        return this.fsHandler.getProperNodeName(this.linkRecord);
    }

    public CommonHFSCatalogFileRecord getInternalCatalogFileRecord() {
        return this.linkRecord;
    }

    public String getLinkTargetString() {
        return this.getLinkTargetPosixPath();
    }
}

