/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.applesingle;

import java.io.PrintStream;
import org.catacombae.util.Util;

public class EntryDescriptor {
    public static final int STRUCTSIZE = 12;
    private static final long MAX_UINT = 0xFFFFFFFFL;
    private final byte[] entryId = new byte[4];
    private final byte[] entryOffset = new byte[4];
    private final byte[] entryLength = new byte[4];

    public EntryDescriptor(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.entryId, 0, 4);
        System.arraycopy(data, offset + 4, this.entryOffset, 0, 4);
        System.arraycopy(data, offset + 8, this.entryLength, 0, 4);
    }

    public EntryDescriptor(long entryId, long entryOffset, long entryLength) {
        if (entryId < 0L || entryId > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Illegal value for entryId (" + entryId + ")");
        }
        if (entryOffset < 0L || entryOffset > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Illegal value for entryOffset (" + entryOffset + ")");
        }
        if (entryLength < 0L || entryLength > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Illegal value for entryLength (" + entryLength + ")");
        }
        System.arraycopy(Util.toByteArrayBE((int)((int)entryId)), 0, this.entryId, 0, 4);
        System.arraycopy(Util.toByteArrayBE((int)((int)entryOffset)), 0, this.entryOffset, 0, 4);
        System.arraycopy(Util.toByteArrayBE((int)((int)entryLength)), 0, this.entryLength, 0, 4);
    }

    public static int length() {
        return 12;
    }

    public int getEntryId() {
        return Util.readIntBE((byte[])this.entryId);
    }

    public int getEntryOffset() {
        return Util.readIntBE((byte[])this.entryOffset);
    }

    public int getEntryLength() {
        return Util.readIntBE((byte[])this.entryLength);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " entryId: " + this.getEntryId());
        ps.println(prefix + " entryOffset: " + this.getEntryOffset());
        ps.println(prefix + " entryLength: " + this.getEntryLength());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "EntryDescriptor:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[12];
        int offset = 0;
        System.arraycopy(this.entryId, 0, result, offset, this.entryId.length);
        System.arraycopy(this.entryOffset, 0, result, offset += this.entryId.length, this.entryOffset.length);
        System.arraycopy(this.entryLength, 0, result, offset += this.entryOffset.length, this.entryLength.length);
        offset += this.entryLength.length;
        return result;
    }
}

