/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import ghidra.feature.vt.api.correlator.program.CombinedFunctionAndDataReferenceProgramCorrelatorFactory;
import ghidra.feature.vt.api.correlator.program.DataReferenceProgramCorrelatorFactory;
import ghidra.feature.vt.api.correlator.program.DuplicateFunctionMatchProgramCorrelatorFactory;
import ghidra.feature.vt.api.correlator.program.ExactDataMatchProgramCorrelatorFactory;
import ghidra.feature.vt.api.correlator.program.ExactMatchBytesProgramCorrelatorFactory;
import ghidra.feature.vt.api.correlator.program.ExactMatchInstructionsProgramCorrelatorFactory;
import ghidra.feature.vt.api.correlator.program.ExactMatchMnemonicsProgramCorrelatorFactory;
import ghidra.feature.vt.api.correlator.program.FunctionReferenceProgramCorrelatorFactory;
import ghidra.feature.vt.api.correlator.program.SymbolNameProgramCorrelatorFactory;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationManager;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTProgramCorrelator;
import ghidra.feature.vt.api.main.VTProgramCorrelatorFactory;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.util.VTAbstractProgramCorrelatorFactory;
import ghidra.feature.vt.api.util.VTAssociationStatusException;
import ghidra.feature.vt.api.util.VTOptions;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.task.ApplyMarkupItemTask;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.OperandType;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ListingDiff;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import util.CollectionUtils;

public class AutoVersionTrackingCommand
extends BackgroundCommand {
    private VTSession session;
    private Program sourceProgram;
    private Program destinationProgram;
    private PluginTool serviceProvider;
    private AddressSetView sourceAddressSet;
    private AddressSetView destinationAddressSet;
    private VTController controller;
    private double minCombinedReferenceCorrelatorScore;
    private double minCombinedReferenceCorrelatorConfidence;
    private final ToolOptions applyOptions;
    private String statusMsg = null;
    private static int NUM_CORRELATORS = 7;

    public AutoVersionTrackingCommand(VTController controller, VTSession session, double minCombinedReferenceCorrelatorScore, double minCombinedReferenceCorrelatorConfidence) {
        this.session = session;
        this.sourceProgram = session.getSourceProgram();
        this.destinationProgram = session.getDestinationProgram();
        this.serviceProvider = controller.getTool();
        this.controller = controller;
        this.minCombinedReferenceCorrelatorScore = minCombinedReferenceCorrelatorScore;
        this.minCombinedReferenceCorrelatorConfidence = minCombinedReferenceCorrelatorConfidence;
        this.applyOptions = controller.getOptions();
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        boolean hasApplyErrors = false;
        this.sourceAddressSet = this.sourceProgram.getMemory().getLoadedAndInitializedAddressSet();
        this.destinationAddressSet = this.destinationProgram.getMemory().getLoadedAndInitializedAddressSet();
        try {
            monitor.setMessage("Running Auto Version Tracking");
            monitor.setCancelEnabled(true);
            monitor.initialize((long)NUM_CORRELATORS);
            VTAbstractProgramCorrelatorFactory factory = new SymbolNameProgramCorrelatorFactory();
            VTOptions options = factory.createDefaultOptions();
            hasApplyErrors = this.correlateAndPossiblyApply(factory, options, monitor);
            factory = new ExactDataMatchProgramCorrelatorFactory();
            options = factory.createDefaultOptions();
            hasApplyErrors |= this.correlateAndPossiblyApply(factory, options, monitor);
            factory = new ExactMatchBytesProgramCorrelatorFactory();
            options = factory.createDefaultOptions();
            hasApplyErrors |= this.correlateAndPossiblyApply(factory, options, monitor);
            factory = new ExactMatchInstructionsProgramCorrelatorFactory();
            options = factory.createDefaultOptions();
            hasApplyErrors |= this.correlateAndPossiblyApply(factory, options, monitor);
            factory = new ExactMatchMnemonicsProgramCorrelatorFactory();
            options = factory.createDefaultOptions();
            hasApplyErrors |= this.correlateAndPossiblyApply(factory, options, monitor);
            factory = new DuplicateFunctionMatchProgramCorrelatorFactory();
            options = factory.createDefaultOptions();
            hasApplyErrors |= this.correlateAndPossiblyApplyDuplicateFunctions(factory, options, monitor);
            String confidenceOption = "Confidence threshold (info content)";
            String scoreOption = "Minimum similarity threshold (score)";
            int numDataMatches = this.getNumberOfDataMatches(monitor);
            int numFunctionMatches = this.getNumberOfFunctionMatches(monitor);
            if (numDataMatches > 0 && numFunctionMatches == 0) {
                factory = new DataReferenceProgramCorrelatorFactory();
                options = factory.createDefaultOptions();
                options.setDouble(confidenceOption, this.minCombinedReferenceCorrelatorConfidence);
                options.setDouble(scoreOption, this.minCombinedReferenceCorrelatorScore);
                hasApplyErrors |= this.correlateAndPossiblyApply(factory, options, monitor);
                numDataMatches = this.getNumberOfDataMatches(monitor);
                numFunctionMatches = this.getNumberOfFunctionMatches(monitor);
            }
            if (numDataMatches > 0 && numFunctionMatches == 0) {
                factory = new FunctionReferenceProgramCorrelatorFactory();
                options = factory.createDefaultOptions();
                options.setDouble(confidenceOption, this.minCombinedReferenceCorrelatorConfidence);
                options.setDouble(scoreOption, this.minCombinedReferenceCorrelatorScore);
                factory = new FunctionReferenceProgramCorrelatorFactory();
                hasApplyErrors |= this.correlateAndPossiblyApply(factory, options, monitor);
                numDataMatches = this.getNumberOfDataMatches(monitor);
                numFunctionMatches = this.getNumberOfFunctionMatches(monitor);
            }
            if (numDataMatches > 0 && numFunctionMatches > 0) {
                factory = new CombinedFunctionAndDataReferenceProgramCorrelatorFactory();
                options = factory.createDefaultOptions();
                options.setDouble(confidenceOption, this.minCombinedReferenceCorrelatorConfidence);
                options.setDouble(scoreOption, this.minCombinedReferenceCorrelatorScore);
                hasApplyErrors |= this.correlateAndPossiblyApply(factory, options, monitor);
            }
        }
        catch (CancelledException e) {
            this.statusMsg = this.getName() + " was cancelled.";
            return false;
        }
        String applyMarkupStatus = " with no apply markup errors.";
        if (hasApplyErrors) {
            applyMarkupStatus = " with some apply markup errors. See the log or the markup table for more details";
        }
        this.statusMsg = this.getName() + " completed successfully" + applyMarkupStatus;
        this.controller.getTool().setStatusInfo(this.statusMsg);
        return true;
    }

    private int getNumberOfDataMatches(TaskMonitor monitor) throws CancelledException {
        int numDataMatches = 0;
        List<VTMatchSet> matchSets = this.session.getMatchSets();
        for (VTMatchSet matchSet : matchSets) {
            monitor.checkCanceled();
            Collection<VTMatch> matches = matchSet.getMatches();
            for (VTMatch match : matches) {
                monitor.checkCanceled();
                if (match.getAssociation().getStatus() != VTAssociationStatus.ACCEPTED || match.getAssociation().getType() != VTAssociationType.DATA) continue;
                ++numDataMatches;
            }
        }
        return numDataMatches;
    }

    private int getNumberOfFunctionMatches(TaskMonitor monitor) throws CancelledException {
        int numFunctionMatches = 0;
        List<VTMatchSet> matchSets = this.session.getMatchSets();
        for (VTMatchSet matchSet : matchSets) {
            monitor.checkCanceled();
            Collection<VTMatch> matches = matchSet.getMatches();
            for (VTMatch match : matches) {
                monitor.checkCanceled();
                if (match.getAssociation().getStatus() != VTAssociationStatus.ACCEPTED || match.getAssociation().getType() != VTAssociationType.FUNCTION) continue;
                ++numFunctionMatches;
            }
        }
        return numFunctionMatches;
    }

    private boolean correlateAndPossiblyApply(VTProgramCorrelatorFactory factory, VTOptions options, TaskMonitor monitor) throws CancelledException {
        monitor.checkCanceled();
        monitor.setMessage("Finding and applying good " + factory.getName() + " matches and markup.");
        VTProgramCorrelator correlator = factory.createCorrelator((ServiceProvider)this.serviceProvider, this.sourceProgram, this.sourceAddressSet, this.destinationProgram, this.destinationAddressSet, options);
        VTMatchSet results = correlator.correlate(this.session, monitor);
        boolean hasMarkupErrors = this.applyMatches(results.getMatches(), correlator.getName(), monitor);
        monitor.incrementProgress(1L);
        return hasMarkupErrors;
    }

    private boolean correlateAndPossiblyApplyDuplicateFunctions(VTProgramCorrelatorFactory factory, VTOptions options, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Finding and applying good " + factory.getName() + " matches and markup.");
        VTProgramCorrelator correlator = factory.createCorrelator((ServiceProvider)this.serviceProvider, this.sourceProgram, this.sourceAddressSet, this.destinationProgram, this.destinationAddressSet, options);
        VTMatchSet results = correlator.correlate(this.session, monitor);
        boolean hasMarkupErrors = this.applyDuplicateFunctionMatches(results.getMatches(), monitor);
        monitor.incrementProgress(1L);
        return hasMarkupErrors;
    }

    private boolean applyMatches(Collection<VTMatch> matches, String correlatorName, TaskMonitor monitor) throws CancelledException {
        boolean someMatchesHaveMarkupErrors = false;
        for (VTMatch match : matches) {
            MatchInfo matchInfo;
            Collection<VTMarkupItem> markupItems;
            monitor.checkCanceled();
            VTAssociation association = match.getAssociation();
            if (!association.getStatus().canApply() || !AutoVersionTrackingCommand.tryToSetAccepted(association) || (markupItems = (matchInfo = this.controller.getMatchInfo(match)).getAppliableMarkupItems(monitor)) == null || markupItems.size() == 0) continue;
            ApplyMarkupItemTask markupTask = new ApplyMarkupItemTask(this.controller.getSession(), markupItems, this.applyOptions);
            markupTask.run(monitor);
            boolean currentMatchHasErrors = markupTask.hasErrors();
            if (!currentMatchHasErrors) continue;
            someMatchesHaveMarkupErrors = true;
        }
        return someMatchesHaveMarkupErrors;
    }

    private static boolean tryToSetAccepted(VTAssociation association) {
        try {
            association.setAccepted();
            return true;
        }
        catch (VTAssociationStatusException e) {
            Msg.warn(AutoVersionTrackingCommand.class, (Object)("Could not set match accepted for " + association), (Throwable)e);
            return false;
        }
    }

    private boolean applyDuplicateFunctionMatches(Collection<VTMatch> matches, TaskMonitor monitor) throws CancelledException {
        boolean someMatchesHaveMarkupErrors = false;
        HashSet<VTMatch> copyOfMatches = new HashSet<VTMatch>(matches);
        for (VTMatch match : matches) {
            monitor.checkCanceled();
            if (!copyOfMatches.contains(match)) continue;
            Set<VTMatch> relatedMatches = this.getRelatedMatches(match, matches, monitor);
            this.removeMatches(copyOfMatches, relatedMatches);
            Set<Address> sourceAddresses = this.getSourceAddressesFromMatches(relatedMatches, monitor);
            Set<Address> uniqueSourceFunctionAddresses = this.dedupeMatchingFunctions(this.sourceProgram, sourceAddresses, monitor);
            Set<Address> destAddresses = this.getDestinationAddressesFromMatches(relatedMatches, monitor);
            Set<Address> uniqueDestFunctionAddresses = this.dedupeMatchingFunctions(this.destinationProgram, destAddresses, monitor);
            Set<VTMatch> dedupedMatches = this.getMatches(relatedMatches, uniqueSourceFunctionAddresses, uniqueDestFunctionAddresses, monitor);
            for (Address sourceAddress : uniqueSourceFunctionAddresses) {
                monitor.checkCanceled();
                Set<VTMatch> matchesWithEquivalentOperands = this.getMatchesWithEquivalentOperands(dedupedMatches, sourceAddress, uniqueDestFunctionAddresses, monitor);
                if (matchesWithEquivalentOperands.size() != 1) continue;
                VTMatch theMatch = (VTMatch)CollectionUtils.any(matchesWithEquivalentOperands);
                someMatchesHaveMarkupErrors = this.tryToAcceptMatchAndApplyMarkup(theMatch, monitor);
            }
        }
        return someMatchesHaveMarkupErrors;
    }

    private boolean tryToAcceptMatchAndApplyMarkup(VTMatch match, TaskMonitor monitor) {
        MatchInfo matchInfo;
        Collection<VTMarkupItem> markupItems;
        VTAssociation association = match.getAssociation();
        if (association.getStatus() == VTAssociationStatus.AVAILABLE && AutoVersionTrackingCommand.tryToSetAccepted(association) && (markupItems = (matchInfo = this.controller.getMatchInfo(match)).getAppliableMarkupItems(monitor)) != null && markupItems.size() != 0) {
            ApplyMarkupItemTask markupTask = new ApplyMarkupItemTask(this.controller.getSession(), markupItems, this.applyOptions);
            markupTask.run(monitor);
            boolean currentMatchHasErrors = markupTask.hasErrors();
            if (currentMatchHasErrors) {
                return true;
            }
        }
        return false;
    }

    private Set<VTMatch> getMatchesWithEquivalentOperands(Set<VTMatch> matches, Address sourceAddress, Set<Address> destAddresses, TaskMonitor monitor) throws CancelledException {
        HashSet<VTMatch> matchesWithEquivalentOperands = new HashSet<VTMatch>();
        for (Address destAddress : destAddresses) {
            VTMatch goodMatch;
            if (!this.haveEquivalentOperands(this.sourceProgram, sourceAddress, this.destinationProgram, destAddress, monitor) || (goodMatch = this.getMatch(matches, sourceAddress, destAddress)) == null) continue;
            matchesWithEquivalentOperands.add(goodMatch);
        }
        return matchesWithEquivalentOperands;
    }

    private Set<VTMatch> getRelatedMatches(VTMatch match, Collection<VTMatch> matches, TaskMonitor monitor) throws CancelledException {
        VTAssociationManager vtAssocManager = this.session.getAssociationManager();
        HashSet<VTMatch> relatedMatches = new HashSet<VTMatch>();
        Collection<VTAssociation> relatedAssociations = vtAssocManager.getRelatedAssociationsBySourceAndDestinationAddress(match.getSourceAddress(), match.getDestinationAddress());
        relatedMatches.add(match);
        for (VTAssociation relatedAssociation : relatedAssociations) {
            monitor.checkCanceled();
            VTMatch relMatch = this.getMatch(matches, relatedAssociation.getSourceAddress(), relatedAssociation.getDestinationAddress());
            if (relMatch == null) continue;
            relatedMatches.add(relMatch);
        }
        return relatedMatches;
    }

    private void removeMatches(Set<VTMatch> matchSet, Set<VTMatch> matchesToRemove) {
        for (VTMatch matchToRemove : matchesToRemove) {
            VTMatch match = this.getMatch(matchSet, matchToRemove.getSourceAddress(), matchToRemove.getDestinationAddress());
            if (match == null) continue;
            matchSet.remove(match);
        }
    }

    private Set<Address> getSourceAddressesFromMatches(Set<VTMatch> matches, TaskMonitor monitor) throws CancelledException {
        HashSet<Address> sourceAddresses = new HashSet<Address>();
        for (VTMatch match : matches) {
            monitor.checkCanceled();
            sourceAddresses.add(match.getSourceAddress());
        }
        return sourceAddresses;
    }

    private Set<Address> getDestinationAddressesFromMatches(Set<VTMatch> matches, TaskMonitor monitor) throws CancelledException {
        HashSet<Address> destAddresses = new HashSet<Address>();
        for (VTMatch match : matches) {
            monitor.checkCanceled();
            destAddresses.add(match.getDestinationAddress());
        }
        return destAddresses;
    }

    private VTMatch getMatch(Collection<VTMatch> matches, Address sourceAddress, Address destAddress) {
        for (VTMatch match : matches) {
            if (!match.getSourceAddress().equals((Object)sourceAddress) || !match.getDestinationAddress().equals((Object)destAddress)) continue;
            return match;
        }
        return null;
    }

    private Set<VTMatch> getMatches(Set<VTMatch> matches, Set<Address> sourceAddresses, Set<Address> destAddresses, TaskMonitor monitor) throws CancelledException {
        HashSet<VTMatch> results = new HashSet<VTMatch>();
        for (VTMatch match : matches) {
            monitor.checkCanceled();
            if (!sourceAddresses.contains(match.getSourceAddress()) || !destAddresses.contains(match.getDestinationAddress())) continue;
            results.add(match);
        }
        return results;
    }

    private boolean haveEquivalentOperands(Program program1, Address address1, Program program2, Address address2, TaskMonitor monitor) throws CancelledException {
        Function function1 = program1.getFunctionManager().getFunctionAt(address1);
        Function function2 = program2.getFunctionManager().getFunctionAt(address2);
        if (function1 == null || function2 == null) {
            return false;
        }
        InstructionIterator func1InstIter = program1.getListing().getInstructions(function1.getBody(), true);
        InstructionIterator func2InstIter = program2.getListing().getInstructions(function2.getBody(), true);
        ListingDiff listingDiff = new ListingDiff();
        listingDiff.setIgnoreByteDiffs(false);
        listingDiff.setIgnoreConstants(false);
        listingDiff.setIgnoreRegisters(false);
        while (func1InstIter.hasNext() && func2InstIter.hasNext()) {
            int[] operandsThatDiffer;
            Instruction inst2;
            monitor.checkCanceled();
            Instruction inst1 = func1InstIter.next();
            if (this.haveEquivalentOperands(inst1, inst2 = func2InstIter.next(), operandsThatDiffer = listingDiff.getOperandsThatDiffer((CodeUnit)inst1, (CodeUnit)inst2))) continue;
            return false;
        }
        if (func1InstIter.hasNext() || func2InstIter.hasNext()) {
            throw new AssertException("Expected Source and Destination function number of instructions to be equal but they differ.");
        }
        return true;
    }

    private boolean haveEquivalentOperands(Instruction inst1, Instruction inst2, int[] operandsThatDiffer) {
        for (int operand : operandsThatDiffer) {
            int destOpType;
            int srcOpType = inst1.getOperandType(operand);
            if (srcOpType != (destOpType = inst2.getOperandType(operand))) {
                return false;
            }
            if (OperandType.isScalar((int)srcOpType) && !inst1.getScalar(operand).equals((Object)inst2.getScalar(operand))) {
                return false;
            }
            if (!OperandType.isAddress((int)srcOpType) || OperandType.isDataReference((int)srcOpType) && OperandType.isDataReference((int)destOpType) || OperandType.isCodeReference((int)srcOpType) && OperandType.isCodeReference((int)destOpType)) continue;
            return false;
        }
        return true;
    }

    private boolean haveSameOperands(Program program1, Function function1, Program program2, Function function2, TaskMonitor monitor) throws CancelledException {
        CodeUnitIterator sourceFuncCodeUnitIter = program1.getListing().getCodeUnits(function1.getBody(), true);
        CodeUnitIterator destFuncCodeUnitIter = program2.getListing().getCodeUnits(function2.getBody(), true);
        ListingDiff listingDiff = new ListingDiff();
        listingDiff.setIgnoreByteDiffs(false);
        listingDiff.setIgnoreConstants(false);
        listingDiff.setIgnoreRegisters(false);
        while (sourceFuncCodeUnitIter.hasNext() && destFuncCodeUnitIter.hasNext()) {
            CodeUnit dstCodeUnit;
            monitor.checkCanceled();
            CodeUnit srcCodeUnit = sourceFuncCodeUnitIter.next();
            int[] operandsThatDiffer = listingDiff.getOperandsThatDiffer(srcCodeUnit, dstCodeUnit = destFuncCodeUnitIter.next());
            if (operandsThatDiffer.length <= 0) continue;
            return false;
        }
        if (sourceFuncCodeUnitIter.hasNext() || destFuncCodeUnitIter.hasNext()) {
            throw new AssertException("Expected Source and Destination function number of instructions to be equal but they differ.");
        }
        return true;
    }

    public Set<Address> dedupeMatchingFunctions(Program program, Set<Address> addresses, TaskMonitor monitor) throws CancelledException {
        FunctionManager functionManager = program.getFunctionManager();
        HashSet<Address> uniqueFunctionAddresses = new HashSet<Address>(addresses);
        ArrayList<Address> list = new ArrayList<Address>(addresses);
        for (int i = 0; i < list.size(); ++i) {
            Address address1 = (Address)list.get(i);
            if (!uniqueFunctionAddresses.contains(address1)) continue;
            for (int j = i + 1; j < list.size(); ++j) {
                monitor.checkCanceled();
                Address address2 = (Address)list.get(j);
                if (!uniqueFunctionAddresses.contains(address2) || !this.haveSameOperands(program, functionManager.getFunctionAt(address1), program, functionManager.getFunctionAt(address2), monitor)) continue;
                uniqueFunctionAddresses.remove(address1);
                uniqueFunctionAddresses.remove(address2);
            }
        }
        return uniqueFunctionAddresses;
    }

    public String getStatusMsg() {
        return this.statusMsg;
    }

    public String getName() {
        return "Auto Version Tracking Command";
    }
}

