/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBHandle;
import db.OpenMode;
import db.Record;
import db.RecordIterator;
import ghidra.feature.vt.api.db.MarkupItemStorageDB;
import ghidra.feature.vt.api.db.VTAssociationDB;
import ghidra.feature.vt.api.db.VTAssociationTableDBAdapter;
import ghidra.feature.vt.api.db.VTMatchMarkupItemTableDBAdapter;
import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.impl.MarkupItemStorage;
import ghidra.feature.vt.api.main.AssociationHook;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationManager;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.feature.vt.api.util.VTAssociationStatusException;
import ghidra.program.database.DBObjectCache;
import ghidra.program.model.address.Address;
import ghidra.util.Lock;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AssociationDatabaseManager
implements VTAssociationManager {
    private VTAssociationTableDBAdapter associationTableAdapter;
    private final VTSessionDB session;
    private VTMatchMarkupItemTableDBAdapter markupItemTableAdapter;
    private DBObjectCache<MarkupItemStorageDB> markupItemCache;
    private List<AssociationHook> associationHooks = new ArrayList<AssociationHook>();
    private DBObjectCache<VTAssociationDB> associationCache;
    Lock lock;

    public static AssociationDatabaseManager createAssociationManager(DBHandle dbHandle, VTSessionDB session) throws IOException {
        AssociationDatabaseManager manager = new AssociationDatabaseManager(session);
        manager.associationTableAdapter = VTAssociationTableDBAdapter.createAdapter(dbHandle);
        manager.markupItemTableAdapter = VTMatchMarkupItemTableDBAdapter.createAdapter(dbHandle);
        return manager;
    }

    public static AssociationDatabaseManager getAssociationManager(DBHandle dbHandle, VTSessionDB session, OpenMode openMode, TaskMonitor monitor) throws VersionException {
        AssociationDatabaseManager manager = new AssociationDatabaseManager(session);
        manager.associationTableAdapter = VTAssociationTableDBAdapter.getAdapter(dbHandle, openMode, monitor);
        manager.markupItemTableAdapter = VTMatchMarkupItemTableDBAdapter.getAdapter(dbHandle, openMode, monitor);
        return manager;
    }

    AssociationDatabaseManager(VTSessionDB session) {
        this.session = session;
        this.lock = session.getLock();
        this.associationCache = new DBObjectCache(10);
        this.markupItemCache = new DBObjectCache(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<MarkupItemStorageDB> getAppliedMarkupItems(TaskMonitor monitor, VTAssociation association) throws CancelledException {
        ArrayList<MarkupItemStorageDB> items = new ArrayList<MarkupItemStorageDB>();
        VTAssociationDB associationDB = (VTAssociationDB)association;
        try {
            this.lock.acquire();
            int recordCount = this.markupItemTableAdapter.getRecordCount();
            if (recordCount == 0) {
                recordCount = 1;
            }
            monitor.setMessage("Processing stored markup items");
            monitor.initialize((long)recordCount);
            RecordIterator records = this.markupItemTableAdapter.getRecords(associationDB.getKey());
            while (records.hasNext()) {
                monitor.checkCanceled();
                Record record = records.next();
                items.add(this.getMarkupItemForRecord(record));
                monitor.incrementProgress(1L);
            }
            monitor.setProgress((long)recordCount);
        }
        catch (IOException e) {
            this.session.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return items;
    }

    Record getMarkupItemRecord(long key) {
        try {
            return this.markupItemTableAdapter.getRecord(key);
        }
        catch (IOException e) {
            this.session.dbError(e);
            return null;
        }
    }

    public MarkupItemStorage addMarkupItem(MarkupItemStorage markupItemStorage) {
        VTAssociation association = markupItemStorage.getAssociation();
        try {
            this.setAssociationAccepted(association);
        }
        catch (VTAssociationStatusException e) {
            throw new AssertException("Attempted to add markup item on an non-accepted associaton");
        }
        return this.createMarkupItemDB(markupItemStorage);
    }

    void removeMarkupItem(MarkupItemStorageDB appliedMarkupItemDB) {
        VTAssociationDB association = (VTAssociationDB)appliedMarkupItemDB.getAssociation();
        this.validateAcceptedState(appliedMarkupItemDB, association);
        try {
            this.markupItemTableAdapter.removeMatchMarkupItemRecord(appliedMarkupItemDB.getKey());
        }
        catch (IOException e) {
            this.session.dbError(e);
        }
    }

    private void validateAcceptedState(MarkupItemStorageDB appliedItem, VTAssociationDB association) {
        VTAssociationStatus associationStatus = association.getStatus();
        VTMarkupItemStatus status = appliedItem.getStatus();
        if (status.isUnappliable() && associationStatus != VTAssociationStatus.ACCEPTED) {
            throw new AssertException("Cannot have an applied markup item with an association that is not ACCEPTED");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MarkupItemStorageDB getMarkupItemForRecord(Record markupItemRecord) {
        try {
            this.lock.acquire();
            MarkupItemStorageDB markupItem = (MarkupItemStorageDB)this.markupItemCache.get(markupItemRecord);
            if (markupItem == null) {
                markupItem = new MarkupItemStorageDB(markupItemRecord, this.markupItemCache, this);
            }
            MarkupItemStorageDB markupItemStorageDB = markupItem;
            return markupItemStorageDB;
        }
        finally {
            this.lock.release();
        }
    }

    Address getDestinationAddressFromLong(long longValue) {
        return this.session.getDestinationAddressFromLong(longValue);
    }

    long getLongFromDestinationAddress(Address address) {
        return this.session.getLongFromDestinationAddress(address);
    }

    Address getSourceAddressFromLong(long longValue) {
        return this.session.getSourceAddressFromLong(longValue);
    }

    Record getAssociationRecord(long key) {
        try {
            return this.associationTableAdapter.getRecord(key);
        }
        catch (IOException e) {
            this.session.dbError(e);
            return null;
        }
    }

    private MarkupItemStorageDB createMarkupItemDB(MarkupItemStorage markupItem) {
        try {
            Record record = this.markupItemTableAdapter.createMarkupItemRecord(markupItem);
            MarkupItemStorageDB appliedMarkupItem = this.getMarkupItemForRecord(record);
            return appliedMarkupItem;
        }
        catch (IOException e) {
            this.session.dbError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VTAssociationDB getOrCreateAssociationDB(Address sourceAddress, Address destinationAddress, VTAssociationType type) {
        VTAssociationDB existingAssociation = this.getExistingAssociationDB(sourceAddress, destinationAddress);
        if (existingAssociation != null) {
            return existingAssociation;
        }
        long sourceLong = this.session.getLongFromSourceAddress(sourceAddress);
        long destinationLong = this.session.getLongFromDestinationAddress(destinationAddress);
        boolean isBlocked = this.isBlocked(sourceAddress, destinationAddress);
        VTAssociationDB newAssociation = null;
        try {
            this.lock.acquire();
            Record record = this.associationTableAdapter.insertRecord(sourceLong, destinationLong, type, isBlocked ? VTAssociationStatus.BLOCKED : VTAssociationStatus.AVAILABLE, 0);
            newAssociation = new VTAssociationDB(this, this.associationCache, record);
        }
        catch (IOException e) {
            this.session.dbError(e);
        }
        finally {
            this.lock.release();
        }
        this.session.setChanged(1025, null, newAssociation);
        return newAssociation;
    }

    void removeAssociation(VTAssociation association) {
        VTAssociationDB existingAssociation = (VTAssociationDB)association;
        long id = existingAssociation.getKey();
        try {
            this.associationTableAdapter.removeAssociaiton(id);
            this.session.setChanged(1026, existingAssociation, null);
        }
        catch (IOException e) {
            this.session.dbError(e);
        }
        this.associationCache.delete(id);
        existingAssociation.setInvalid();
    }

    private boolean isBlocked(VTAssociation association) {
        return this.isBlocked(association.getSourceAddress(), association.getDestinationAddress());
    }

    private boolean isBlocked(Address sourceAddress, Address destinationAddress) {
        long sourceID = this.session.getLongFromSourceAddress(sourceAddress);
        long destinationID = this.session.getLongFromDestinationAddress(destinationAddress);
        try {
            Set<Record> relatedRecords = this.associationTableAdapter.getRelatedAssociationRecordsBySourceAndDestinationAddress(sourceID, destinationID);
            for (Record record : relatedRecords) {
                VTAssociationDB associationDB = this.getAssociationForRecord(record);
                VTAssociationStatus status = associationDB.getStatus();
                if (status != VTAssociationStatus.ACCEPTED) continue;
                return true;
            }
        }
        catch (IOException e) {
            this.session.dbError(e);
        }
        return false;
    }

    @Override
    public int getAssociationCount() {
        return this.associationTableAdapter.getRecordCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VTAssociation> getAssociations() {
        ArrayList<VTAssociation> list = new ArrayList<VTAssociation>();
        this.lock.acquire();
        try {
            RecordIterator iterator = this.associationTableAdapter.getRecords();
            while (iterator.hasNext()) {
                Record nextRecord = iterator.next();
                list.add(this.getAssociationForRecord(nextRecord));
            }
        }
        catch (IOException e) {
            this.session.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VTAssociation getAssociation(Address sourceAddress, Address destinationAddress) {
        this.lock.acquire();
        try {
            long addressKey = this.session.getLongFromSourceAddress(sourceAddress);
            RecordIterator iterator = this.associationTableAdapter.getRecordsForSourceAddress(addressKey);
            while (iterator.hasNext()) {
                Record record = iterator.next();
                VTAssociationDB associationDB = this.getAssociationForRecord(record);
                if (!associationDB.getDestinationAddress().equals((Object)destinationAddress)) continue;
                VTAssociationDB vTAssociationDB = associationDB;
                return vTAssociationDB;
            }
        }
        catch (IOException e) {
            this.session.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    VTAssociationDB getExistingAssociationDB(Address sourceAddress, Address destinationAddress) {
        long addressKey = this.session.getLongFromSourceAddress(sourceAddress);
        try {
            RecordIterator iterator = this.associationTableAdapter.getRecordsForSourceAddress(addressKey);
            while (iterator.hasNext()) {
                Record record = iterator.next();
                VTAssociationDB associationDB = this.getAssociationForRecord(record);
                Address dbDestinatonAddress = associationDB.getDestinationAddress();
                if (!destinationAddress.equals((Object)dbDestinatonAddress)) continue;
                return associationDB;
            }
        }
        catch (IOException e) {
            this.session.dbError(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VTAssociationDB getAssociationForRecord(Record record) {
        if (record == null) {
            throw new AssertException("How can we have a null record?!!!");
        }
        try {
            this.lock.acquire();
            VTAssociationDB associationDB = (VTAssociationDB)this.associationCache.get(record);
            if (associationDB == null) {
                associationDB = new VTAssociationDB(this, this.associationCache, record);
            }
            VTAssociationDB vTAssociationDB = associationDB;
            return vTAssociationDB;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VTAssociationDB getAssociation(long associationKey) {
        try {
            this.lock.acquire();
            VTAssociationDB associationDB = (VTAssociationDB)this.associationCache.get(associationKey);
            if (associationDB != null) {
                VTAssociationDB vTAssociationDB = associationDB;
                return vTAssociationDB;
            }
            Record record = this.associationTableAdapter.getRecord(associationKey);
            if (record == null) {
                VTAssociationDB vTAssociationDB = null;
                return vTAssociationDB;
            }
            VTAssociationDB vTAssociationDB = new VTAssociationDB(this, this.associationCache, record);
            return vTAssociationDB;
        }
        catch (IOException e) {
            this.session.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    public VTSessionDB getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<VTAssociation> getRelatedAssociationsBySourceAddress(Address sourceAddress) {
        this.lock.acquire();
        try {
            long sourceID = this.session.getLongFromSourceAddress(sourceAddress);
            Set<Record> relatedRecords = this.associationTableAdapter.getRelatedAssociationRecordsBySourceAddress(sourceID);
            ArrayList<VTAssociationDB> associations = new ArrayList<VTAssociationDB>();
            for (Record record : relatedRecords) {
                associations.add(this.getAssociationForRecord(record));
            }
            ArrayList<VTAssociationDB> arrayList = associations;
            return arrayList;
        }
        catch (IOException e) {
            this.session.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<VTAssociation> getRelatedAssociationsByDestinationAddress(Address destinationAddress) {
        this.lock.acquire();
        try {
            long destinationID = this.session.getLongFromDestinationAddress(destinationAddress);
            Set<Record> relatedRecords = this.associationTableAdapter.getRelatedAssociationRecordsByDestinationAddress(destinationID);
            ArrayList<VTAssociationDB> associations = new ArrayList<VTAssociationDB>();
            for (Record record : relatedRecords) {
                associations.add(this.getAssociationForRecord(record));
            }
            ArrayList<VTAssociationDB> arrayList = associations;
            return arrayList;
        }
        catch (IOException e) {
            this.session.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<VTAssociation> getRelatedAssociationsBySourceAndDestinationAddress(Address sourceAddress, Address destinationAddress) {
        this.lock.acquire();
        try {
            long sourceID = this.session.getLongFromSourceAddress(sourceAddress);
            long destinationID = this.session.getLongFromDestinationAddress(destinationAddress);
            Set<Record> relatedRecords = this.associationTableAdapter.getRelatedAssociationRecordsBySourceAndDestinationAddress(sourceID, destinationID);
            ArrayList<VTAssociationDB> associations = new ArrayList<VTAssociationDB>();
            for (Record record : relatedRecords) {
                associations.add(this.getAssociationForRecord(record));
            }
            ArrayList<VTAssociationDB> arrayList = associations;
            return arrayList;
        }
        catch (IOException e) {
            this.session.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return Collections.emptyList();
    }

    void clearAcceptedAssociation(VTAssociation association) throws VTAssociationStatusException {
        VTAssociationStatus status = association.getStatus();
        if (status != VTAssociationStatus.ACCEPTED && status != VTAssociationStatus.REJECTED) {
            throw new VTAssociationStatusException("Cannot clear an association that is not already ACCEPTED or REJECTED - current status: " + status);
        }
        VTAssociationDB associationDB = (VTAssociationDB)association;
        this.verifyAssociationContainsNoAppliedMarkupItems(association);
        if (status == VTAssociationStatus.ACCEPTED) {
            associationDB.setStatus(VTAssociationStatus.AVAILABLE);
            this.associationCache.invalidate(associationDB.getKey());
            this.unblockRelatedAssociations(associationDB);
            for (AssociationHook hook : this.associationHooks) {
                hook.associationCleared(associationDB);
            }
        } else {
            associationDB.setStatus(this.isBlocked(associationDB) ? VTAssociationStatus.BLOCKED : VTAssociationStatus.AVAILABLE);
        }
    }

    void setAssociationAccepted(VTAssociation association) throws VTAssociationStatusException {
        VTAssociationStatus status = association.getStatus();
        if (status == VTAssociationStatus.ACCEPTED) {
            return;
        }
        if (status.isBlocked()) {
            throw new VTAssociationStatusException("Cannot ACCEPT a blocked association!");
        }
        VTAssociationDB associationDB = (VTAssociationDB)association;
        associationDB.setStatus(VTAssociationStatus.ACCEPTED);
        this.blockRelatedAssociations(associationDB);
        for (AssociationHook hook : this.associationHooks) {
            hook.associationAccepted(associationDB);
        }
    }

    private void verifyAssociationContainsNoAppliedMarkupItems(VTAssociation association) throws VTAssociationStatusException {
        if (association.hasAppliedMarkupItems()) {
            throw new VTAssociationStatusException("VTMarkupItemManager contains applied markup items");
        }
    }

    private void blockRelatedAssociations(VTAssociationDB association) {
        Set<VTAssociationDB> relatedAssociations = this.getRelatedAssociations(association);
        for (VTAssociationDB relatedAssociation : relatedAssociations) {
            VTAssociationStatus status = relatedAssociation.getStatus();
            switch (status) {
                case ACCEPTED: {
                    throw new AssertException("Attempted to block already accepted association!");
                }
                case AVAILABLE: {
                    relatedAssociation.setStatus(VTAssociationStatus.BLOCKED);
                    break;
                }
                case BLOCKED: {
                    break;
                }
            }
        }
    }

    private void unblockRelatedAssociations(VTAssociationDB association) {
        Set<VTAssociationDB> relatedAssociations = this.getRelatedAssociations(association);
        for (VTAssociationDB relatedAssociation : relatedAssociations) {
            VTAssociationStatus status = relatedAssociation.getStatus();
            switch (status) {
                case ACCEPTED: 
                case AVAILABLE: {
                    throw new AssertException("Attempted to unblock a non-blocked association!");
                }
                case BLOCKED: {
                    this.associationCache.invalidate(relatedAssociation.getKey());
                    relatedAssociation.setStatus(this.computeBlockedStatus(relatedAssociation));
                    break;
                }
            }
        }
    }

    private VTAssociationStatus computeBlockedStatus(VTAssociationDB association) {
        Set<VTAssociationDB> relatedAssociations = this.getRelatedAssociations(association);
        for (VTAssociationDB relatedAssociation : relatedAssociations) {
            if (relatedAssociation.getStatus() != VTAssociationStatus.ACCEPTED) continue;
            return VTAssociationStatus.BLOCKED;
        }
        return VTAssociationStatus.AVAILABLE;
    }

    private Set<VTAssociationDB> getRelatedAssociations(VTAssociationDB association) {
        long sourceID = this.session.getLongFromSourceAddress(association.getSourceAddress());
        long destinationID = this.session.getLongFromDestinationAddress(association.getDestinationAddress());
        HashSet<VTAssociationDB> relatedAssociaitons = new HashSet<VTAssociationDB>();
        try {
            Set<Record> relatedRecords = this.associationTableAdapter.getRelatedAssociationRecordsBySourceAndDestinationAddress(sourceID, destinationID);
            relatedRecords.remove(association.getRecord());
            for (Record record : relatedRecords) {
                relatedAssociaitons.add(this.getAssociationForRecord(record));
            }
        }
        catch (IOException e) {
            this.session.dbError(e);
        }
        return relatedAssociaitons;
    }

    void updateAssociationRecord(Record record) {
        try {
            this.associationTableAdapter.updateRecord(record);
        }
        catch (IOException e) {
            this.session.dbError(e);
        }
    }

    void updateMarkupRecord(Record record) {
        try {
            this.markupItemTableAdapter.updateRecord(record);
        }
        catch (IOException e) {
            this.session.dbError(e);
        }
    }

    void invalidateCache() {
        this.associationCache.invalidate();
        this.markupItemCache.invalidate();
    }

    void addAssociationHook(AssociationHook hook) {
        this.associationHooks.add(hook);
    }

    void removeAssociationHook(AssociationHook hook) {
        this.associationHooks.remove(hook);
    }

    void removeMarkupRecord(Record record) {
        try {
            this.markupItemTableAdapter.removeMatchMarkupItemRecord(record.getKey());
        }
        catch (IOException e) {
            this.session.dbError(e);
        }
    }

    void markupItemStatusChanged(VTMarkupItem markupItem) {
        for (AssociationHook hook : this.associationHooks) {
            hook.markupItemStatusChanged(markupItem);
        }
    }
}

