/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.analysis;

import ghidra.app.services.Analyzer;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.analysis.AnalysisPhase;
import ghidra.framework.analysis.AnalysisRecipe;
import ghidra.framework.analysis.AnalysisRecipeBuilder;
import ghidra.framework.analysis.AnalysisTask;
import ghidra.framework.analysis.AnalyzerScheduler;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.task.GTask;
import ghidra.framework.task.GTaskListener;
import ghidra.framework.task.GTaskManager;
import ghidra.framework.task.GTaskManagerFactory;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.HashedMap;

public class AnalysisManager {
    private AnalysisRecipe recipe;
    private Map<AnalyzerType, List<AnalyzerScheduler>> triggerMap;
    private List<AnalyzerScheduler> schedulers = new ArrayList<AnalyzerScheduler>();
    private GTaskManager taskManager;
    private AnalysisPhase currentPhase;
    private MessageLog messageLog = new MessageLog();

    public AnalysisManager(Program program) {
        this(program, AnalysisRecipeBuilder.getRecipe(program));
    }

    public AnalysisManager(Program program, AnalysisRecipe recipe) {
        this.recipe = recipe;
        this.taskManager = GTaskManagerFactory.getTaskManager((UndoableDomainObject)program);
        this.triggerMap = new HashedMap();
        this.initialize();
    }

    private void initialize() {
        List<Analyzer> analyzerList = this.recipe.getAnalyzers();
        for (int rank = 0; rank < analyzerList.size(); ++rank) {
            Analyzer analyzer = analyzerList.get(rank);
            AnalyzerScheduler scheduler = new AnalyzerScheduler(this, analyzer, rank);
            AnalyzerType analyzerType = analyzer.getAnalysisType();
            this.addScheduler(analyzerType, scheduler);
        }
        this.setPhase(this.recipe.getLastPhase());
    }

    private void setPhase(AnalysisPhase phase) {
        this.currentPhase = phase;
        for (AnalyzerScheduler scheduler : this.schedulers) {
            scheduler.setPhase(phase);
        }
    }

    private void addScheduler(AnalyzerType analysisType, AnalyzerScheduler analyzerScheduler) {
        this.schedulers.add(analyzerScheduler);
        List<AnalyzerScheduler> list = this.triggerMap.get((Object)analysisType);
        if (list == null) {
            list = new ArrayList<AnalyzerScheduler>();
            this.triggerMap.put(analysisType, list);
        }
        list.add(analyzerScheduler);
    }

    public void runAnalysis(AddressSet addressSet) {
        if (!this.currentPhase.equals(this.recipe.getLastPhase())) {
            Msg.showWarn((Object)this, null, (String)"Analysis Already Running!", (Object)"Please wait for the current analysis to complete before running analysis again.");
            return;
        }
        List<AnalysisPhase> analysisPhases = this.recipe.getAnalysisPhases();
        boolean isFirstPhase = true;
        for (AnalysisPhase analysisPhase : analysisPhases) {
            this.taskManager.scheduleTask((GTask)new StartPhaseTask(analysisPhase), 0, analysisPhase.getName());
            if (!isFirstPhase) continue;
            isFirstPhase = false;
            this.taskManager.scheduleTask((GTask)new KickStartAnalyzersTask(addressSet), 1, analysisPhase.getName());
        }
    }

    public void addTaskListener(GTaskListener listener) {
        this.taskManager.addTaskListener(listener);
    }

    public void removeTaskListener(GTaskListener listener) {
        this.taskManager.removeTaskListener(listener);
    }

    public void waitForAnalysis(long timeoutMillis) {
        this.taskManager.waitWhileBusy(timeoutMillis);
    }

    void scheduleAnalysisTask(AnalysisTask task) {
        this.taskManager.scheduleTask((GTask)task, 1000 + task.getPriority() * 10, task.getPhase().getName());
    }

    public List<AnalysisPhase> getPhases() {
        return this.recipe.getAnalysisPhases();
    }

    void triggerAnalysis(AnalyzerType analyzerType, AddressSetView addressSet) {
        List<AnalyzerScheduler> list = this.triggerMap.get((Object)analyzerType);
        if (list == null) {
            return;
        }
        for (AnalyzerScheduler analyzerScheduler : list) {
            analyzerScheduler.added(addressSet);
        }
    }

    public MessageLog getMessageLog() {
        return this.messageLog;
    }

    private class KickStartAnalyzersTask
    implements GTask {
        private AddressSetView restrictSet;

        public KickStartAnalyzersTask(AddressSet addressSet) {
            this.restrictSet = addressSet;
        }

        public String getName() {
            return "Analysis Address Set Primer Task";
        }

        public void run(UndoableDomainObject domainObject, TaskMonitor monitor) throws CancelledException {
            Program program = (Program)domainObject;
            if (this.restrictSet == null || this.restrictSet.isEmpty()) {
                this.analyzeExternalSpace(program);
                this.restrictSet = program.getMemory();
            }
            AnalysisManager.this.triggerAnalysis(AnalyzerType.BYTE_ANALYZER, this.restrictSet);
            if (program.getListing().getNumInstructions() != 0L) {
                AnalysisManager.this.triggerAnalysis(AnalyzerType.INSTRUCTION_ANALYZER, this.restrictSet);
            }
            if (program.getListing().getNumDefinedData() != 0L) {
                AnalysisManager.this.triggerAnalysis(AnalyzerType.DATA_ANALYZER, this.restrictSet);
            }
            if (program.getFunctionManager().getFunctions(true).hasNext()) {
                AnalysisManager.this.triggerAnalysis(AnalyzerType.FUNCTION_ANALYZER, this.restrictSet);
                AnalysisManager.this.triggerAnalysis(AnalyzerType.FUNCTION_SIGNATURES_ANALYZER, this.restrictSet);
            }
        }

        private void analyzeExternalSpace(Program program) {
            AnalysisManager.this.triggerAnalysis(AnalyzerType.BYTE_ANALYZER, (AddressSetView)new AddressSet(AddressSpace.EXTERNAL_SPACE.getMinAddress(), AddressSpace.EXTERNAL_SPACE.getMaxAddress()));
        }
    }

    private class StartPhaseTask
    implements GTask {
        private AnalysisPhase phase;

        public StartPhaseTask(AnalysisPhase phase) {
            this.phase = phase;
        }

        public String getName() {
            return this.phase.getName();
        }

        public void run(UndoableDomainObject domainObject, TaskMonitor monitor) throws CancelledException {
            Msg.debug((Object)this, (Object)("starting phase " + this.phase));
            AnalysisManager.this.setPhase(this.phase);
        }
    }
}

