/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.formats.gfilesystem.SelectFromListDialog;
import ghidra.formats.gfilesystem.factory.FileSystemInfoRec;
import java.util.List;

public interface FileSystemProbeConflictResolver {
    public static final FileSystemProbeConflictResolver CHOOSEFIRST = new FileSystemProbeConflictResolver(){

        @Override
        public FileSystemInfoRec chooseFSIR(List<FileSystemInfoRec> factories) {
            return factories.get(0);
        }
    };
    public static final FileSystemProbeConflictResolver GUI_PICKER = new FileSystemProbeConflictResolver(){

        @Override
        public FileSystemInfoRec chooseFSIR(List<FileSystemInfoRec> factories) {
            return SelectFromListDialog.selectFromList(factories, "Select filesystem", "Select a filesystem from list", FileSystemInfoRec::getDescription);
        }
    };

    default public FileSystemInfoRec resolveFSIR(List<FileSystemInfoRec> factories) {
        switch (factories.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return factories.get(0);
            }
        }
        return this.chooseFSIR(factories);
    }

    public FileSystemInfoRec chooseFSIR(List<FileSystemInfoRec> var1);
}

