/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.listingpanel;

import ghidra.framework.options.ToolOptions;
import ghidra.util.HelpLocation;
import java.awt.Color;

public class ListingCodeComparisonOptions {
    public static final String OPTIONS_CATEGORY_NAME = "Listing Code Comparison";
    public static final String HELP_TOPIC = "Listing Code Comparison";
    private static final String BYTE_DIFFS_COLOR_KEY = "Byte Differences Color";
    private static final String MNEMONIC_DIFFS_COLOR_KEY = "Mnemonic Differences Color";
    private static final String OPERAND_DIFFS_COLOR_KEY = "Operand Differences Color";
    private static final String UNMATCHED_CODE_UNITS_COLOR_KEY = "Unmatched Code Units Color";
    private static final String DIFF_CODE_UNITS_COLOR_KEY = "Differing Code Units Color";
    private static final String DEFAULT_BYTE_DIFFS_BACKGROUND_COLOR_DESCRIPTION = "The default background color applied to byte differences within the listing code comparison window.";
    private static final String DEFAULT_MNEMONIC_DIFFS_BACKGROUND_COLOR_DESCRIPTION = "The default background color applied to mnemonic differences for matched addresses within the listing code comparison window.";
    private static final String DEFAULT_OPERAND_DIFFS_BACKGROUND_COLOR_DESCRIPTION = "The default background color applied to operand differences within the listing code comparison window.";
    private static final String DEFAULT_DIFF_CODE_UNITS_BACKGROUND_COLOR_DESCRIPTION = "The default background color applied to code units with any detected differences within the listing code comparison window.";
    private static final String DEFAULT_UNMATCHED_CODE_UNITS_BACKGROUND_COLOR_DESCRIPTION = "The default background color applied to code units that are unmatched within the listing code comparison window by the address correlator.";
    public static final Color MEDIUM_SKY_BLUE_COLOR = new Color(105, 205, 225);
    public static final Color MEDIUM_GRAY_COLOR = new Color(185, 185, 185);
    public static final Color SPRING_GREEN_COLOR;
    private static final Color DEFAULT_BYTE_DIFFS_COLOR;
    private static final Color DEFAULT_MNEMONIC_DIFFS_COLOR;
    private static final Color DEFAULT_OPERAND_DIFFS_COLOR;
    private static final Color DEFAULT_DIFF_CODE_UNITS_COLOR;
    private static final Color DEFAULT_UNMATCHED_CODE_UNITS_COLOR;
    private Color byteDiffsColor = DEFAULT_BYTE_DIFFS_COLOR;
    private Color mnemonicDiffsColor = DEFAULT_MNEMONIC_DIFFS_COLOR;
    private Color operandDiffsColor = DEFAULT_OPERAND_DIFFS_COLOR;
    private Color diffCodeUnitsColor = DEFAULT_DIFF_CODE_UNITS_COLOR;
    private Color unmatchedCodeUnitsColor = DEFAULT_UNMATCHED_CODE_UNITS_COLOR;

    public Color getDefaultByteDiffsBackgroundColor() {
        return DEFAULT_BYTE_DIFFS_COLOR;
    }

    public Color getDefaultMnemonicDiffsBackgroundColor() {
        return DEFAULT_MNEMONIC_DIFFS_COLOR;
    }

    public Color getDefaultOperandDiffsBackgroundColor() {
        return DEFAULT_OPERAND_DIFFS_COLOR;
    }

    public Color getDefaultDiffCodeUnitsBackgroundColor() {
        return DEFAULT_DIFF_CODE_UNITS_COLOR;
    }

    public Color getDefaultUnmatchedCodeUnitsBackgroundColor() {
        return DEFAULT_UNMATCHED_CODE_UNITS_COLOR;
    }

    public Color getByteDiffsBackgroundColor() {
        return this.byteDiffsColor;
    }

    public Color getMnemonicDiffsBackgroundColor() {
        return this.mnemonicDiffsColor;
    }

    public Color getOperandDiffsBackgroundColor() {
        return this.operandDiffsColor;
    }

    public Color getDiffCodeUnitsBackgroundColor() {
        return this.diffCodeUnitsColor;
    }

    public Color getUnmatchedCodeUnitsBackgroundColor() {
        return this.unmatchedCodeUnitsColor;
    }

    public void initializeOptions(ToolOptions options) {
        HelpLocation help = new HelpLocation("Listing Code Comparison", "Options");
        options.setOptionsHelpLocation(help);
        options.registerOption(BYTE_DIFFS_COLOR_KEY, (Object)DEFAULT_BYTE_DIFFS_COLOR, help, DEFAULT_BYTE_DIFFS_BACKGROUND_COLOR_DESCRIPTION);
        options.registerOption(MNEMONIC_DIFFS_COLOR_KEY, (Object)DEFAULT_MNEMONIC_DIFFS_COLOR, help, DEFAULT_MNEMONIC_DIFFS_BACKGROUND_COLOR_DESCRIPTION);
        options.registerOption(OPERAND_DIFFS_COLOR_KEY, (Object)DEFAULT_OPERAND_DIFFS_COLOR, help, DEFAULT_OPERAND_DIFFS_BACKGROUND_COLOR_DESCRIPTION);
        options.registerOption(DIFF_CODE_UNITS_COLOR_KEY, (Object)DEFAULT_DIFF_CODE_UNITS_COLOR, help, DEFAULT_DIFF_CODE_UNITS_BACKGROUND_COLOR_DESCRIPTION);
        options.registerOption(UNMATCHED_CODE_UNITS_COLOR_KEY, (Object)DEFAULT_UNMATCHED_CODE_UNITS_COLOR, help, DEFAULT_UNMATCHED_CODE_UNITS_BACKGROUND_COLOR_DESCRIPTION);
    }

    public void loadOptions(ToolOptions options) {
        this.byteDiffsColor = options.getColor(BYTE_DIFFS_COLOR_KEY, DEFAULT_BYTE_DIFFS_COLOR);
        this.mnemonicDiffsColor = options.getColor(MNEMONIC_DIFFS_COLOR_KEY, DEFAULT_MNEMONIC_DIFFS_COLOR);
        this.operandDiffsColor = options.getColor(OPERAND_DIFFS_COLOR_KEY, DEFAULT_OPERAND_DIFFS_COLOR);
        this.diffCodeUnitsColor = options.getColor(DIFF_CODE_UNITS_COLOR_KEY, DEFAULT_DIFF_CODE_UNITS_COLOR);
        this.unmatchedCodeUnitsColor = options.getColor(UNMATCHED_CODE_UNITS_COLOR_KEY, DEFAULT_UNMATCHED_CODE_UNITS_COLOR);
    }

    static {
        DEFAULT_BYTE_DIFFS_COLOR = SPRING_GREEN_COLOR = new Color(175, 255, 105);
        DEFAULT_MNEMONIC_DIFFS_COLOR = SPRING_GREEN_COLOR;
        DEFAULT_OPERAND_DIFFS_COLOR = SPRING_GREEN_COLOR;
        DEFAULT_DIFF_CODE_UNITS_COLOR = MEDIUM_GRAY_COLOR;
        DEFAULT_UNMATCHED_CODE_UNITS_COLOR = MEDIUM_SKY_BLUE_COLOR;
    }
}

