/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.dyld.DyldArchitecture;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import java.io.IOException;

public class DyldCacheUtils {
    public static final boolean isDyldCache(Program program) {
        if (program == null) {
            return false;
        }
        if (program.getMemory().getSize() < 16L) {
            return false;
        }
        byte[] bytes = new byte[16];
        try {
            Address address = program.getMinAddress();
            program.getMemory().getBytes(address, bytes);
        }
        catch (MemoryAccessException e) {
            return false;
        }
        return DyldCacheUtils.isDyldCache(new String(bytes).trim());
    }

    public static final boolean isDyldCache(ByteProvider provider) {
        if (provider == null) {
            return false;
        }
        byte[] bytes = new byte[16];
        try {
            bytes = provider.readBytes(0L, 16L);
        }
        catch (IOException e) {
            return false;
        }
        return DyldCacheUtils.isDyldCache(new String(bytes).trim());
    }

    public static final boolean isDyldCache(String signature) {
        for (DyldArchitecture architecture : DyldArchitecture.ARCHITECTURES) {
            if (!architecture.getSignature().equals(signature)) continue;
            return true;
        }
        return false;
    }
}

