/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.cparser.CPP;

import ghidra.app.util.cparser.CPP.PreProcessor;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.util.AddressEvaluator;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class DefineTable {
    Hashtable<String, PreProcessor.PPToken> defs = new Hashtable();
    Hashtable<String, Vector<PreProcessor.PPToken>> args = new Hashtable();
    Hashtable lookupTable = new Hashtable();
    private static final String VALUE = "value";

    public PreProcessor.PPToken get(String string) {
        return this.defs.get(string);
    }

    public Vector<PreProcessor.PPToken> getArgs(String currKey) {
        return this.args.get(currKey);
    }

    public String getDefineAt(StringBuffer buf, int pos) {
        Hashtable findTable = this.lookupTable;
        String found = null;
        while (findTable != null && pos < buf.length()) {
            String value;
            char ch;
            Character chObj;
            if ((findTable = (Hashtable)findTable.get(chObj = new Character(ch = buf.charAt(pos++)))) == null || (value = (String)findTable.get(VALUE)) == null) continue;
            found = value;
        }
        return found;
    }

    public void put(String string, PreProcessor.PPToken val) {
        this.defs.put(string, val);
        Hashtable<Object, Object> findTable = this.lookupTable;
        Character chObj = null;
        int pos = 0;
        int len = string.length();
        while (pos < len) {
            char ch;
            Hashtable<Object, Object> node;
            if ((node = (Hashtable<Object, Object>)findTable.get(chObj = new Character(ch = string.charAt(pos++)))) == null) {
                node = new Hashtable<Object, Object>();
                findTable.put(chObj, node);
                findTable = node;
                continue;
            }
            findTable = node;
        }
        findTable.put(VALUE, string);
    }

    public void putArg(String string, Vector<PreProcessor.PPToken> val) {
        this.args.put(string, val);
    }

    public boolean containsKey(String def) {
        return this.defs.containsKey(def);
    }

    public int size() {
        return this.defs.size();
    }

    public PreProcessor.PPToken remove(String string) {
        PreProcessor.PPToken token = this.defs.remove(string);
        Hashtable findTable = this.lookupTable;
        Character chObj = null;
        int pos = 0;
        int len = string.length();
        while (pos < len) {
            char ch;
            if ((findTable = (Hashtable)findTable.get(chObj = new Character(ch = string.charAt(pos++)))) != null) continue;
            return token;
        }
        findTable.remove(VALUE);
        return token;
    }

    public boolean isArg(String string) {
        return this.args.containsKey(string);
    }

    public Vector<PreProcessor.PPToken> removeArg(String string) {
        return this.args.remove(string);
    }

    public String toString(String string) {
        StringBuffer buf = new StringBuffer(string);
        PreProcessor.PPToken token = this.defs.get(string);
        Vector<PreProcessor.PPToken> argVector = this.getArgs(string);
        if (argVector != null) {
            buf.append("(");
            for (int i = 0; i < argVector.size(); ++i) {
                PreProcessor.PPToken arg = argVector.get(i);
                buf.append(arg);
                if (i + 1 >= argVector.size()) continue;
                buf.append(", ");
            }
            buf.append(" )");
        }
        buf.append(" = " + token.toString());
        return buf.toString();
    }

    public Iterator<String> getDefineNames() {
        return this.defs.keySet().iterator();
    }

    public String getValue(String defName) {
        PreProcessor.PPToken token = this.defs.get(defName);
        if (token == null) {
            return null;
        }
        return token.image;
    }

    public boolean isNumeric(String defName) {
        PreProcessor.PPToken token = this.defs.get(defName);
        if (token == null) {
            return false;
        }
        return token.kind == 113 || token.kind == 114;
    }

    public String getDefinitionPath(String defName) {
        PreProcessor.PPToken token = this.defs.get(defName);
        if (token == null) {
            return null;
        }
        return token.getPath();
    }

    private String macroSub(String image, int pos, ArrayList<String> sublist) {
        int replaceCount = 0;
        StringBuffer buf = new StringBuffer(image);
        while (pos < buf.length() && replaceCount < 900000) {
            String defName = this.getDefineAt(buf, pos);
            if (this.shouldReplace(buf, defName, pos)) {
                int newpos = this.replace(buf, defName, pos, sublist);
                if (newpos == -1) {
                    ++pos;
                    continue;
                }
                pos = newpos;
                ++replaceCount;
                continue;
            }
            ++pos;
        }
        if (replaceCount >= 100000) {
            System.err.println(" replace " + image + " hit limit");
        }
        return buf.toString();
    }

    private boolean shouldReplace(StringBuffer buf, String defName, int pos) {
        if (defName == null) {
            return false;
        }
        int currIndex = buf.indexOf(defName, pos);
        if (currIndex < 0) {
            return false;
        }
        if (currIndex > 0 && (Character.isJavaIdentifierStart(buf.charAt(currIndex - 1)) || Character.isJavaIdentifierPart(buf.charAt(currIndex - 1)))) {
            return false;
        }
        int afterIndex = currIndex + defName.length();
        if (afterIndex < buf.length() && (Character.isJavaIdentifierStart(buf.charAt(afterIndex)) || Character.isJavaIdentifierPart(buf.charAt(afterIndex)))) {
            return false;
        }
        String replacementString = this.defs.get((Object)defName).image;
        return !replacementString.equals(defName);
    }

    int replace(StringBuffer buf, String currKey, int fromIndex, ArrayList<String> sublist) {
        int currIndex;
        String replacementString = null;
        if (sublist == null) {
            sublist = new ArrayList();
        }
        if ((currIndex = buf.indexOf(currKey, fromIndex)) < 0) {
            return -1;
        }
        if (currIndex > 0 && (Character.isJavaIdentifierStart(buf.charAt(currIndex - 1)) || Character.isJavaIdentifierPart(buf.charAt(currIndex - 1)))) {
            return -1;
        }
        int afterIndex = currIndex + currKey.length();
        if (afterIndex < buf.length() && (Character.isJavaIdentifierStart(buf.charAt(afterIndex)) || Character.isJavaIdentifierPart(buf.charAt(afterIndex)))) {
            return -1;
        }
        replacementString = this.defs.get((Object)currKey).image;
        if (replacementString.equals(currKey)) {
            return -1;
        }
        Vector<PreProcessor.PPToken> argv = this.getArgs(currKey);
        int replacedSubpieceLen = currKey.length();
        if (argv == null && sublist.contains(currKey)) {
            System.err.println("DONT Replace " + currKey + " in: " + buf);
            return -1;
        }
        if (argv != null && argv.size() > 0) {
            String parms = this.getParams(buf, currIndex + currKey.length(), '\u0000');
            int parmslen = parms.length();
            if (parmslen < 2) {
                return -1;
            }
            if (!(parms = parms.trim()).startsWith("(") || !parms.endsWith(")")) {
                return -1;
            }
            parms = parms.substring(1, parms.length() - 1);
            replacementString = this.subParams(replacementString, currKey, parms, argv);
            replacementString = this.joinPdPd(replacementString);
            replacedSubpieceLen += parmslen;
        }
        sublist = new ArrayList<String>(sublist);
        sublist.add(currKey);
        String newReplString = this.macroSub(replacementString, 0, sublist);
        if (newReplString != null) {
            replacementString = newReplString;
        }
        buf.replace(currIndex, currIndex + replacedSubpieceLen, replacementString);
        return currIndex + replacementString.length();
    }

    String subParams(String replString, String defName, String parms, Vector<PreProcessor.PPToken> argv) {
        String substString = replString;
        ArrayList<Integer> beginPos = new ArrayList<Integer>();
        ArrayList<Integer> endPos = new ArrayList<Integer>();
        ArrayList<String> subValue = new ArrayList<String>();
        int index = 0;
        int pos = 0;
        StringBuffer argsfound = new StringBuffer();
        while (pos < parms.length() || index < argv.size()) {
            String argValue = "";
            if (pos < parms.length()) {
                argValue = this.getParams(new StringBuffer(parms), pos, ',');
            }
            pos += argValue.length() + 1;
            if (index >= argv.size()) {
                Msg.error((Object)this, (Object)("Define parameter mismatch for macro " + defName + "(" + parms + ") Expected " + argv.size() + " arguments.   badarg(" + index + ") " + argValue + " args processed : " + argsfound));
                return replString;
            }
            String curArgName = argv.elementAt((int)index).image;
            ++index;
            argValue = argValue.trim();
            argsfound.append(argValue);
            argsfound.append(", ");
            int curpos = -1;
            do {
                Integer loc;
                int insertLoc;
                int afterIndex;
                if ((curpos = substString.indexOf(curArgName, curpos + 1)) < 0 || curpos > 0 && (Character.isJavaIdentifierStart(substString.charAt(curpos - 1)) || Character.isJavaIdentifierPart(substString.charAt(curpos - 1))) || (afterIndex = curpos + curArgName.length()) < substString.length() && (Character.isJavaIdentifierStart(substString.charAt(afterIndex)) || Character.isJavaIdentifierPart(substString.charAt(afterIndex)))) continue;
                Integer begin = new Integer(curpos);
                for (insertLoc = 0; insertLoc < beginPos.size() && (loc = (Integer)beginPos.get(insertLoc)).compareTo(begin) <= 0; ++insertLoc) {
                }
                beginPos.add(insertLoc, begin);
                endPos.add(insertLoc, new Integer(curpos + curArgName.length()));
                subValue.add(insertLoc, argValue);
            } while (curpos >= 0);
        }
        StringBuffer buf = new StringBuffer();
        int listSize = beginPos.size();
        int startpos = 0;
        for (int i = 0; i < listSize; ++i) {
            int begin = (Integer)beginPos.get(i);
            int end = (Integer)endPos.get(i);
            String value = (String)subValue.get(i);
            buf.append(substString.substring(startpos, begin));
            buf.append(value);
            startpos = end;
        }
        buf.append(substString.substring(startpos));
        substString = buf.toString();
        return substString;
    }

    public String getParams(StringBuffer buf, int start, char endChar) {
        int len = buf.length();
        int depth = 0;
        int pos = start;
        if (pos >= len) {
            return "";
        }
        char ch = buf.charAt(pos);
        boolean hitQuote = false;
        while (pos < len) {
            if ((ch = buf.charAt(pos++)) == '\"') {
                boolean bl = hitQuote = !hitQuote;
            }
            if (!hitQuote && ch == endChar && depth == 0) {
                --pos;
                break;
            }
            if (!hitQuote && ch == ')') {
                if (--depth == 0 && endChar == '\u0000') break;
                if (depth < 0) {
                    --pos;
                    break;
                }
            }
            if (hitQuote || ch != '(') continue;
            ++depth;
        }
        return buf.substring(start, pos);
    }

    public String expand(String image, boolean join) {
        image = this.macroSub((String)image, 0, null);
        if (join) {
            image = this.joinPdPd((String)image);
        }
        if (((String)image).length() > 0 && ((String)image).charAt(0) == '#') {
            image = "\"" + ((String)image).substring(1) + "\"";
        }
        return image;
    }

    private String joinPdPd(String image) {
        int currIndex = image.length();
        StringBuffer buf = new StringBuffer(image);
        do {
            if ((currIndex = image.lastIndexOf("##", currIndex)) < 0) continue;
            boolean inString = false;
            int quotePos = image.length();
            do {
                if ((quotePos = image.lastIndexOf("\"", quotePos)) <= currIndex || quotePos < 0) continue;
                boolean bl = inString = !inString;
            } while (--quotePos > currIndex);
            int afterIndex = currIndex + 2;
            while (currIndex > 0 && image.charAt(currIndex - 1) == ' ') {
                --currIndex;
            }
            while (afterIndex < image.length() && image.charAt(afterIndex) == ' ') {
                ++afterIndex;
            }
            if (!inString) {
                buf.replace(currIndex, afterIndex, "");
                --currIndex;
                continue;
            }
            currIndex -= 2;
        } while (currIndex > 0);
        image = buf.toString();
        return image;
    }

    public void populateDefineEquates(DataTypeManager dtMgr) {
        int transactionID = dtMgr.startTransaction("Add Equates");
        Iterator<String> iter = this.getDefineNames();
        while (iter.hasNext()) {
            String strExpanded;
            String defName = iter.next();
            if (this.isArg(defName)) continue;
            String strValue = this.getValue(defName);
            strValue = strExpanded = this.expand(strValue, true);
            strValue = DefineTable.stripCast(strValue);
            long value = 0L;
            Long lvalue = DefineTable.getCValue(strValue);
            if (lvalue == null && (lvalue = AddressEvaluator.evaluateToLong((String)strValue)) == null) continue;
            value = lvalue;
            String enumName = "define_" + defName;
            EnumDataType enuum = new EnumDataType(enumName, 8);
            enuum.add(defName, value);
            String defPath = this.getDefinitionPath(defName);
            String currentCategoryName = DefineTable.getFileName(defPath);
            CategoryPath path = DefineTable.getCategory(currentCategoryName);
            path = new CategoryPath(path, new String[]{"defines"});
            enuum.setCategoryPath(path);
            dtMgr.addDataType((DataType)enuum, DataTypeConflictHandler.DEFAULT_HANDLER);
        }
        dtMgr.endTransaction(transactionID, true);
    }

    private static Long getCValue(String strValue) {
        try {
            int start = 0;
            int radix = 10;
            strValue = strValue.toLowerCase();
            if (strValue.startsWith("0x")) {
                start = 2;
                radix = 16;
            } else if (strValue.startsWith("0")) {
                start = 1;
                radix = 8;
            }
            if (strValue.endsWith("ul") || strValue.endsWith("ll")) {
                strValue = strValue.substring(0, strValue.length() - 2);
            } else if (strValue.endsWith("l") || strValue.endsWith("u")) {
                strValue = strValue.substring(0, strValue.length() - 1);
            }
            if (start != 0) {
                strValue = strValue.substring(start);
            }
            return Long.parseLong(strValue, radix);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    private static CategoryPath getCategory(String catName) {
        CategoryPath rootCat = CategoryPath.ROOT;
        if (catName == null || catName.length() == 0) {
            return rootCat;
        }
        return new CategoryPath(rootCat, new String[]{catName});
    }

    private static String getFileName(String path) {
        int slashpos = path.lastIndexOf(47);
        if (slashpos < 0) {
            slashpos = path.lastIndexOf(92);
        }
        if (slashpos < 0) {
            return path;
        }
        return path.substring(slashpos + 1);
    }

    private static String stripCast(String strValue) {
        int procLen;
        strValue = ((String)strValue).trim();
        for (int pos = 0; pos < ((String)strValue).length(); pos += procLen) {
            procLen = 1;
            int startPos = ((String)strValue).indexOf(40, pos);
            if (startPos == -1) {
                return strValue;
            }
            pos = startPos;
            int endParen = ((String)strValue).indexOf(41, pos + 1);
            if (endParen != -1) {
                boolean isValid;
                char ch;
                String subStr = ((String)strValue).substring(pos + 1, endParen);
                if (subStr.length() <= 0) continue;
                int subPos = 0;
                subStr = subStr.trim();
                for (isValid = Character.isJavaIdentifierStart(subStr.charAt(0)); isValid && subPos < subStr.length(); isValid |= Character.isJavaIdentifierPart(ch)) {
                    ch = subStr.charAt(subPos++);
                }
                if (!isValid) continue;
                strValue = ((String)strValue).substring(0, pos) + ((String)strValue).substring(endParen + 1);
                procLen = 0;
                continue;
            }
            return strValue;
        }
        return strValue;
    }
}

