/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.streams;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.bin.format.pe.cli.CliStreamHeader;
import ghidra.app.util.bin.format.pe.cli.streams.CliAbstractStream;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamBlob;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamGuid;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamStrings;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamUserStrings;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableAssembly;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableAssemblyOS;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableAssemblyProcessor;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableAssemblyRef;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableAssemblyRefOS;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableAssemblyRefProcessor;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableClassLayout;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableConstant;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableCustomAttribute;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableDeclSecurity;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableEvent;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableEventMap;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableExportedType;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableField;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableFieldLayout;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableFieldMarshall;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableFieldRVA;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableFile;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableGenericParam;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableGenericParamConstraint;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableImplMap;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableInterfaceImpl;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableManifestResource;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableMemberRef;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableMethodDef;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableMethodImpl;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableMethodSemantics;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableMethodSpec;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableModule;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableModuleRef;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableNestedClass;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableParam;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableProperty;
import ghidra.app.util.bin.format.pe.cli.tables.CliTablePropertyMap;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableStandAloneSig;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableTypeDef;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableTypeRef;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableTypeSpec;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class CliStreamMetadata
extends CliAbstractStream {
    private byte majorVersion;
    private byte minorVersion;
    private byte heapSizes;
    private long valid;
    private long sorted;
    private HashMap<CliTypeTable, Integer> rows;
    private ArrayList<CliAbstractTable> tables = new ArrayList();
    private CliStreamGuid guidStream;
    private CliStreamUserStrings userStringsStream;
    private CliStreamStrings stringsStream;
    private CliStreamBlob blobStream;

    public static String getName() {
        return "#~";
    }

    public CliStreamMetadata(CliStreamHeader header, CliStreamGuid guidStream, CliStreamUserStrings userStringsStream, CliStreamStrings stringsStream, CliStreamBlob blobStream, long fileOffset, int rva, BinaryReader reader) throws IOException {
        super(header, fileOffset, rva, reader);
        this.rows = new HashMap();
        this.tables = new ArrayList();
        this.guidStream = guidStream;
        this.userStringsStream = userStringsStream;
        this.stringsStream = stringsStream;
        this.blobStream = blobStream;
    }

    @Override
    public boolean parse() throws IOException {
        CliTypeTable tableType;
        int i;
        this.reader.setPointerIndex(this.offset);
        this.reader.readNextInt();
        this.majorVersion = this.reader.readNextByte();
        this.minorVersion = this.reader.readNextByte();
        this.heapSizes = this.reader.readNextByte();
        this.reader.readNextByte();
        this.valid = this.reader.readNextLong();
        this.sorted = this.reader.readNextLong();
        for (i = 0; i < 64; ++i) {
            if ((this.valid & 1L << i) == 0L) continue;
            tableType = CliTypeTable.fromId(i);
            if (tableType != null) {
                this.rows.put(tableType, this.reader.readNextInt());
                continue;
            }
            Msg.warn((Object)this, (Object)("CLI metadata table with id " + i + " is not supported"));
        }
        for (i = 0; i < 64; ++i) {
            if ((this.valid & 1L << i) == 0L || (tableType = CliTypeTable.fromId(i)) == null) continue;
            long origIndex = this.reader.getPointerIndex();
            CliAbstractTable table = this.createTableObject(tableType);
            this.tables.add(table);
            this.reader.setPointerIndex(origIndex + (long)table.toDataType().getLength());
        }
        return true;
    }

    public CliStreamGuid getGuidStream() {
        return this.guidStream;
    }

    public CliStreamUserStrings getUserStringsStream() {
        return this.userStringsStream;
    }

    public CliStreamStrings getStringsStream() {
        return this.stringsStream;
    }

    public CliStreamBlob getBlobStream() {
        return this.blobStream;
    }

    private CliAbstractTable createTableObject(CliTypeTable tableType) throws IOException {
        switch (tableType) {
            case Module: {
                return new CliTableModule(this.reader, this, tableType);
            }
            case TypeRef: {
                return new CliTableTypeRef(this.reader, this, tableType);
            }
            case TypeDef: {
                return new CliTableTypeDef(this.reader, this, tableType);
            }
            case Field: {
                return new CliTableField(this.reader, this, tableType);
            }
            case MethodDef: {
                return new CliTableMethodDef(this.reader, this, tableType);
            }
            case Param: {
                return new CliTableParam(this.reader, this, tableType);
            }
            case InterfaceImpl: {
                return new CliTableInterfaceImpl(this.reader, this, tableType);
            }
            case MemberRef: {
                return new CliTableMemberRef(this.reader, this, tableType);
            }
            case Constant: {
                return new CliTableConstant(this.reader, this, tableType);
            }
            case CustomAttribute: {
                return new CliTableCustomAttribute(this.reader, this, tableType);
            }
            case FieldMarshal: {
                return new CliTableFieldMarshall(this.reader, this, tableType);
            }
            case DeclSecurity: {
                return new CliTableDeclSecurity(this.reader, this, tableType);
            }
            case ClassLayout: {
                return new CliTableClassLayout(this.reader, this, tableType);
            }
            case FieldLayout: {
                return new CliTableFieldLayout(this.reader, this, tableType);
            }
            case StandAloneSig: {
                return new CliTableStandAloneSig(this.reader, this, tableType);
            }
            case EventMap: {
                return new CliTableEventMap(this.reader, this, tableType);
            }
            case Event: {
                return new CliTableEvent(this.reader, this, tableType);
            }
            case PropertyMap: {
                return new CliTablePropertyMap(this.reader, this, tableType);
            }
            case Property: {
                return new CliTableProperty(this.reader, this, tableType);
            }
            case MethodSemantics: {
                return new CliTableMethodSemantics(this.reader, this, tableType);
            }
            case MethodImpl: {
                return new CliTableMethodImpl(this.reader, this, tableType);
            }
            case ModuleRef: {
                return new CliTableModuleRef(this.reader, this, tableType);
            }
            case TypeSpec: {
                return new CliTableTypeSpec(this.reader, this, tableType);
            }
            case ImplMap: {
                return new CliTableImplMap(this.reader, this, tableType);
            }
            case FieldRVA: {
                return new CliTableFieldRVA(this.reader, this, tableType);
            }
            case Assembly: {
                return new CliTableAssembly(this.reader, this, tableType);
            }
            case AssemblyProcessor: {
                return new CliTableAssemblyProcessor(this.reader, this, tableType);
            }
            case AssemblyOS: {
                return new CliTableAssemblyOS(this.reader, this, tableType);
            }
            case AssemblyRef: {
                return new CliTableAssemblyRef(this.reader, this, tableType);
            }
            case AssemblyRefProcessor: {
                return new CliTableAssemblyRefProcessor(this.reader, this, tableType);
            }
            case AssemblyRefOS: {
                return new CliTableAssemblyRefOS(this.reader, this, tableType);
            }
            case File: {
                return new CliTableFile(this.reader, this, tableType);
            }
            case ExportedType: {
                return new CliTableExportedType(this.reader, this, tableType);
            }
            case ManifestResource: {
                return new CliTableManifestResource(this.reader, this, tableType);
            }
            case NestedClass: {
                return new CliTableNestedClass(this.reader, this, tableType);
            }
            case GenericParam: {
                return new CliTableGenericParam(this.reader, this, tableType);
            }
            case MethodSpec: {
                return new CliTableMethodSpec(this.reader, this, tableType);
            }
            case GenericParamConstraint: {
                return new CliTableGenericParamConstraint(this.reader, this, tableType);
            }
        }
        Msg.warn((Object)this, (Object)("Parsing table type \"" + tableType.toString() + "\" is not supported."));
        return null;
    }

    public short getMajorVersion() {
        return this.majorVersion;
    }

    public short getMinorVersion() {
        return this.minorVersion;
    }

    public long getSorted() {
        return this.sorted;
    }

    public long getValid() {
        return this.valid;
    }

    public CliAbstractTable getTable(CliTypeTable tableType) {
        CliAbstractTable tableObj;
        if (!this.isTablePresent(tableType)) {
            return null;
        }
        int tableIndex = this.getPresentTableIndex(tableType);
        if (tableIndex < this.tables.size() && (tableObj = this.tables.get(tableIndex)).getTableType() == tableType) {
            return tableObj;
        }
        return null;
    }

    public CliAbstractTable getTable(int tableId) {
        return this.getTable(CliTypeTable.fromId(tableId));
    }

    public int getNumberRowsForTable(CliTypeTable tableType) {
        Integer ret = this.rows.get((Object)tableType);
        return ret != null ? ret : 0;
    }

    public DataType getStringIndexDataType() {
        return (this.heapSizes & 1) != 0 ? DWordDataType.dataType : WordDataType.dataType;
    }

    public DataType getGuidIndexDataType() {
        return (this.heapSizes & 2) != 0 ? DWordDataType.dataType : WordDataType.dataType;
    }

    public DataType getBlobIndexDataType() {
        return (this.heapSizes & 4) != 0 ? DWordDataType.dataType : WordDataType.dataType;
    }

    public DataType getTableIndexDataType(CliTypeTable table) {
        return this.getNumberRowsForTable(table) >= 65536 ? DWordDataType.dataType : WordDataType.dataType;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, IOException {
        super.markup(program, isBinary, monitor, log, ntHeader);
        for (CliAbstractTable table : this.tables) {
            try {
                table.markup(program, isBinary, monitor, log, ntHeader);
                Address addr = PeUtils.getMarkupAddress(program, isBinary, ntHeader, this.rva + this.getTableOffset(table.getTableType()));
                program.getBookmarkManager().setBookmark(addr, "Info", "CLI Table", table.toString());
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Failed to markup " + table));
            }
        }
    }

    @Override
    public DataType toDataType() {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Streams"), this.header.getName(), 0);
        struct.add(DWORD, "Reserved", "Always 0");
        struct.add(BYTE, "MajorVersion", null);
        struct.add(BYTE, "MinorVersion", null);
        struct.add(BYTE, "HeapSizes", "Bit vector for heap sizes");
        struct.add(BYTE, "Reserved", "Always 1");
        struct.add(QWORD, "Valid", "Bit vector of present tables");
        struct.add(QWORD, "Sorted", "Bit vector of sorted tables");
        struct.add((DataType)new ArrayDataType(DWORD, Long.bitCount(this.valid), DWORD.getLength()), "Rows", "# of rows for each corresponding present table");
        for (CliAbstractTable table : this.tables) {
            struct.add(table.toDataType(), table.toString(), "CLI Metadata Table: " + table.toString());
        }
        return struct;
    }

    private boolean isTablePresent(CliTypeTable tableType) {
        return (this.valid & 1L << tableType.id()) != 0L;
    }

    private int getTableOffset(CliTypeTable table) {
        StructureDataType struct = (StructureDataType)this.toDataType();
        int structOffset = 8;
        return struct.getComponent(structOffset += this.getPresentTableIndex(table)).getOffset();
    }

    private int getPresentTableIndex(CliTypeTable table) {
        int tableId = table.id();
        long mask = this.valid & (1L << tableId) - 1L;
        int tablesBefore = Long.bitCount(mask);
        return tablesBefore;
    }
}

