/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.dyld;

import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.RelocationInfo;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.commands.DynamicSymbolTableCommand;
import ghidra.app.util.bin.format.macho.commands.NList;
import ghidra.app.util.bin.format.macho.commands.SymbolTableCommand;
import ghidra.app.util.bin.format.macho.commands.dyld.AbstractClassicProcessor;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class ClassicBindProcessor
extends AbstractClassicProcessor {
    public ClassicBindProcessor(MachHeader header, Program program) {
        super(header, program);
    }

    public void process(TaskMonitor monitor) throws Exception {
        SymbolTableCommand symbolTableCommand = this.header.getFirstLoadCommand(SymbolTableCommand.class);
        List<DynamicSymbolTableCommand> commands = this.header.getLoadCommands(DynamicSymbolTableCommand.class);
        for (DynamicSymbolTableCommand command : commands) {
            if (monitor.isCancelled()) break;
            List<RelocationInfo> relocations = command.getExternalRelocations();
            for (RelocationInfo relocation : relocations) {
                if (monitor.isCancelled()) break;
                long address = (long)relocation.getAddress() + this.getRelocationBase();
                int symbolIndex = relocation.getSymbolIndex();
                NList nList = symbolTableCommand.getSymbolAt(symbolIndex);
                boolean isWeak = (nList.getDescription() & 0x40) != 0;
                String fromDylib = this.getClassicOrdinalName(nList.getLibraryOrdinal());
                Section section = this.getSectionName(address);
                if (section == null) continue;
                String sectionName = section.getSectionName();
                String segmentName = section.getSegmentName();
                if ((this.header.getFlags() & 0x10) != 0) {
                    // empty if block
                }
                this.perform(segmentName, sectionName, address, fromDylib, nList, isWeak, monitor);
            }
            List<Section> sections = this.header.getAllSections();
            for (Section section : sections) {
                int sectionType;
                if (monitor.isCancelled()) {
                    return;
                }
                if (section.getSize() == 0L || (sectionType = section.getFlags() & 0xFF) != 6) continue;
                int indirectOffset = section.getReserved1();
                long count = section.getSize() / (long)this.program.getDefaultPointerSize();
                int i = 0;
                while ((long)i < count) {
                    NList nList;
                    int symbolIndex = command.getIndirectSymbols()[indirectOffset + i];
                    if (symbolIndex != Integer.MIN_VALUE && (nList = symbolTableCommand.getSymbolAt(symbolIndex)) != null) {
                        boolean isWeak = (nList.getDescription() & 0x40) != 0;
                        String fromDylib = this.getClassicOrdinalName(nList.getLibraryOrdinal());
                        long address = section.getAddress() + (long)(i * this.program.getDefaultPointerSize());
                        String sectionName = section.getSectionName();
                        String segmentName = section.getSegmentName();
                        this.perform(segmentName, sectionName, address, fromDylib, nList, isWeak, monitor);
                    }
                    ++i;
                }
            }
        }
    }
}

