/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next.sectionprovider;

import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.DWARFSectionProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class CompressedSectionProvider
implements DWARFSectionProvider {
    private final DWARFSectionProvider sp;
    private Map<String, ByteProvider> sectionNameToDecompressedSectionDataMap = new HashMap<String, ByteProvider>();

    public CompressedSectionProvider(DWARFSectionProvider sp) {
        this.sp = sp;
    }

    @Override
    public boolean hasSection(String ... sectionNames) {
        if (this.sp.hasSection(sectionNames)) {
            return true;
        }
        for (String sectionName : sectionNames) {
            if (this.sp.hasSection("z" + sectionName)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ByteProvider getSectionAsByteProvider(String sectionName) throws IOException {
        ByteProvider bp = this.sp.getSectionAsByteProvider(sectionName);
        if (bp != null) {
            return bp;
        }
        bp = this.sectionNameToDecompressedSectionDataMap.get(sectionName);
        if (bp != null) {
            return bp;
        }
        bp = this.sp.getSectionAsByteProvider("z" + sectionName);
        if (bp != null) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            byte[] tempArray = new byte[1024];
            Inflater decompressor = new Inflater();
            decompressor.setInput(bp.readBytes(0L, bp.length()));
            while (!decompressor.finished()) {
                try {
                    int result = decompressor.inflate(tempArray);
                    if (result == 0 && !decompressor.finished()) {
                        throw new IOException("Zlib decompressor returned 0 bytes to inflate");
                    }
                    stream.write(tempArray, 0, result);
                }
                catch (DataFormatException e) {
                    throw new IOException(e);
                }
            }
            ByteArrayProvider decompressedBP = new ByteArrayProvider(stream.toByteArray());
            this.sectionNameToDecompressedSectionDataMap.put(sectionName, decompressedBP);
            return decompressedBP;
        }
        return null;
    }

    @Override
    public void close() {
        this.sp.close();
        this.sectionNameToDecompressedSectionDataMap.clear();
    }
}

