/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.line;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.line.LEB128;
import ghidra.app.util.bin.format.dwarf.line.StateMachine;
import ghidra.app.util.bin.format.dwarf.line.StatementProgramPrologue;
import java.io.IOException;

public final class StatementProgramInstructions {
    public static final int DW_LNS_copy = 1;
    public static final int DW_LNS_advance_pc = 2;
    public static final int DW_LNS_advance_line = 3;
    public static final int DW_LNS_set_file = 4;
    public static final int DW_LNS_set_column = 5;
    public static final int DW_LNS_negate_statement = 6;
    public static final int DW_LNS_set_basic_block = 7;
    public static final int DW_LNS_const_add_pc = 8;
    public static final int DW_LNS_fixed_advanced_pc = 9;
    public static final int DW_LNS_set_prologue_end = 10;
    public static final int DW_LNS_set_epilog_begin = 11;
    public static final int DW_LNS_set_isa = 12;
    public static final int DW_LNE_end_sequence = 1;
    public static final int DW_LNE_set_address = 2;
    public static final int DW_LNE_define_file = 3;
    private BinaryReader reader;
    private StateMachine machine;
    private StatementProgramPrologue prologue;

    public StatementProgramInstructions(BinaryReader reader, StateMachine machine, StatementProgramPrologue prologue) {
        this.reader = reader;
        this.machine = machine;
        this.prologue = prologue;
    }

    public void dispose() {
        this.reader = null;
        this.machine = null;
        this.prologue = null;
    }

    public void execute() throws IOException {
        int opcode = this.reader.readNextByte() & 0xFF;
        if (opcode == 0) {
            this.executeExtended(opcode);
        } else if (opcode >= this.prologue.getOpcodeBase()) {
            this.executeSpecial(opcode);
        } else {
            this.executeStandard(opcode);
        }
    }

    private void executeSpecial(int specialOpcodeValue) {
        int adjustedOpcode = (specialOpcodeValue & 0xFF) - this.prologue.getOpcodeBase();
        int addressIncrement = adjustedOpcode / this.prologue.getLineRange();
        int lineIncrement = this.prologue.getLineBase() + adjustedOpcode % this.prologue.getLineRange();
        this.machine.line += (byte)(lineIncrement &= 0xFF);
        this.machine.address += (long)((addressIncrement &= 0xFF) * this.prologue.getMinimumInstructionLength());
        this.machine.isBasicBlock = false;
    }

    private void executeExtended(int opcode) throws IOException {
        LEB128 length = new LEB128(this.reader, false);
        long oldIndex = this.reader.getPointerIndex();
        byte extendedOpcode = this.reader.readNextByte();
        switch (extendedOpcode) {
            case 1: {
                this.machine.isEndSequence = true;
                this.machine.reset(this.prologue.isDefaultIsStatement());
                break;
            }
            case 2: {
                this.machine.address = this.reader.readNextInt();
                break;
            }
            case 3: {
                throw new UnsupportedOperationException();
            }
        }
        if (oldIndex + length.getValue() != this.reader.getPointerIndex()) {
            throw new IllegalStateException("Index values do not match!");
        }
    }

    private void executeStandard(int opcode) throws IOException {
        switch (opcode) {
            case 1: {
                this.machine.isBasicBlock = false;
                break;
            }
            case 2: {
                LEB128 value = new LEB128(this.reader, false);
                this.machine.address += value.getValue() * (long)this.prologue.getMinimumInstructionLength();
                break;
            }
            case 3: {
                LEB128 value = new LEB128(this.reader, false);
                this.machine.line = (int)((long)this.machine.line + value.getValue());
                break;
            }
            case 4: {
                LEB128 value = new LEB128(this.reader, false);
                this.machine.file = (int)value.getValue();
                break;
            }
            case 5: {
                LEB128 value = new LEB128(this.reader, false);
                this.machine.column = (int)value.getValue();
                break;
            }
            case 6: {
                this.machine.isStatement = !this.machine.isStatement;
                break;
            }
            case 7: {
                this.machine.isBasicBlock = true;
                break;
            }
            case 8: {
                int adjustedOpcode = 255 - this.prologue.getOpcodeBase();
                int addressIncrement = adjustedOpcode / this.prologue.getLineRange();
                this.machine.address += (long)(addressIncrement & 0xFF);
                break;
            }
            case 9: {
                short value = this.reader.readNextShort();
                this.machine.address += (long)value;
                break;
            }
        }
    }
}

