/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc;

import ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame.FrameDescriptionEntry;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable.LSDAActionTable;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable.LSDACallSiteTable;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable.LSDATable;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable.LSDATypeTable;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.mem.MemoryBlock;

public class RegionDescriptor {
    private Address lsdaAddress;
    private LSDATable lsdaTable;
    private FrameDescriptionEntry fde;
    private AddressRange ipRange = new AddressRangeImpl(Address.NO_ADDRESS, Address.NO_ADDRESS);
    private MemoryBlock ehMemory;

    public RegionDescriptor(MemoryBlock ehblock) {
        this.ehMemory = ehblock;
    }

    public MemoryBlock getEHMemoryBlock() {
        return this.ehMemory;
    }

    public void setIPRange(AddressRange range) {
        this.ipRange = range;
    }

    public AddressRange getRange() {
        return this.ipRange;
    }

    public Address getRangeStart() {
        return this.ipRange.getMinAddress();
    }

    public long getRangeSize() {
        return this.ipRange.getLength();
    }

    public void setLSDAAddress(Address addr) {
        this.lsdaAddress = addr;
    }

    public Address getLSDAAddress(Address addr) {
        return this.lsdaAddress;
    }

    public void setLSDATable(LSDATable lsdaTable) {
        this.lsdaTable = lsdaTable;
    }

    public LSDATable getLSDATable() {
        return this.lsdaTable;
    }

    public LSDACallSiteTable getCallSiteTable() {
        LSDATable lsda = this.getLSDATable();
        if (lsda == null) {
            return null;
        }
        return lsda.getCallSiteTable();
    }

    public LSDAActionTable getActionTable() {
        LSDATable lsda = this.getLSDATable();
        if (lsda == null) {
            return null;
        }
        return lsda.getActionTable();
    }

    public LSDATypeTable getTypeTable() {
        LSDATable lsda = this.getLSDATable();
        if (lsda == null) {
            return null;
        }
        return lsda.getTypeTable();
    }

    public void setFrameDescriptorEntry(FrameDescriptionEntry frameDescriptionEntry) {
        this.fde = frameDescriptionEntry;
    }

    public FrameDescriptionEntry getFrameDescriptorEntry() {
        return this.fde;
    }
}

