/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.select.flow;

import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.nav.NavigationUtils;
import ghidra.app.plugin.core.select.flow.SelectByFlowAction;
import ghidra.app.services.BlockModelService;
import ghidra.app.services.ProgramManager;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.FollowFlow;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramChangeSet;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.util.ArrayList;
import java.util.Iterator;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Select By Flow", description="This plugin makes a selection in the Code Browser by following the execution flow from the current cursor location. Options can be set to control what types of execution should be followed, e.g., follow computed calls, computed jumps.", servicesRequired={ProgramManager.class, BlockModelService.class}, eventsProduced={ProgramSelectionPluginEvent.class})
public class SelectByFlowPlugin
extends Plugin
implements OptionsChangeListener {
    private DockingAction selectAllFlowsFromAction;
    private DockingAction selectLimitedFlowsFromAction;
    private DockingAction selectSubroutineAction;
    private DockingAction selectDeadSubroutineAction;
    private DockingAction selectFunctionAction;
    private DockingAction selectProgramChangesAction;
    private DockingAction selectAllFlowsToAction;
    private DockingAction selectLimitedFlowsToAction;
    public static int SELECT_ALL_FLOWS_FROM = 0;
    public static int SELECT_LIMITED_FLOWS_FROM = 1;
    public static int SELECT_SUBROUTINES = 2;
    public static int SELECT_FUNCTIONS = 3;
    public static int SELECT_DEAD_SUBROUTINES = 4;
    public static int SELECT_ALL_FLOWS_TO = 5;
    public static int SELECT_LIMITED_FLOWS_TO = 6;
    private static final String[] selectionTypes = new String[]{"Select All Flows From", "Select Limited Flows From", "Select Subroutine", "Select Function", "Select Dead Subroutines", "Select All Flows To", "Select Limited Flows To"};
    private boolean followComputedCall = false;
    private boolean followConditionalCall = false;
    private boolean followUnconditionalCall = false;
    private boolean followComputedJump = false;
    private boolean followConditionalJump = true;
    private boolean followUnconditionalJump = true;
    private boolean followPointers = false;
    private BlockModelService blockModelService;

    public SelectByFlowPlugin(PluginTool tool) {
        super(tool);
        this.setupActions();
        this.initializeOptions();
    }

    private void initializeOptions() {
        ToolOptions options = this.tool.getOptions("Selection by Flow");
        HelpLocation help = new HelpLocation("Selection", "SelectByFlowOptions");
        options.setOptionsHelpLocation(help);
        options.registerOption("Follow computed call", (Object)false, help, "When a computed call is encountered, determines whether to go to the call's destination and select by flow there too.");
        options.registerOption("Follow conditional call", (Object)false, help, "When a conditional call is encountered, determines whether to go to the call's destination and select by flow there too.");
        options.registerOption("Follow unconditional call", (Object)false, help, "When an unconditional call is encountered, determines whether to go to the call's destination and select by flow there too.");
        options.registerOption("Follow computed jump", (Object)false, help, "When a computed jump is encountered, determines whether to go to the jump's destination and select by flow there too.");
        options.registerOption("Follow conditional jump", (Object)true, help, "When a conditional jump is encountered, determines whether to go to the jump's destination and select by flow there too.");
        options.registerOption("Follow unconditional jump", (Object)true, help, "When an unconditional jump is encountered, determines whether to go to the jump's destination and select by flow there too.");
        options.registerOption("Follow pointers", (Object)false, help, "When a pointer is encountered, determines whether to go to the address being pointed to and select by flow there too.");
        this.setOptions((Options)options);
        options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    protected void init() {
        this.blockModelService = (BlockModelService)this.tool.getService(BlockModelService.class);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        this.setOptions((Options)options);
    }

    private void setOptions(Options options) {
        this.followComputedCall = options.getBoolean("Follow computed call", false);
        this.followConditionalCall = options.getBoolean("Follow conditional call", false);
        this.followUnconditionalCall = options.getBoolean("Follow unconditional call", false);
        this.followComputedJump = options.getBoolean("Follow computed jump", false);
        this.followConditionalJump = options.getBoolean("Follow conditional jump", true);
        this.followUnconditionalJump = options.getBoolean("Follow unconditional jump", true);
        this.followPointers = options.getBoolean("Follow pointers", false);
    }

    void select(NavigatableActionContext context, int selectionType) {
        try {
            SelectByFlowTask task = new SelectByFlowTask(context, selectionType);
            this.tool.execute((Task)task, 750);
        }
        catch (InvalidInputException e) {
            this.tool.setStatusInfo(e.getMessage(), true);
        }
    }

    void performSelection(TaskMonitor monitor, NavigatableActionContext context, int selectionType, AddressSet addressSet) {
        FlowType[] doNotFollowTypes;
        Program program = context.getProgram();
        AddressSet selectionAddressSet = null;
        if (monitor == null) {
            monitor = TaskMonitorAdapter.DUMMY_MONITOR;
        }
        monitor.setMessage("Computing Selection...");
        if (selectionType == SELECT_FUNCTIONS) {
            selectionAddressSet = this.selectFunctions(monitor, program, addressSet);
        } else if (selectionType == SELECT_SUBROUTINES) {
            try {
                selectionAddressSet = this.selectSubroutines(monitor, program, addressSet);
            }
            catch (CancelledException e) {
                return;
            }
        } else if (selectionType == SELECT_DEAD_SUBROUTINES) {
            try {
                selectionAddressSet = this.selectDeadSubroutines(monitor, program, addressSet);
            }
            catch (CancelledException e) {
                return;
            }
        } else if (selectionType == SELECT_LIMITED_FLOWS_TO || selectionType == SELECT_ALL_FLOWS_TO) {
            doNotFollowTypes = null;
            if (selectionType == SELECT_LIMITED_FLOWS_TO) {
                doNotFollowTypes = this.getFlowTypesNotToFollow();
            }
            FollowFlow codeFlow = new FollowFlow(program, addressSet, doNotFollowTypes);
            selectionAddressSet = codeFlow.getFlowToAddressSet(monitor);
        } else {
            doNotFollowTypes = null;
            if (selectionType == SELECT_LIMITED_FLOWS_FROM) {
                doNotFollowTypes = this.getFlowTypesNotToFollow();
            }
            FollowFlow codeFlow = new FollowFlow(program, addressSet, doNotFollowTypes);
            selectionAddressSet = codeFlow.getFlowAddressSet(monitor);
        }
        if (monitor.isCancelled()) {
            return;
        }
        ProgramSelection selection = new ProgramSelection((AddressSetView)selectionAddressSet);
        NavigationUtils.setSelection(this.tool, context.getNavigatable(), selection);
    }

    public FlowType[] getFlowTypesNotToFollow() {
        ArrayList<FlowType> notFollowed = new ArrayList<FlowType>(6);
        if (!this.followComputedCall) {
            notFollowed.add(RefType.COMPUTED_CALL);
        }
        if (!this.followConditionalCall) {
            notFollowed.add(RefType.CONDITIONAL_CALL);
        }
        if (!this.followUnconditionalCall) {
            notFollowed.add(RefType.UNCONDITIONAL_CALL);
        }
        if (!this.followComputedJump) {
            notFollowed.add(RefType.COMPUTED_JUMP);
        }
        if (!this.followConditionalJump) {
            notFollowed.add(RefType.CONDITIONAL_JUMP);
        }
        if (!this.followUnconditionalJump) {
            notFollowed.add(RefType.UNCONDITIONAL_JUMP);
        }
        if (!this.followPointers) {
            notFollowed.add(RefType.INDIRECTION);
        }
        return notFollowed.toArray(new FlowType[notFollowed.size()]);
    }

    private AddressSet selectSubroutines(TaskMonitor monitor, Program program, AddressSet startAddresses) throws CancelledException {
        AddressSet newAddressSet = new AddressSet();
        if (startAddresses == null || startAddresses.getNumAddresses() <= 0L) {
            return newAddressSet;
        }
        monitor.initialize(startAddresses.getNumAddresses());
        CodeBlockModel cbm = this.blockModelService.getActiveSubroutineModel();
        CodeBlockIterator iter = cbm.getCodeBlocksContaining((AddressSetView)startAddresses, monitor);
        while (iter.hasNext()) {
            if (monitor.isCancelled()) {
                return newAddressSet;
            }
            CodeBlock block = iter.next();
            newAddressSet.add((AddressSetView)block);
            monitor.incrementProgress(block.getNumAddresses());
        }
        return newAddressSet;
    }

    private AddressSet selectDeadSubroutines(TaskMonitor monitor, Program program, AddressSet startAddresses) throws CancelledException {
        AddressSet newAddressSet = new AddressSet();
        if (startAddresses == null || startAddresses.getNumAddresses() <= 0L) {
            return newAddressSet;
        }
        monitor.initialize(startAddresses.getNumAddresses());
        ReferenceManager rm = program.getReferenceManager();
        CodeBlockModel cbm = this.blockModelService.getActiveSubroutineModel();
        CodeBlockIterator cbIter = cbm.getCodeBlocksContaining((AddressSetView)startAddresses, monitor);
        while (cbIter.hasNext()) {
            if (monitor.isCancelled()) {
                return newAddressSet;
            }
            CodeBlock block = cbIter.next();
            monitor.setMessage(block.getName());
            if (!this.blockHasReferences(rm, block)) {
                newAddressSet.add((AddressSetView)block);
            }
            monitor.incrementProgress(block.getNumAddresses());
        }
        return newAddressSet;
    }

    private boolean blockHasReferences(ReferenceManager referenceManager, CodeBlock block) {
        Address[] starts = block.getStartAddresses();
        for (int i = 0; i < starts.length; ++i) {
            ReferenceIterator refIter = referenceManager.getReferencesTo(starts[i]);
            while (refIter.hasNext()) {
                Reference ref = refIter.next();
                if (!ref.isMemoryReference()) continue;
                return true;
            }
        }
        return false;
    }

    private AddressSet selectFunctions(TaskMonitor monitor, Program program, AddressSet startAddresses) {
        AddressSet newAddressSet = new AddressSet();
        if (startAddresses == null || startAddresses.getNumAddresses() <= 0L) {
            return newAddressSet;
        }
        monitor.initialize(startAddresses.getNumAddresses());
        FunctionManager functionManager = program.getFunctionManager();
        Iterator iter = functionManager.getFunctionsOverlapping((AddressSetView)startAddresses);
        while (iter.hasNext()) {
            if (monitor.isCancelled()) {
                return newAddressSet;
            }
            Function f = (Function)iter.next();
            AddressSetView body = f.getBody();
            newAddressSet.add(body);
            monitor.incrementProgress(body.getNumAddresses());
        }
        return newAddressSet;
    }

    private void selectChangeSet(NavigatableActionContext context) {
        ProgramChangeSet cs;
        ProgramChangeSet pcs = cs = context.getProgram().getChanges();
        ProgramSelection selection = new ProgramSelection(pcs.getAddressSet());
        NavigationUtils.setSelection(this.tool, context.getNavigatable(), selection);
    }

    private void setupActions() {
        int subMenuGroupPosition = 1;
        this.selectProgramChangesAction = new NavigatableContextAction("Select Program Changes", this.getName()){

            @Override
            public void actionPerformed(NavigatableActionContext context) {
                SelectByFlowPlugin.this.selectChangeSet(context);
            }

            @Override
            protected boolean isEnabledForContext(NavigatableActionContext context) {
                Program program = context.getProgram();
                ProgramChangeSet cs = program.getChanges();
                return cs != null && cs.hasChanges();
            }
        };
        this.selectProgramChangesAction.setMenuBarData(new MenuData(new String[]{"Select", "Program Changes"}, null, "FlowSelection"));
        this.selectProgramChangesAction.setHelpLocation(new HelpLocation("Selection", this.selectProgramChangesAction.getName()));
        this.selectProgramChangesAction.getMenuBarData().setMenuSubGroup(Integer.toString(subMenuGroupPosition++));
        this.tool.addAction((DockingActionIf)this.selectProgramChangesAction);
        this.selectAllFlowsFromAction = new SelectByFlowAction("Select All Flows From", this, SELECT_ALL_FLOWS_FROM);
        this.selectAllFlowsFromAction.getMenuBarData().setMenuSubGroup(Integer.toString(subMenuGroupPosition++));
        this.tool.addAction((DockingActionIf)this.selectAllFlowsFromAction);
        this.selectAllFlowsToAction = new SelectByFlowAction("Select All Flows To", this, SELECT_ALL_FLOWS_TO);
        this.selectAllFlowsToAction.getMenuBarData().setMenuSubGroup(Integer.toString(subMenuGroupPosition++));
        this.tool.addAction((DockingActionIf)this.selectAllFlowsToAction);
        this.selectLimitedFlowsFromAction = new SelectByFlowAction("Select Limited Flows From", this, SELECT_LIMITED_FLOWS_FROM);
        this.selectLimitedFlowsFromAction.getMenuBarData().setMenuSubGroup(Integer.toString(subMenuGroupPosition++));
        this.tool.addAction((DockingActionIf)this.selectLimitedFlowsFromAction);
        this.selectLimitedFlowsToAction = new SelectByFlowAction("Select Limited Flows To", this, SELECT_LIMITED_FLOWS_TO);
        this.selectLimitedFlowsToAction.getMenuBarData().setMenuSubGroup(Integer.toString(subMenuGroupPosition++));
        this.tool.addAction((DockingActionIf)this.selectLimitedFlowsToAction);
        this.selectSubroutineAction = new SelectByFlowAction("Select Subroutine", this, SELECT_SUBROUTINES);
        this.selectSubroutineAction.getMenuBarData().setMenuSubGroup(Integer.toString(subMenuGroupPosition++));
        this.tool.addAction((DockingActionIf)this.selectSubroutineAction);
        this.selectDeadSubroutineAction = new SelectByFlowAction("Select Dead Subroutine", this, SELECT_DEAD_SUBROUTINES);
        this.selectDeadSubroutineAction.getMenuBarData().setMenuSubGroup(Integer.toString(subMenuGroupPosition++));
        this.tool.addAction((DockingActionIf)this.selectDeadSubroutineAction);
        this.selectFunctionAction = new SelectByFlowAction("Select Function", this, SELECT_FUNCTIONS);
        this.selectFunctionAction.getMenuBarData().setMenuSubGroup(Integer.toString(subMenuGroupPosition++));
        this.tool.addAction((DockingActionIf)this.selectFunctionAction);
    }

    public class SelectByFlowTask
    extends Task {
        int selectionType;
        AddressSet addressSet;
        private final NavigatableActionContext context;

        SelectByFlowTask(NavigatableActionContext context, int selectionType) throws InvalidInputException {
            super(selectionTypes[selectionType], true, true, true);
            this.context = context;
            Program program = context.getProgram();
            this.selectionType = selectionType;
            this.addressSet = new AddressSet((AddressSetView)context.getSelection());
            if (this.addressSet.isEmpty()) {
                if (selectionType == SELECT_DEAD_SUBROUTINES) {
                    this.addressSet.add((AddressSetView)program.getMemory());
                } else {
                    Address location = context.getAddress();
                    if (location != null) {
                        this.addressSet.addRange(location, location);
                    } else {
                        throw new InvalidInputException("Can not determine current location");
                    }
                }
            }
        }

        public void run(TaskMonitor monitor) {
            SelectByFlowPlugin.this.performSelection(monitor, this.context, this.selectionType, this.addressSet);
        }
    }
}

