/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.cmd.refs.RemoveExternalNameCmd;
import ghidra.app.plugin.core.references.ExternalReferencesProvider;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.util.Msg;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class DeleteExternalReferenceNameAction
extends DockingAction {
    private static ImageIcon DELETE_ICON = ResourceManager.loadImage((String)"images/edit-delete.png");
    private final ExternalReferencesProvider provider;

    public DeleteExternalReferenceNameAction(ExternalReferencesProvider provider) {
        super("Delete External Program Name", provider.getOwner());
        this.provider = provider;
        this.setPopupMenuData(new MenuData(new String[]{"Delete External Program"}, (Icon)DELETE_ICON, null));
        this.setToolBarData(new ToolBarData((Icon)DELETE_ICON, null));
        this.setEnabled(true);
    }

    public boolean isAddToPopup(ActionContext context) {
        return true;
    }

    public void actionPerformed(ActionContext context) {
        Program program = this.provider.getProgram();
        ExternalManager externalManager = program.getExternalManager();
        List<String> externalNames = this.provider.getSelectedExternalNames();
        StringBuffer buf = new StringBuffer();
        CompoundCmd cmd = new CompoundCmd("Delete External Program Name");
        for (String externalName : externalNames) {
            boolean hasLocations = externalManager.getExternalLocations(externalName).hasNext();
            if (hasLocations) {
                buf.append("\n     ");
                buf.append(externalName);
                continue;
            }
            cmd.add((Command)new RemoveExternalNameCmd(externalName));
        }
        if (cmd.size() > 0) {
            this.provider.getTool().execute((Command)cmd, (DomainObject)program);
        }
        if (buf.length() > 0) {
            Msg.showError(((Object)((Object)this)).getClass(), (Component)this.provider.getComponent(), (String)"Delete Failure", (Object)("The following external reference names could not be deleted\nbecause they contain external locations:\n" + buf.toString()));
        }
    }
}

