/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import docking.widgets.fieldpanel.support.Highlight;
import ghidra.app.plugin.core.navigation.locationreferences.GenericCompositeDataTypeProgramLocation;
import ghidra.app.plugin.core.navigation.locationreferences.GenericDataTypeLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReference;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.FieldNameFieldFactory;
import ghidra.app.util.viewer.field.LabelFieldFactory;
import ghidra.app.util.viewer.field.MnemonicFieldFactory;
import ghidra.app.util.viewer.field.OperandFieldFactory;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import org.apache.commons.lang3.StringUtils;

public class GenericCompositeDataTypeLocationDescriptor
extends GenericDataTypeLocationDescriptor {
    private String typeAndFieldName;
    private String fieldName;

    public GenericCompositeDataTypeLocationDescriptor(GenericCompositeDataTypeProgramLocation location, Program program) {
        super(location, program, location.getDataType());
        this.fieldName = location.getFieldName();
        this.typeAndFieldName = this.getDataTypeName() + "." + this.fieldName;
        this.label = this.generateLabel();
    }

    @Override
    protected void doGetReferences(Accumulator<LocationReference> accumulator, TaskMonitor monitor) throws CancelledException {
        Composite currentDataType = (Composite)this.getDataType();
        ReferenceUtils.findDataTypeReferences(accumulator, (DataType)currentDataType, this.fieldName, this.program, this.useDynamicSearching, monitor);
    }

    @Override
    public String getTypeName() {
        return super.getTypeName() + "." + this.fieldName;
    }

    @Override
    protected String generateLabel() {
        return "\"" + this.originalDataType.getName() + "." + this.fieldName + "\" (DataType)";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericCompositeDataTypeLocationDescriptor)) {
            return false;
        }
        GenericCompositeDataTypeLocationDescriptor otherDescriptor = (GenericCompositeDataTypeLocationDescriptor)obj;
        return this.getDataType().equals(otherDescriptor.getDataType()) && this.fieldName.equals(otherDescriptor.fieldName);
    }

    @Override
    Highlight[] getHighlights(String text, Object object, Class<? extends FieldFactory> fieldFactoryClass, Color highlightColor) {
        Address currentAddress = this.getAddressForHighlightObject(object);
        if (!this.isInAddresses(currentAddress)) {
            return this.EMPTY_HIGHLIGHTS;
        }
        if (!(MnemonicFieldFactory.class.isAssignableFrom(fieldFactoryClass) && object instanceof Data || LabelFieldFactory.class.isAssignableFrom(fieldFactoryClass))) {
            if (OperandFieldFactory.class.isAssignableFrom(fieldFactoryClass)) {
                int offset = StringUtils.indexOfIgnoreCase((CharSequence)text, (CharSequence)this.typeAndFieldName, (int)0);
                if (offset != -1) {
                    return new Highlight[]{new Highlight(offset, offset + this.typeAndFieldName.length() - 1, highlightColor)};
                }
            } else if (FieldNameFieldFactory.class.isAssignableFrom(fieldFactoryClass)) {
                if (text.equalsIgnoreCase(this.fieldName)) {
                    return new Highlight[]{new Highlight(0, text.length(), highlightColor)};
                }
                String typeName = this.getDataTypeName();
                if (text.equalsIgnoreCase(typeName)) {
                    return new Highlight[]{new Highlight(0, text.length(), highlightColor)};
                }
            }
        }
        return this.EMPTY_HIGHLIGHTS;
    }
}

