/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.navigation.AbstractNextPreviousAction;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import resources.ResourceManager;

public class NextPreviousFunctionAction
extends AbstractNextPreviousAction {
    public NextPreviousFunctionAction(PluginTool tool, String owner, String subGroup) {
        super(tool, "Next Function", owner, subGroup);
    }

    @Override
    protected Icon getIcon() {
        return ResourceManager.loadImage((String)"images/F.gif");
    }

    @Override
    protected KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(70, 640);
    }

    @Override
    protected String getNavigationTypeName() {
        return "Function";
    }

    @Override
    protected Address getNextAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        Function nextFunction = this.getNextFunction(program, address, true);
        return nextFunction == null ? null : nextFunction.getEntryPoint();
    }

    @Override
    protected Address getPreviousAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        Function function = program.getListing().getFunctionContaining(address);
        if (this.isInsideFunctionNotAtEntry(function, address)) {
            return function.getEntryPoint();
        }
        Function nextFunction = this.getNextFunction(program, address, false);
        return nextFunction == null ? null : nextFunction.getEntryPoint();
    }

    private boolean isInsideFunctionNotAtEntry(Function function, Address address) {
        if (function == null) {
            return false;
        }
        return !address.equals((Object)function.getEntryPoint());
    }

    private Function getNextFunction(Program program, Address address, boolean forward) {
        FunctionIterator functionIterator = program.getListing().getFunctions(address, forward);
        if (!functionIterator.hasNext()) {
            return null;
        }
        Function nextFunction = (Function)functionIterator.next();
        if (!nextFunction.getEntryPoint().equals((Object)address)) {
            return nextFunction;
        }
        if (!functionIterator.hasNext()) {
            return null;
        }
        return (Function)functionIterator.next();
    }

    @Override
    protected void gotoAddress(GoToService service, Navigatable navigatable, Address address) {
        Program program = navigatable.getProgram();
        Function function = program.getListing().getFunctionAt(address);
        FunctionSignatureFieldLocation location = new FunctionSignatureFieldLocation(program, address, null, 0, function.getPrototypeString(false, false));
        service.goTo(navigatable, (ProgramLocation)location, navigatable.getProgram());
    }
}

