/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functionwindow;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.functionwindow.FunctionRowObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.util.LongIterator;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.table.field.FunctionBodySizeTableColumn;
import ghidra.util.table.field.FunctionSignatureTableColumn;
import ghidra.util.table.field.FunctionTagTableColumn;
import ghidra.util.table.field.LabelTableColumn;
import ghidra.util.task.TaskMonitor;

class FunctionTableModel
extends AddressBasedTableModel<FunctionRowObject> {
    static final int LOCATION_COL_WIDTH = 50;
    static final int NAME_COL = 0;
    static final int LOCATION_COL = 1;
    static final int PROTOTYPE_COL = 2;
    private FunctionManager functionMgr;

    FunctionTableModel(PluginTool tool, Program program) {
        super("Functions", (ServiceProvider)tool, program, null);
    }

    @Override
    protected TableColumnDescriptor<FunctionRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new LabelTableColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()), 1, true);
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new FunctionSignatureTableColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new FunctionBodySizeTableColumn()));
        descriptor.addHiddenColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new FunctionTagTableColumn()));
        return descriptor;
    }

    void reload(Program newProgram) {
        this.setProgram(newProgram);
        this.functionMgr = newProgram != null ? newProgram.getFunctionManager() : null;
        this.reload();
    }

    public int getKeyCount() {
        if (this.functionMgr == null) {
            return 0;
        }
        return this.functionMgr.getFunctionCount();
    }

    protected void doLoad(Accumulator<FunctionRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        LongIterator it = LongIterator.EMPTY;
        if (this.functionMgr != null) {
            it = new FunctionKeyIterator(this.functionMgr);
        }
        monitor.initialize((long)this.getKeyCount());
        int progress = 0;
        while (it.hasNext()) {
            monitor.setProgress((long)progress++);
            monitor.checkCanceled();
            long key = it.next();
            accumulator.add((Object)new FunctionRowObject(key));
        }
    }

    void functionAdded(Function function) {
        this.addObject(new FunctionRowObject(function.getID()));
    }

    void functionRemoved(Function function) {
        this.removeObject(new FunctionRowObject(function.getID()));
    }

    void update(Function function) {
        this.updateObject(new FunctionRowObject(function.getID()));
    }

    @Override
    public Address getAddress(int row) {
        FunctionRowObject rowObject = (FunctionRowObject)this.getRowObject(row);
        FunctionManager functionManager = this.program.getFunctionManager();
        Function function = functionManager.getFunction(rowObject.getKey());
        return function != null ? function.getEntryPoint() : null;
    }

    private class FunctionKeyIterator
    implements LongIterator {
        private FunctionIterator itr;

        FunctionKeyIterator(FunctionManager functionMgr) {
            this.itr = functionMgr.getFunctions(true);
        }

        public boolean hasNext() {
            if (this.itr == null) {
                return false;
            }
            return this.itr.hasNext();
        }

        public long next() {
            Function function = (Function)this.itr.next();
            return function.getID();
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        public long previous() {
            throw new UnsupportedOperationException();
        }
    }
}

