/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare;

import docking.action.DockingActionIf;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.functioncompare.CompareFunctionsAction;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonProviderManager;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Difference", shortDescription="Compare Functions", description="This plugin provides actions that allow you to compare two or more functions with each other.", eventsConsumed={ProgramClosedPluginEvent.class})
public class FunctionComparisonPlugin
extends ProgramPlugin
implements DomainObjectListener {
    public static final String FUNCTION_MENU_SUBGROUP = "Function";
    static final String MENU_PULLRIGHT = "CompareFunctions";
    static final String POPUP_MENU_GROUP = "CompareFunction";
    private FunctionComparisonProviderManager functionComparisonManager = new FunctionComparisonProviderManager(this);

    public FunctionComparisonPlugin(PluginTool tool) {
        super(tool, true, true);
        tool.setMenuGroup(new String[]{MENU_PULLRIGHT}, POPUP_MENU_GROUP);
    }

    protected void init() {
        this.createActions();
    }

    private void createActions() {
        this.tool.addAction((DockingActionIf)new CompareFunctionsAction(this));
    }

    public void dispose() {
        this.functionComparisonManager.dispose();
    }

    @Override
    protected void programOpened(Program program) {
        program.addListener((DomainObjectListener)this);
    }

    @Override
    protected void programClosed(Program program) {
        this.functionComparisonManager.closeProviders(program);
        program.removeListener((DomainObjectListener)this);
    }

    void showFunctionComparisonProvider(Function[] functions) {
        this.functionComparisonManager.showFunctionComparisonProvider(functions);
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.containsEvent(4)) {
            this.functionComparisonManager.domainObjectRestored(ev);
        }
    }
}

