/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datapreview;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.dnd.DropTgtAdapter;
import docking.dnd.Droppable;
import docking.widgets.table.AbstractSortedTableModel;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.datapreview.DataTypeComponentPreview;
import ghidra.app.plugin.core.datapreview.DataTypePreview;
import ghidra.app.plugin.core.datapreview.Preview;
import ghidra.app.services.GoToService;
import ghidra.app.services.QueryData;
import ghidra.app.util.datatype.DataTypeSelectionDialog;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.DataTypeTransferable;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.FactoryStructureDataType;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.StandAloneDataTypeManager;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.data.TerminatedUnicodeDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.util.BytesFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.data.DataTypeParser;
import ghidra.util.table.GhidraTable;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import resources.ResourceManager;
import util.CollectionUtils;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Data Type Preview Plugin", description="This plugin provides a preview of bytes at an address based on data types that you choose to view.")
public class DataTypePreviewPlugin
extends ProgramPlugin {
    private DTPPComponentProvider provider;
    private DTPPTableModel model;
    private DTPPTable table;
    private DTPPScrollPane component;
    private Address currentAddress;
    private GoToService goToService;
    private DockingAction addAction;
    private DockingAction deleteAction;
    private LayeredDataTypeManager dataTypeManager;
    private Program activeProgram;
    private SwingUpdateManager updateManager = new SwingUpdateManager(650, () -> this.updatePreview());

    public DataTypePreviewPlugin(PluginTool tool) {
        super(tool, true, true);
    }

    DTPPTableModel getTableModel() {
        return this.model;
    }

    GoToService getGoToService() {
        return this.goToService;
    }

    DTPPComponentProvider getProvider() {
        return this.provider;
    }

    protected void init() {
        super.init();
        this.goToService = (GoToService)this.tool.getService(GoToService.class);
        this.model = new DTPPTableModel();
        this.table = new DTPPTable(this.model);
        this.component = new DTPPScrollPane((Component)((Object)this.table));
        this.dataTypeManager = new LayeredDataTypeManager();
        this.addDataType((DataType)new ByteDataType());
        this.addDataType((DataType)new WordDataType());
        this.addDataType((DataType)new DWordDataType());
        this.addDataType((DataType)new QWordDataType());
        this.addDataType((DataType)new FloatDataType());
        this.addDataType((DataType)new DoubleDataType());
        this.addDataType((DataType)new CharDataType());
        this.addDataType((DataType)new TerminatedStringDataType());
        this.addDataType((DataType)new TerminatedUnicodeDataType());
        this.provider = new DTPPComponentProvider();
        this.tool.addComponentProvider((ComponentProvider)this.provider, false);
        this.createActions();
    }

    public void serviceRemoved(Class<?> interfaceClass, Object service) {
        if (interfaceClass == GoToService.class) {
            this.goToService = null;
        }
    }

    public void serviceAdded(Class<?> interfaceClass, Object service) {
        if (interfaceClass == GoToService.class) {
            this.goToService = (GoToService)service;
        }
    }

    protected void dispose() {
        this.updateManager.dispose();
        this.deleteAction.dispose();
        if (this.provider != null) {
            this.tool.removeComponentProvider((ComponentProvider)this.provider);
            this.provider = null;
        }
        this.updateManager.dispose();
        this.updateManager = null;
        this.table.dispose();
        super.dispose();
    }

    @Override
    protected void programActivated(Program program) {
        super.programActivated(program);
        this.activeProgram = program;
        this.updateModel();
    }

    private List<DataTypePath> getModelDataTypePaths() {
        ArrayList<DataTypePath> list = new ArrayList<DataTypePath>();
        for (Preview preview : this.model.getModelData()) {
            DataTypeComponentPreview componentPreview;
            if (preview instanceof DataTypePreview) {
                list.add(preview.getDataType().getDataTypePath());
                continue;
            }
            if (!(preview instanceof DataTypeComponentPreview) || (componentPreview = (DataTypeComponentPreview)preview).getParent() != null) continue;
            list.add(preview.getDataType().getDataTypePath());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateModel() {
        List<DataTypePath> dtPaths = this.getModelDataTypePaths();
        this.model.removeAll();
        this.dataTypeManager.invalidate();
        int transactionId = this.dataTypeManager.startTransaction("realign");
        try {
            Iterator allComposites = this.dataTypeManager.getAllComposites();
            while (allComposites.hasNext()) {
                Composite composite = (Composite)allComposites.next();
                if (!composite.isInternallyAligned()) continue;
                composite.realign();
            }
        }
        finally {
            this.dataTypeManager.endTransaction(transactionId, true);
        }
        for (DataTypePath dtPath : dtPaths) {
            DataType dataType = this.dataTypeManager.getDataType(dtPath);
            if (dataType == null) continue;
            this.model.add(dataType);
        }
    }

    @Override
    protected void programDeactivated(Program program) {
        super.programDeactivated(program);
        this.activeProgram = null;
    }

    @Override
    protected void locationChanged(ProgramLocation loc) {
        super.locationChanged(loc);
        if (loc == null) {
            return;
        }
        this.currentAddress = loc instanceof BytesFieldLocation ? ((BytesFieldLocation)loc).getAddressForByte() : loc.getByteAddress();
        this.updateManager.update();
    }

    private void updatePreview() {
        if (this.currentAddress == null) {
            return;
        }
        if (this.provider.isVisible()) {
            this.model.fireTableDataChanged();
            this.updateTitle();
        }
    }

    private void updateTitle() {
        if (this.currentAddress != null) {
            this.provider.setSubTitle(" at " + this.currentAddress);
        } else {
            this.provider.setSubTitle(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfigState(SaveState saveState) {
        Object[] names = saveState.getNames();
        if (CollectionUtils.isBlank((Object[])names)) {
            return;
        }
        try (BuiltInDataTypeManager builtInMgr = BuiltInDataTypeManager.getDataTypeManager();){
            for (Object element : names) {
                String path = saveState.getString((String)element, null);
                if (path == null) continue;
                DataType dt = builtInMgr.getDataType(new CategoryPath(path), (String)element);
                this.addDataType(dt);
            }
        }
    }

    public void writeConfigState(SaveState saveState) {
        Iterator<Preview> iter = this.model.iterator();
        while (iter.hasNext()) {
            Preview preview = iter.next();
            DataType dt = preview.getDataType();
            saveState.putString(dt.getName(), dt.getCategoryPath().getPath());
        }
    }

    private void setActionEnabled(boolean enabled) {
        this.deleteAction.setEnabled(enabled);
    }

    private void createActions() {
        this.addAction = new DockingAction("Add", this.getName()){

            public void actionPerformed(ActionContext context) {
                DataTypePreviewPlugin.this.add();
            }
        };
        this.addAction.setPopupMenuData(new MenuData(new String[]{"Add"}));
        this.addAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/Plus.png")));
        this.addAction.setKeyBindingData(new KeyBindingData(521, 0));
        this.addAction.setDescription("Add Datatypes");
        this.addAction.setEnabled(true);
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.addAction);
        this.deleteAction = new DockingAction("Delete", this.getName()){

            public void actionPerformed(ActionContext context) {
                DataTypePreviewPlugin.this.delete();
            }
        };
        this.deleteAction.setPopupMenuData(new MenuData(new String[]{"Delete"}));
        this.deleteAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/edit-delete.png")));
        this.deleteAction.setKeyBindingData(new KeyBindingData(127, 0));
        this.deleteAction.setDescription("Delete Selected Datatypes");
        this.deleteAction.setEnabled(false);
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.deleteAction);
    }

    private void add() {
        DataTypeManager dtm = null;
        if (this.activeProgram != null) {
            dtm = this.activeProgram.getDataTypeManager();
        }
        DataTypeSelectionDialog d = new DataTypeSelectionDialog(this.tool, dtm, Integer.MAX_VALUE, DataTypeParser.AllowedDataTypes.STRINGS_AND_FIXED_LENGTH);
        this.tool.showDialog((DialogComponentProvider)d, (ComponentProvider)this.provider);
        DataType dt = d.getUserChosenDataType();
        this.addDataType(dt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDataType(DataType dt) {
        if (dt == null || this.model.contains(dt)) {
            return;
        }
        int transactionID = this.dataTypeManager.startTransaction("Add dataType");
        try {
            DataType resolvedDt = this.dataTypeManager.resolve(dt, null);
            this.model.add(resolvedDt);
        }
        finally {
            this.dataTypeManager.endTransaction(transactionID, true);
        }
    }

    private void removeDataType(DataType dt) {
        int transactionID = this.dataTypeManager.startTransaction("Remove dataType");
        try {
            this.model.removeAll(dt);
        }
        finally {
            this.dataTypeManager.endTransaction(transactionID, true);
        }
    }

    private void delete() {
        Preview[] previews;
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        for (Preview element : previews = this.model.getPreviews(rows)) {
            this.removeDataType(element.getDataType());
        }
        if (this.model.getRowCount() > 0) {
            if (this.model.getRowCount() > rows[0]) {
                this.table.setRowSelectionInterval(rows[0], rows[0]);
            } else {
                this.table.setRowSelectionInterval(this.model.getRowCount() - 1, this.model.getRowCount() - 1);
            }
        }
        this.setActionEnabled(this.model.getRowCount() > 0);
    }

    private class LayeredDataTypeManager
    extends StandAloneDataTypeManager {
        public LayeredDataTypeManager() {
            super("DataTypePreviewer");
        }

        public DataOrganization getDataOrganization() {
            if (DataTypePreviewPlugin.this.currentProgram != null) {
                return DataTypePreviewPlugin.this.currentProgram.getDataTypeManager().getDataOrganization();
            }
            return super.getDataOrganization();
        }

        void invalidate() {
            this.invalidateCache();
        }
    }

    class DTPPTableModel
    extends AbstractSortedTableModel<Preview> {
        static final int NAME_COL = 0;
        static final int PREVIEW_COL = 1;
        private List<Preview> data = new ArrayList<Preview>();

        DTPPTableModel() {
        }

        String getPreviewAt(int row) {
            if (DataTypePreviewPlugin.this.currentProgram == null) {
                return null;
            }
            Preview p = this.data.get(row);
            return p.getPreview(DataTypePreviewPlugin.this.currentProgram.getMemory(), DataTypePreviewPlugin.this.currentAddress);
        }

        Preview[] getPreviews(int[] rows) {
            Preview[] previews = new Preview[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                previews[i] = this.data.get(rows[i]);
            }
            return previews;
        }

        Iterator<Preview> iterator() {
            return this.data.iterator();
        }

        void add(DataType dt) {
            if (!this.isValid(dt)) {
                return;
            }
            if (this.contains(dt)) {
                DataTypePreviewPlugin.this.tool.setStatusInfo("Datatype \"" + dt.getName() + "\" already exists.");
                return;
            }
            if (dt instanceof Composite) {
                this.add((Composite)dt, null);
            } else {
                this.data.add(new DataTypePreview(dt));
            }
            this.fireTableDataChanged();
        }

        private void add(Composite c, DataTypeComponentPreview parent) {
            DataTypeComponent[] comps;
            for (DataTypeComponent element : comps = c.getComponents()) {
                DataTypeComponentPreview preview = new DataTypeComponentPreview(c, element);
                preview.setParent(parent);
                DataType dataType = element.getDataType();
                if (dataType == DataType.DEFAULT) continue;
                if (dataType instanceof Composite) {
                    this.add((Composite)element.getDataType(), preview);
                    continue;
                }
                this.data.add(preview);
            }
        }

        void remove(int row) {
            this.data.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        void removeAll() {
            if (this.data.isEmpty()) {
                return;
            }
            this.data.clear();
            this.fireTableDataChanged();
        }

        boolean removeAll(DataType deletedDataType) {
            boolean removed = false;
            ArrayList<Preview> clone = new ArrayList<Preview>(this.data);
            for (Preview obj : clone) {
                Preview preview = obj;
                if (!preview.getDataType().equals(deletedDataType)) continue;
                this.data.remove(preview);
                removed = true;
            }
            if (removed) {
                this.fireTableDataChanged();
            }
            return removed;
        }

        private boolean isValid(DataType dt) {
            if (dt == null) {
                return false;
            }
            if (dt instanceof DynamicDataType) {
                DataTypePreviewPlugin.this.tool.setStatusInfo("Dynamic data types do not support previewing.");
                return false;
            }
            if (dt instanceof FactoryStructureDataType) {
                DataTypePreviewPlugin.this.tool.setStatusInfo("Dynamic structure data types do not support previewing.");
                return false;
            }
            if (dt instanceof FunctionDefinition || dt instanceof FunctionDefinitionDataType) {
                DataTypePreviewPlugin.this.tool.setStatusInfo("Function definition data types do not support previewing.");
                return false;
            }
            return true;
        }

        private boolean contains(DataType dt) {
            for (Preview p : this.data) {
                if (!p.getDataType().equals(dt) && !p.getDataType().isEquivalent(dt)) continue;
                return true;
            }
            return false;
        }

        public String getName() {
            return "Datatype Preview";
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "Name";
            }
            if (col == 1) {
                return "Preview";
            }
            return "<<unknown>>";
        }

        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getColumnValueForRow(Preview p, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return p.getName();
                }
                case 1: {
                    if (DataTypePreviewPlugin.this.currentProgram == null || DataTypePreviewPlugin.this.currentAddress == null) break;
                    return p.getPreview(DataTypePreviewPlugin.this.currentProgram.getMemory(), DataTypePreviewPlugin.this.currentAddress);
                }
            }
            return null;
        }

        public List<Preview> getModelData() {
            return this.data;
        }

        public boolean isSortable(int columnIndex) {
            return true;
        }

        protected Comparator<Preview> createSortComparator(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return new NamePreviewColumnComparator();
                }
                case 1: {
                    return new PreviewColumnComparator();
                }
            }
            return super.createSortComparator(columnIndex);
        }

        private class PreviewColumnComparator
        implements Comparator<Preview> {
            private PreviewColumnComparator() {
            }

            @Override
            public int compare(Preview p1, Preview p2) {
                if (DataTypePreviewPlugin.this.currentProgram == null || DataTypePreviewPlugin.this.currentAddress == null) {
                    return 0;
                }
                String preview1 = p1.getPreview(DataTypePreviewPlugin.this.currentProgram.getMemory(), DataTypePreviewPlugin.this.currentAddress);
                String preview2 = p2.getPreview(DataTypePreviewPlugin.this.currentProgram.getMemory(), DataTypePreviewPlugin.this.currentAddress);
                return preview1.compareToIgnoreCase(preview2);
            }
        }

        private class NamePreviewColumnComparator
        implements Comparator<Preview> {
            private NamePreviewColumnComparator() {
            }

            @Override
            public int compare(Preview p1, Preview p2) {
                if (DataTypePreviewPlugin.this.currentProgram == null || DataTypePreviewPlugin.this.currentAddress == null) {
                    return 0;
                }
                return p1.compareTo(p2);
            }
        }
    }

    private class DTPPMouseListener
    extends MouseAdapter {
        private DTPPMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                int row = DataTypePreviewPlugin.this.table.getSelectedRow();
                String queryString = DataTypePreviewPlugin.this.model.getPreviewAt(row);
                if (queryString == null) {
                    return;
                }
                if (DataTypePreviewPlugin.this.goToService == null) {
                    return;
                }
                DataTypePreviewPlugin.this.goToService.goToQuery(DataTypePreviewPlugin.this.currentAddress, new QueryData(queryString, false), null, TaskMonitor.DUMMY);
            }
            DataTypePreviewPlugin.this.table.handleTableSelection();
        }
    }

    private class DTPPTable
    extends GhidraTable {
        private static final long serialVersionUID = 1L;

        DTPPTable(DTPPTableModel model) {
            super((TableModel)((Object)model));
            this.addMouseListener(new DTPPMouseListener());
            new DTPPDroppable((Component)((Object)this));
        }

        void handleTableSelection() {
            int selectedRow = DataTypePreviewPlugin.this.table.getSelectedRow();
            DataTypePreviewPlugin.this.setActionEnabled(selectedRow >= 0);
        }
    }

    private class DTPPScrollPane
    extends JScrollPane {
        private static final long serialVersionUID = 1L;

        DTPPScrollPane(Component view) {
            super(view);
            new DTPPDroppable(this);
        }
    }

    private class DTPPDroppable
    implements Droppable {
        private DataFlavor[] acceptableFlavors;
        private DropTgtAdapter dropTargetAdapter;
        private Component dropTargetComponent;

        DTPPDroppable(Component dropTarget) {
            this.dropTargetComponent = dropTarget;
            this.setUpDrop();
        }

        public boolean isDropOk(DropTargetDragEvent e) {
            return true;
        }

        public void dragUnderFeedback(boolean ok, DropTargetDragEvent e) {
        }

        public void undoDragUnderFeedback() {
        }

        public void add(Object obj, DropTargetDropEvent e, DataFlavor f) {
            if (obj instanceof DataType) {
                DataType dt = (DataType)obj;
                DataTypePreviewPlugin.this.addDataType(dt);
            }
        }

        private void setUpDrop() {
            this.acceptableFlavors = new DataFlavor[]{DataTypeTransferable.localDataTypeFlavor, DataTypeTransferable.localBuiltinDataTypeFlavor};
            this.dropTargetAdapter = new DropTgtAdapter((Droppable)this, 3, this.acceptableFlavors);
            DropTarget dropTarget = new DropTarget(this.dropTargetComponent, 3, (DropTargetListener)this.dropTargetAdapter, true);
            dropTarget.setActive(true);
        }
    }

    private class DTPPComponentProvider
    extends ComponentProviderAdapter {
        public DTPPComponentProvider() {
            super(DataTypePreviewPlugin.this.getTool(), "Data Type Preview", DataTypePreviewPlugin.this.getName());
            this.setHelpLocation(new HelpLocation(DataTypePreviewPlugin.this.getName(), DataTypePreviewPlugin.this.getName()));
        }

        public void componentShown() {
            DataTypePreviewPlugin.this.updateTitle();
        }

        public JComponent getComponent() {
            return DataTypePreviewPlugin.this.component;
        }
    }
}

