/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.program.database.DatabaseObject;
import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.MissingBuiltInDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDef;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreePath;

public class FindDataTypesContainingAction
extends DockingAction {
    public FindDataTypesContainingAction(DataTypeManagerPlugin plugin) {
        super("Find Data Types Containing", plugin.getName());
        this.setPopupMenuData(new MenuData(new String[]{"Find Data Types Containing..."}, null, "ZVeryLast"));
        this.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "Data_Type_Manager_Plugin"));
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        return context instanceof DataTypesActionContext;
    }

    public void actionPerformed(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return;
        }
        Object contextObject = context.getContextObject();
        GTree gTree = (GTree)contextObject;
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        StringBuffer text = new StringBuffer();
        if (selectionPaths.length != 1) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)gTree, (String)"Find Data Types Containing", (Object)"You must select a single data type in the tree.");
            return;
        }
        TreePath path = gTree.getSelectionPath();
        Object node = path.getLastPathComponent();
        if (!(node instanceof DataTypeNode)) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)gTree, (String)"Find Data Types Containing", (Object)"You must select a single data type in the tree.");
            return;
        }
        DataTypeNode dataTypeNode = (DataTypeNode)node;
        DataType dataType = dataTypeNode.getDataType();
        Iterator<DataType> parentDtIterator = this.getDataTypesContaining(dataType, gTree);
        if (!parentDtIterator.hasNext()) {
            DataTypeManager dataTypeManager = dataType.getDataTypeManager();
            ArchiveType type = dataTypeManager.getType();
            String typeName = " archive";
            if (type.equals((Object)ArchiveType.PROGRAM)) {
                typeName = " program";
            } else if (type.equals((Object)ArchiveType.BUILT_IN)) {
                typeName = "";
            }
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)gTree, (String)("Find Data Types Containing \"" + dataType.getPathName() + "\""), (Object)("<HTML><B>" + HTMLUtilities.friendlyEncodeHTML((String)dataType.getPathName()) + "</B> isn't contained in any other data types in the <B>" + HTMLUtilities.friendlyEncodeHTML((String)dataTypeManager.getName()) + "</B>" + typeName + "!!!</HTML>"));
            return;
        }
        text.append("<HTML>");
        text.append("<B>" + HTMLUtilities.friendlyEncodeHTML((String)dataType.getPathName()) + "</B> is contained in:<BR>");
        int count = 0;
        while (parentDtIterator.hasNext()) {
            DataType parentDt = parentDtIterator.next();
            if (++count >= 50) {
                text.append("<BR><BR>Too many to display...");
                break;
            }
            text.append("<BR>    " + HTMLUtilities.friendlyEncodeHTML((String)parentDt.getPathName()));
        }
        text.append("</HTML>");
        Msg.showInfo(((Object)((Object)this)).getClass(), (Component)gTree, (String)("Find Data Types Containing \"" + dataType.getPathName() + "\""), (Object)text.toString());
    }

    protected Iterator<DataType> getDataTypesContaining(DataType dataType, GTree gTree) {
        DataTypeManager dataTypeManager = dataType.getDataTypeManager();
        if (dataTypeManager == null) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)gTree, (String)("Find Data Types Containing \"" + dataType.getName() + "\""), (Object)("\"" + dataType.getName() + "\" doesn't have a data type manager."));
            return new DataTypeArrayIterator(new DataType[0]);
        }
        if (dataType instanceof DatabaseObject) {
            return new DataTypeArrayIterator(dataType.getParents());
        }
        return new DataTypeContainingIterator(dataType);
    }

    private static List<DataType> getDirectContainedDatatypes(DataType dt) {
        ArrayList<DataType> list = new ArrayList<DataType>();
        if (dt instanceof Array) {
            Array array = (Array)dt;
            list.add(array.getDataType());
        } else if (dt instanceof Pointer) {
            Pointer ptr = (Pointer)dt;
            DataType ptrDt = ptr.getDataType();
            if (ptrDt != null) {
                list.add(ptrDt);
            }
        } else if (dt instanceof Composite) {
            Composite composite = (Composite)dt;
            int n = composite.getNumComponents();
            for (int i = 0; i < n; ++i) {
                DataTypeComponent component = composite.getComponent(i);
                list.add(component.getDataType());
            }
        } else if (dt instanceof TypeDef) {
            TypeDef typedef = (TypeDef)dt;
            list.add(typedef.getDataType());
        } else if (!(dt instanceof Enum)) {
            if (dt instanceof FunctionDefinition) {
                ParameterDefinition[] arguments;
                FunctionDefinition funDef = (FunctionDefinition)dt;
                list.add(funDef.getReturnType());
                for (ParameterDefinition parameter : arguments = funDef.getArguments()) {
                    list.add(parameter.getDataType());
                }
            } else if (!(dt instanceof BuiltInDataType || dt instanceof MissingBuiltInDataType || dt.equals(DataType.DEFAULT))) {
                throw new AssertException("Unknown data Type:" + dt.getDisplayName());
            }
        }
        return list;
    }

    private class DataTypeContainingIterator
    implements Iterator<DataType> {
        DataType dataType;
        Iterator<DataType> iterator;
        DataType nextDataType = null;

        private DataTypeContainingIterator(DataType dataType) {
            this.dataType = dataType;
            DataTypeManager dataTypeManager = dataType.getDataTypeManager();
            this.iterator = dataTypeManager == null ? new DataTypeArrayIterator(new DataType[0]) : dataTypeManager.getAllDataTypes();
        }

        @Override
        public boolean hasNext() {
            if (this.nextDataType != null) {
                return true;
            }
            while (this.iterator.hasNext()) {
                DataType dt = this.iterator.next();
                List<DataType> containedDataTypes = FindDataTypesContainingAction.getDirectContainedDatatypes(dt);
                for (DataType containedDt : containedDataTypes) {
                    if (containedDt != this.dataType) continue;
                    this.nextDataType = dt;
                    return true;
                }
            }
            return false;
        }

        @Override
        public DataType next() {
            if (this.nextDataType == null) {
                this.hasNext();
            }
            DataType tempDataType = this.nextDataType;
            this.nextDataType = null;
            return tempDataType;
        }

        @Override
        public void remove() {
        }
    }

    private class DataTypeArrayIterator
    implements Iterator<DataType> {
        DataType[] dataTypes;
        int nextIndex = 0;

        private DataTypeArrayIterator(DataType[] dataTypes) {
            this.dataTypes = dataTypes;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.dataTypes.length;
        }

        @Override
        public DataType next() {
            return this.dataTypes[this.nextIndex++];
        }

        @Override
        public void remove() {
        }
    }
}

