/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.program.model.data.CycleGroup;
import javax.swing.KeyStroke;

public class CycleGroupAction
extends CompositeEditorTableAction {
    private static final String GROUP_NAME = "2_DATA_EDITOR_ACTION";
    private CycleGroup cycleGroup;

    public CycleGroupAction(CompositeEditorProvider provider, CycleGroup cycleGroup) {
        super(provider, cycleGroup.getName(), GROUP_NAME, new String[]{"Cycle", cycleGroup.getName()}, new String[]{"Cycle", cycleGroup.getName()}, null, KeyBindingType.SHARED);
        this.cycleGroup = cycleGroup;
        this.getPopupMenuData().setParentMenuGroup(GROUP_NAME);
        this.initKeyStroke(cycleGroup.getDefaultKeyStroke());
    }

    private void initKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return;
        }
        this.setKeyBindingData(new KeyBindingData(keyStroke));
    }

    public CycleGroup getCycleGroup() {
        return this.cycleGroup;
    }

    public void actionPerformed(ActionContext context) {
        this.model.cycleDataType(this.cycleGroup);
        this.requestTableFocus();
    }

    @Override
    public void adjustEnablement() {
        this.setEnabled(true);
    }

    @Override
    public String getHelpName() {
        return "Cycle";
    }
}

