/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.comments;

import docking.ActionContext;
import docking.DialogComponentProvider;
import ghidra.app.plugin.core.comments.CommentHistoryPanel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CommentHistoryDialog
extends DialogComponentProvider
implements ChangeListener {
    private Program program;
    private CodeUnit codeUnit;
    private JTabbedPane tabbedPane;
    private CommentHistoryPanel eolPanel;
    private CommentHistoryPanel prePanel;
    private CommentHistoryPanel postPanel;
    private CommentHistoryPanel platePanel;
    private CommentHistoryPanel repeatablePanel;
    private static final int[] COMMENT_INDEXES = new int[]{0, 1, 2, 3, 4};

    CommentHistoryDialog() {
        super("Show Comment History");
        this.setHelpLocation(new HelpLocation("CommentsPlugin", "Show_Comment_History"));
        this.addWorkPanel(this.buildMainPanel());
        this.addDismissButton();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int index = this.tabbedPane.getSelectedIndex();
        CommentHistoryPanel panel = this.getHistoryPanel(COMMENT_INDEXES[index]);
        panel.showCommentHistory(this.program, this.codeUnit.getMinAddress());
    }

    void showDialog(CodeUnit cu, int commentType, PluginTool tool, ActionContext context) {
        this.codeUnit = cu;
        this.program = cu.getProgram();
        CommentHistoryPanel panel = this.getHistoryPanel(commentType);
        panel.showCommentHistory(this.program, cu.getMinAddress());
        this.tabbedPane.removeChangeListener(this);
        for (int i = 0; i < COMMENT_INDEXES.length; ++i) {
            if (COMMENT_INDEXES[i] != commentType) continue;
            this.tabbedPane.setSelectedIndex(i);
            break;
        }
        this.tabbedPane.addChangeListener(this);
        tool.showDialog((DialogComponentProvider)this, context.getComponentProvider());
    }

    private JPanel buildMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        mainPanel.add(this.tabbedPane);
        this.eolPanel = new CommentHistoryPanel(0);
        this.prePanel = new CommentHistoryPanel(1);
        this.postPanel = new CommentHistoryPanel(2);
        this.platePanel = new CommentHistoryPanel(3);
        this.repeatablePanel = new CommentHistoryPanel(4);
        JScrollPane sp = new JScrollPane(this.eolPanel);
        JViewport vp = sp.getViewport();
        Dimension d = vp.getPreferredSize();
        sp.getViewport().setPreferredSize(new Dimension(500, d.height * 7));
        this.tabbedPane.addTab("  EOL Comment    ", sp);
        this.tabbedPane.addTab("  Pre Comment    ", new JScrollPane(this.prePanel));
        this.tabbedPane.addTab("  Post Comment   ", new JScrollPane(this.postPanel));
        this.tabbedPane.addTab("  Plate Comment  ", new JScrollPane(this.platePanel));
        this.tabbedPane.addTab("  Repeatable Comment  ", new JScrollPane(this.repeatablePanel));
        this.tabbedPane.addChangeListener(this);
        return mainPanel;
    }

    private CommentHistoryPanel getHistoryPanel(int commentType) {
        switch (commentType) {
            case 0: {
                return this.eolPanel;
            }
            case 1: {
                return this.prePanel;
            }
            case 2: {
                return this.postPanel;
            }
            case 3: {
                return this.platePanel;
            }
            case 4: {
                return this.repeatablePanel;
            }
        }
        return null;
    }
}

