/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.calltree;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.calltree.CallTreeProvider;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import resources.Icons;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Graph", shortDescription="Call Trees Plugin", description="This plugin shows incoming and outgoing calls for a given function.  More specifically, one tree of the plugin will show all callers of the function and the other tree of the plugin will show all calls made by the function")
public class CallTreePlugin
extends ProgramPlugin {
    static final Icon PROVIDER_ICON = Icons.ARROW_DOWN_RIGHT_ICON;
    static final Icon FUNCTION_ICON = ResourceManager.loadImage((String)"images/FunctionScope.gif");
    static final Icon RECURSIVE_ICON = ResourceManager.loadImage((String)"images/arrow_rotate_clockwise.png");
    private List<CallTreeProvider> providers = new ArrayList<CallTreeProvider>();
    private DockingAction showCallTreeFromMenuAction;
    private CallTreeProvider primaryProvider;

    public CallTreePlugin(PluginTool tool) {
        super(tool, true, false, false);
        this.createActions();
        this.primaryProvider = new CallTreeProvider(this, true);
        this.providers.add(this.primaryProvider);
    }

    @Override
    protected void locationChanged(ProgramLocation loc) {
        for (CallTreeProvider provider : this.providers) {
            provider.setLocation(loc);
        }
    }

    @Override
    protected void programActivated(Program program) {
        for (CallTreeProvider provider : this.providers) {
            provider.programActivated(program);
        }
    }

    @Override
    protected void programDeactivated(Program program) {
        for (CallTreeProvider provider : this.providers) {
            provider.programDeactivated(program);
        }
    }

    @Override
    protected void programClosed(Program program) {
        for (CallTreeProvider provider : this.providers) {
            provider.programClosed(program);
        }
    }

    protected void dispose() {
        ArrayList<CallTreeProvider> copy = new ArrayList<CallTreeProvider>(this.providers);
        for (CallTreeProvider provider : copy) {
            this.removeProvider(provider);
        }
    }

    CallTreeProvider findTransientProviderForLocation(ProgramLocation location) {
        for (CallTreeProvider provider : this.providers) {
            if (!provider.isTransient() || !provider.isShowingLocation(location)) continue;
            return provider;
        }
        return null;
    }

    private void createActions() {
        String actionName = "Function Call Trees";
        this.showCallTreeFromMenuAction = new DockingAction(actionName, this.getName(), KeyBindingType.SHARED){

            public void actionPerformed(ActionContext context) {
                CallTreePlugin.this.showOrCreateNewCallTree(CallTreePlugin.this.currentLocation);
            }

            public boolean isAddToPopup(ActionContext context) {
                return context instanceof ListingActionContext;
            }
        };
        this.showCallTreeFromMenuAction.setPopupMenuData(new MenuData(new String[]{"References", "Show Call Trees"}, PROVIDER_ICON, "ShowReferencesTo"));
        this.showCallTreeFromMenuAction.setHelpLocation(new HelpLocation("CallTreePlugin", "Call_Tree_Plugin"));
        this.tool.addAction((DockingActionIf)this.showCallTreeFromMenuAction);
    }

    private void creatAndShowProvider() {
        CallTreeProvider provider = new CallTreeProvider(this, false);
        this.providers.add(provider);
        provider.initialize(this.currentProgram, this.currentLocation);
        this.tool.showComponentProvider((ComponentProvider)provider, true);
    }

    CallTreeProvider getPrimaryProvider() {
        return this.primaryProvider;
    }

    DockingAction getShowCallTreeFromMenuAction() {
        return this.showCallTreeFromMenuAction;
    }

    ProgramLocation getCurrentLocation() {
        return this.currentLocation;
    }

    void removeProvider(CallTreeProvider provider) {
        if (!this.providers.contains((Object)provider)) {
            return;
        }
        this.providers.remove((Object)provider);
        this.tool.removeComponentProvider((ComponentProvider)provider);
        provider.dispose();
    }

    void showOrCreateNewCallTree(ProgramLocation location) {
        if (this.currentProgram == null) {
            return;
        }
        CallTreeProvider provider = this.findTransientProviderForLocation(location);
        if (provider != null) {
            this.tool.showComponentProvider((ComponentProvider)provider, true);
            return;
        }
        Function function = this.getFunction(location);
        if (function == null) {
            this.tool.setStatusInfo("No function containing address: " + location.getAddress(), true);
            return;
        }
        this.creatAndShowProvider();
    }

    Function getFunction(ProgramLocation location) {
        FunctionManager functionManager = this.currentProgram.getFunctionManager();
        Address address = location.getAddress();
        Function function = functionManager.getFunctionContaining(address);
        function = this.resolveFunction(function, address);
        return function;
    }

    Function resolveFunction(Function function, Address address) {
        Reference[] references;
        if (function != null) {
            return function;
        }
        FunctionManager functionManager = this.currentProgram.getFunctionManager();
        ReferenceManager referenceManager = this.currentProgram.getReferenceManager();
        for (Reference reference : references = referenceManager.getReferencesFrom(address)) {
            Address toAddress = reference.getToAddress();
            Function toFunction = functionManager.getFunctionAt(toAddress);
            if (toFunction == null) continue;
            return toFunction;
        }
        return null;
    }
}

