/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin;

import docking.action.DockingAction;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramHighlightPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import java.util.ArrayList;

public abstract class ProgramPlugin
extends Plugin {
    protected Program currentProgram;
    protected ProgramLocation currentLocation;
    protected ProgramSelection currentSelection;
    protected ProgramSelection currentHighlight;
    private ArrayList<DockingAction> programActionList;
    private ArrayList<DockingAction> locationActionList;
    private ArrayList<DockingAction> selectionActionList;
    private ArrayList<DockingAction> highlightActionList;

    public ProgramPlugin(PluginTool plugintool, boolean consumeLocationChange, boolean consumeSelectionChange, boolean consumeHighlightChange) {
        super(plugintool);
        this.registerEventConsumed(ProgramActivatedPluginEvent.class);
        if (consumeLocationChange) {
            this.registerEventConsumed(ProgramLocationPluginEvent.class);
        }
        if (consumeSelectionChange) {
            this.registerEventConsumed(ProgramSelectionPluginEvent.class);
        }
        if (consumeHighlightChange) {
            this.registerEventConsumed(ProgramHighlightPluginEvent.class);
        }
        this.registerEventConsumed(ProgramOpenedPluginEvent.class);
        this.registerEventConsumed(ProgramClosedPluginEvent.class);
        this.programActionList = new ArrayList(3);
        this.locationActionList = new ArrayList(3);
        this.selectionActionList = new ArrayList(3);
        this.highlightActionList = new ArrayList(3);
    }

    public ProgramPlugin(PluginTool tool, boolean consumeLocationChange, boolean consumeSelectionChange) {
        this(tool, consumeLocationChange, consumeSelectionChange, false);
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramClosedPluginEvent) {
            ProgramClosedPluginEvent ev = (ProgramClosedPluginEvent)event;
            this.programClosed(ev.getProgram());
        } else if (event instanceof ProgramOpenedPluginEvent) {
            ProgramOpenedPluginEvent ev = (ProgramOpenedPluginEvent)event;
            this.programOpened(ev.getProgram());
        } else if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent ev = (ProgramActivatedPluginEvent)event;
            Program oldProgram = this.currentProgram;
            this.currentProgram = ev.getActiveProgram();
            if (oldProgram != null) {
                this.programDeactivated(oldProgram);
                this.currentLocation = null;
                this.currentSelection = null;
                this.currentHighlight = null;
                this.locationChanged(null);
                this.selectionChanged(null);
                this.highlightChanged(null);
                this.enableActions(this.locationActionList, false);
                this.enableActions(this.selectionActionList, false);
                this.enableActions(this.highlightActionList, false);
            }
            if (this.currentProgram != null) {
                this.programActivated(this.currentProgram);
            }
            this.enableActions(this.programActionList, this.currentProgram != null);
        } else if (event instanceof ProgramLocationPluginEvent) {
            ProgramLocationPluginEvent ev = (ProgramLocationPluginEvent)event;
            this.currentLocation = ev.getLocation();
            if (this.currentLocation != null && this.currentLocation.getAddress() == null || this.currentProgram == null && ev.getProgram() == null) {
                this.currentLocation = null;
                this.enableActions(this.locationActionList, false);
            } else if (this.currentLocation == null) {
                this.enableActions(this.locationActionList, false);
            } else {
                this.enableActions(this.locationActionList, true);
            }
            if (this.currentProgram == null) {
                return;
            }
            this.locationChanged(this.currentLocation);
        } else if (event instanceof ProgramSelectionPluginEvent) {
            ProgramSelectionPluginEvent ev = (ProgramSelectionPluginEvent)event;
            this.currentSelection = ev.getSelection();
            if (this.currentSelection != null && !this.currentSelection.isEmpty()) {
                this.enableActions(this.selectionActionList, true);
            } else {
                this.enableActions(this.selectionActionList, false);
                this.currentSelection = null;
            }
            this.selectionChanged(this.currentSelection);
        } else if (event instanceof ProgramHighlightPluginEvent) {
            ProgramHighlightPluginEvent ev = (ProgramHighlightPluginEvent)event;
            this.currentHighlight = ev.getHighlight();
            if (this.currentHighlight != null && !this.currentHighlight.isEmpty()) {
                this.enableActions(this.highlightActionList, true);
            } else {
                this.enableActions(this.highlightActionList, false);
                this.currentHighlight = null;
            }
            this.highlightChanged(this.currentHighlight);
        }
    }

    @Deprecated
    protected void enableOnProgram(DockingAction action) {
        if (this.locationActionList.contains(action)) {
            throw new IllegalArgumentException("Action already added to location action list");
        }
        if (this.selectionActionList.contains(action)) {
            throw new IllegalArgumentException("Action already added to selection action list");
        }
        if (this.highlightActionList.contains(action)) {
            throw new IllegalArgumentException("Action already added to highlight action list");
        }
        this.programActionList.add(action);
        action.setEnabled(this.currentProgram != null);
    }

    @Deprecated
    protected void enableOnLocation(DockingAction action) {
        if (this.programActionList.contains(action)) {
            throw new IllegalArgumentException("Action already added to program action list");
        }
        if (this.selectionActionList.contains(action)) {
            throw new IllegalArgumentException("Action already added to selection action list");
        }
        if (this.highlightActionList.contains(action)) {
            throw new IllegalArgumentException("Action already added to highlight action list");
        }
        this.locationActionList.add(action);
        action.setEnabled(this.currentLocation != null);
    }

    @Deprecated
    protected void enableOnSelection(DockingAction action) {
        if (this.programActionList.contains(action)) {
            throw new IllegalArgumentException("Action already added to program action list");
        }
        if (this.locationActionList.contains(action)) {
            throw new IllegalArgumentException("Action already added to location action list");
        }
        if (this.highlightActionList.contains(action)) {
            throw new IllegalArgumentException("Action already added to highlight action list");
        }
        this.selectionActionList.add(action);
        action.setEnabled(this.currentSelection != null);
    }

    @Deprecated
    protected void enableOnHighlight(DockingAction action) {
        if (this.programActionList.contains(action)) {
            throw new IllegalArgumentException("Action already added to program action list");
        }
        if (this.locationActionList.contains(action)) {
            throw new IllegalArgumentException("Action already added to location action list");
        }
        if (this.selectionActionList.contains(action)) {
            throw new IllegalArgumentException("Action already added to selection action list");
        }
        this.highlightActionList.add(action);
        action.setEnabled(this.currentHighlight != null);
    }

    protected void programActivated(Program program) {
    }

    protected void programClosed(Program program) {
    }

    protected void programOpened(Program program) {
    }

    protected void programDeactivated(Program program) {
    }

    protected void locationChanged(ProgramLocation loc) {
    }

    protected void selectionChanged(ProgramSelection sel) {
    }

    protected void highlightChanged(ProgramSelection hl) {
    }

    protected boolean goTo(Address addr) {
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service != null) {
            return service.goTo(addr);
        }
        return false;
    }

    protected boolean goTo(CodeUnit cu) {
        if (cu != null) {
            this.goTo(cu.getMinAddress());
        }
        return false;
    }

    protected void setSelection(AddressSetView set) {
        if (this.currentProgram == null) {
            return;
        }
        this.firePluginEvent(new ProgramSelectionPluginEvent(this.getName(), new ProgramSelection(set), this.currentProgram));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBookmark(Address addr, String type, String category, String comment) {
        if (this.currentProgram == null) {
            return;
        }
        BookmarkManager mgr = this.currentProgram.getBookmarkManager();
        int transactionID = this.currentProgram.startTransaction("Set Bookmark");
        try {
            mgr.setBookmark(addr, type, category, comment);
        }
        finally {
            this.currentProgram.endTransaction(transactionID, true);
        }
    }

    private void enableActions(ArrayList<DockingAction> list, boolean enabled) {
        for (int i = 0; i < list.size(); ++i) {
            DockingAction a = list.get(i);
            a.setEnabled(enabled);
        }
    }

    public ProgramLocation getProgramLocation() {
        return this.currentLocation;
    }

    public Program getCurrentProgram() {
        return this.currentProgram;
    }

    public ProgramSelection getProgramSelection() {
        return this.currentSelection;
    }

    public ProgramSelection getProgramHighlight() {
        return this.currentHighlight;
    }
}

