/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.gnu;

import ghidra.framework.Application;
import ghidra.framework.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;

public class GnuDemanglerNativeProcess {
    private static final String DEMANGLER_GNU = "demangler_gnu";
    private static GnuDemanglerNativeProcess demanglerNativeProcess;
    private boolean isDisposed;
    private Process process;
    private BufferedReader reader;
    private PrintWriter writer;

    public static synchronized GnuDemanglerNativeProcess getDemanglerNativeProcess() throws IOException {
        if (demanglerNativeProcess == null) {
            demanglerNativeProcess = new GnuDemanglerNativeProcess();
        }
        return demanglerNativeProcess;
    }

    private GnuDemanglerNativeProcess() throws IOException {
        this.createProcess();
    }

    public synchronized String demangle(String mangled) throws IOException {
        if (this.isDisposed) {
            throw new IOException("Demangled process has been terminated.");
        }
        return this.demangle(mangled, true);
    }

    private String demangle(String mangled, boolean restart) throws IOException {
        try {
            this.writer.println(mangled);
            this.writer.flush();
            return this.reader.readLine();
        }
        catch (IOException e) {
            this.dispose();
            if (!restart) {
                demanglerNativeProcess = null;
                throw new IOException("Demangler process is not running.");
            }
            this.createProcess();
            return this.demangle(mangled, false);
        }
    }

    private void dispose() {
        try {
            if (this.process != null) {
                this.process.destroy();
            }
            this.process = null;
            this.reader = null;
            this.writer = null;
        }
        catch (Exception exception) {
        }
        finally {
            this.isDisposed = true;
        }
    }

    private void createProcess() throws IOException {
        String executableName = DEMANGLER_GNU + Platform.CURRENT_PLATFORM.getExecutableExtension();
        File commandPath = Application.getOSFile((String)executableName);
        String[] command = new String[]{commandPath.getAbsolutePath()};
        this.process = Runtime.getRuntime().exec(command);
        InputStream in = this.process.getInputStream();
        OutputStream out = this.process.getOutputStream();
        this.reader = new BufferedReader(new InputStreamReader(in));
        this.writer = new PrintWriter(out);
        this.isDisposed = false;
    }
}

