/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.AbstractStringDataType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Program;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Predicate;

public class DefinedDataIterator
implements DataIterator {
    private Queue<Data> resultsQueue = new LinkedList<Data>();
    private Predicate<Data> dataInstancePredicate;
    private DataIterator definedDataIterator;

    public static DefinedDataIterator byDataType(Program program, Predicate<DataType> dataTypePredicate) {
        return new DefinedDataIterator(program, null, data -> dataTypePredicate.test(data.getBaseDataType()));
    }

    public static DefinedDataIterator definedStrings(Program program) {
        return new DefinedDataIterator(program, null, data -> StringDataInstance.isString(data));
    }

    public static DefinedDataIterator definedStrings(Program program, AddressSetView addrs) {
        return new DefinedDataIterator(program, addrs, data -> StringDataInstance.isString(data));
    }

    public static DefinedDataIterator definedStrings(Data singleDataInstance) {
        return new DefinedDataIterator(singleDataInstance, data -> StringDataInstance.isString(data));
    }

    private DefinedDataIterator(Program program, AddressSetView addrs, Predicate<Data> dataInstancePredicate) {
        this.dataInstancePredicate = dataInstancePredicate;
        this.definedDataIterator = program.getListing().getDefinedData(addrs == null ? program.getMemory().getAllInitializedAddressSet() : addrs, true);
    }

    private DefinedDataIterator(Data singleDataInstance, Predicate<Data> dataInstancePredicate) {
        this.dataInstancePredicate = dataInstancePredicate;
        this.definedDataIterator = DataIterator.EMPTY;
        this.processDataInstance(singleDataInstance);
    }

    @Override
    public boolean hasNext() {
        if (this.resultsQueue.isEmpty()) {
            this.findNext();
        }
        return !this.resultsQueue.isEmpty();
    }

    @Override
    public Data next() {
        if (this.hasNext()) {
            return this.resultsQueue.remove();
        }
        return null;
    }

    private void findNext() {
        while (this.definedDataIterator.hasNext() && this.resultsQueue.isEmpty()) {
            Data nextData = this.definedDataIterator.next();
            this.processDataInstance(nextData);
        }
    }

    private void processDataInstance(Data data) {
        if (this.dataInstancePredicate.test(data)) {
            this.resultsQueue.add(data);
            return;
        }
        DataType dt = data.getBaseDataType();
        if (dt instanceof Composite || this.isIterableArray(dt)) {
            int compCount = data.getNumComponents();
            for (int compNum = 0; compNum < compCount; ++compNum) {
                Data componentData = data.getComponent(compNum);
                this.processDataInstance(componentData);
            }
        }
    }

    private boolean isIterableArray(DataType dataType) {
        if (dataType instanceof Array) {
            DataType elementDT = ((Array)dataType).getDataType();
            if (elementDT instanceof TypeDef) {
                elementDT = ((TypeDef)elementDT).getBaseDataType();
            }
            return elementDT instanceof Array || elementDT instanceof Composite || elementDT instanceof AbstractStringDataType;
        }
        return false;
    }
}

