/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.scalar;

public class ScalarFormat {
    private boolean zeroPadded;
    private boolean signed;
    private String pre;
    private String post;
    private int radix;

    public ScalarFormat() {
        this.radix = 16;
        this.zeroPadded = true;
        this.signed = false;
        this.pre = "";
        this.post = "";
    }

    public ScalarFormat(int radix, boolean zeroPadded, boolean signed, String pre, String post) {
        switch (radix) {
            case 2: 
            case 8: 
            case 10: 
            case 16: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid radix");
            }
        }
        this.zeroPadded = zeroPadded;
        this.signed = signed;
        this.pre = pre;
        this.post = post;
        this.radix = radix;
    }

    public boolean isZeroPadded() {
        return this.zeroPadded;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public String getPre() {
        return this.pre;
    }

    public String getPost() {
        return this.post;
    }

    public int getRadix() {
        return this.radix;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(radix=" + this.radix + ", ");
        if (this.zeroPadded) {
            buf.append("zero padded, ");
        }
        if (this.signed) {
            buf.append("signed, ");
        }
        buf.append("pre='" + this.pre + "', post='" + this.post + "')");
        return new String(buf);
    }
}

