/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.ParamEntry;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighLocal;
import ghidra.program.model.pcode.HighParam;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class MappedSymbol
extends HighSymbol {
    private VariableStorage storage;
    private int slot;

    public MappedSymbol() {
    }

    public MappedSymbol(String name, DataType dt, VariableStorage store, Address pcaddr, HighFunction func, int slot) {
        super(name, dt, store.size(), pcaddr, func);
        if (store.size() != dt.getLength() && ParamEntry.getMetatype(dt) != 3) {
            throw new IllegalArgumentException("Specified size does not match storage size");
        }
        this.storage = store;
        this.slot = slot;
        Varnode rep = this.function.createFromStorage(null, this.storage, dt.getLength());
        HighLocal var = slot < 0 ? new HighLocal(this.type, rep, null, pcaddr, this) : new HighParam(this.type, rep, pcaddr, slot, (HighSymbol)this);
        this.setHighVariable(var);
        var.setHighOnInstances();
    }

    public VariableStorage getStorage() {
        return this.storage;
    }

    public boolean isParameter() {
        return this.slot >= 0;
    }

    public int getSlot() {
        return this.slot;
    }

    @Override
    public String buildXML() {
        if (this.storage.getMinAddress() == null) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        int cat = this.isParameter() ? 0 : -1;
        String sym = MappedSymbol.buildSymbolXML(this.function.getDataTypeManager(), this.name, this.type, this.size, this.isTypeLocked(), this.isNameLocked(), false, false, cat, this.slot);
        int logicalsize = 0;
        if (this.type != null && this.type.getLength() != this.storage.size()) {
            logicalsize = this.type.getLength();
        }
        String addrRes = Varnode.buildXMLAddress(this.storage.getVarnodes(), logicalsize);
        MappedSymbol.buildMapSymXML(res, addrRes, this.getPCAddress(), sym);
        return res.toString();
    }

    @Override
    public int restoreXML(XmlPullParser parser, HighFunction func) throws PcodeXMLException {
        XmlElement symel = parser.start(new String[]{"symbol"});
        int symbolId = this.restoreSymbolXML(symel, func);
        this.slot = -1;
        int cat = -1;
        if (symel.hasAttribute("cat") && (cat = SpecXmlUtils.decodeInt((String)symel.getAttribute("cat"))) == 0) {
            this.slot = SpecXmlUtils.decodeInt((String)symel.getAttribute("index"));
        }
        this.type = func.getDataTypeManager().readXMLDataType(parser);
        parser.end(symel);
        if (this.slot >= 0 && this.name.startsWith("$$undef")) {
            this.name = "param_" + Integer.toString(this.slot + 1);
        }
        Program program = this.function.getFunction().getProgram();
        AddressFactory addrFactory = this.function.getAddressFactory();
        Address addr = null;
        XmlElement addrel = parser.start(new String[]{"addr"});
        int sz = this.type.getLength();
        if (sz == 0) {
            throw new PcodeXMLException("Invalid symbol 0-sized data-type: " + this.type.getName());
        }
        try {
            Address varAddr = Varnode.readXMLAddress(addrel, addrFactory);
            AddressSpace spc = varAddr.getAddressSpace();
            if (spc == null || spc.getType() != 11) {
                this.storage = new VariableStorage(program, varAddr, sz);
            } else {
                addr = varAddr;
                this.storage = func.readXMLVarnodePieces(addrel, varAddr);
            }
        }
        catch (InvalidInputException e) {
            throw new PcodeXMLException("Invalid storage: " + e.getMessage());
        }
        this.size = this.storage.size();
        parser.end(addrel);
        this.pcaddr = this.parseRangeList(parser);
        Varnode rep = this.function.createFromStorage(addr, this.storage, sz);
        HighLocal var = this.slot < 0 ? new HighLocal(this.type, rep, null, this.pcaddr, this) : new HighParam(this.type, rep, this.pcaddr, this.slot, (HighSymbol)this);
        this.setHighVariable(var);
        var.setHighOnInstances();
        return symbolId;
    }

    public static String buildSymbolXML(PcodeDataTypeManager dtmanage, String nm, DataType dt, int length, boolean tl, boolean nl, boolean ro, boolean isVolatile, int cat, int slot) {
        StringBuilder res = new StringBuilder();
        res.append("<symbol");
        SpecXmlUtils.xmlEscapeAttribute((StringBuilder)res, (String)"name", (String)nm);
        SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"typelock", (boolean)tl);
        SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"namelock", (boolean)nl);
        SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"readonly", (boolean)ro);
        if (isVolatile) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"volatile", (boolean)true);
        }
        SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)res, (String)"cat", (long)cat);
        if (slot >= 0) {
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)res, (String)"index", (long)slot);
        }
        res.append(">\n");
        res.append((CharSequence)dtmanage.buildTypeRef(dt, length));
        res.append("</symbol>\n");
        return res.toString();
    }
}

