/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.HighParam;
import ghidra.program.model.pcode.LocalSymbolMap;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class FunctionPrototype {
    private LocalSymbolMap localsyms;
    private String modelname;
    private GenericCallingConvention gconv;
    private String injectname;
    private DataType returntype;
    private VariableStorage returnstorage;
    private ParameterDefinition[] params;
    private boolean modellock;
    private boolean voidinputlock;
    private boolean outputlock;
    private boolean dotdotdot;
    private int extrapop;
    private boolean isinline;
    private boolean noreturn;
    private boolean custom;
    private boolean hasThis;
    private boolean isConstruct;
    private boolean isDestruct;

    public FunctionPrototype(LocalSymbolMap ls, Function func) {
        this.localsyms = ls;
        this.modelname = null;
        this.gconv = null;
        this.injectname = null;
        this.returntype = null;
        this.returnstorage = null;
        this.params = null;
        this.modellock = false;
        this.voidinputlock = false;
        this.outputlock = false;
        this.dotdotdot = func.hasVarArgs();
        this.isinline = func.isInline();
        this.noreturn = func.hasNoReturn();
        this.custom = func.hasCustomVariableStorage();
        this.hasThis = false;
        this.isConstruct = false;
        this.isDestruct = false;
        this.extrapop = 32768;
    }

    public FunctionPrototype(FunctionSignature proto, CompilerSpec cspec, boolean voidimpliesdotdotdot) {
        PrototypeModel model = cspec.matchConvention(proto.getGenericCallingConvention());
        this.localsyms = null;
        this.modelname = model.getName();
        this.gconv = proto.getGenericCallingConvention();
        this.injectname = null;
        this.returntype = proto.getReturnType();
        this.returnstorage = null;
        this.params = proto.getArguments();
        this.modellock = true;
        this.voidinputlock = this.params == null || this.params.length == 0;
        this.outputlock = true;
        this.dotdotdot = proto.hasVarArgs();
        this.isinline = false;
        this.noreturn = false;
        this.custom = false;
        this.extrapop = model.getExtrapop();
        this.hasThis = false;
        this.isConstruct = false;
        this.isDestruct = false;
        if (voidimpliesdotdotdot && this.voidinputlock) {
            this.dotdotdot = true;
        }
    }

    void grabFromFunction(Function f, int overrideExtrapop, boolean doOverride) {
        this.modelname = f.getCallingConventionName();
        this.modellock = this.modelname != null && this.modelname != "unknown";
        this.injectname = f.getCallFixup();
        this.voidinputlock = false;
        Parameter returnparam = f.getReturn();
        this.returntype = returnparam.getDataType();
        this.returnstorage = returnparam.getVariableStorage();
        SourceType sigSource = f.getSignatureSource();
        this.outputlock = sigSource != SourceType.DEFAULT ? DataType.DEFAULT != this.returntype : false;
        if (this.returnstorage == null || !this.returnstorage.isValid()) {
            this.outputlock = false;
            this.returnstorage = VariableStorage.VOID_STORAGE;
            this.returntype = DataType.VOID;
        }
        this.voidinputlock = f.getSignatureSource() != SourceType.DEFAULT && f.getParameterCount() == 0;
        this.dotdotdot = f.hasVarArgs();
        this.isinline = f.isInline();
        this.noreturn = f.hasNoReturn() | this.isNoReturnInjection(f, this.injectname);
        this.custom = f.hasCustomVariableStorage();
        int purge = f.getStackPurgeSize();
        if (doOverride) {
            this.extrapop = overrideExtrapop;
        } else {
            PrototypeModel protoModel = f.getCallingConvention();
            if (protoModel == null) {
                protoModel = f.getProgram().getCompilerSpec().getDefaultCallingConvention();
            }
            this.extrapop = purge == 0x7FFFFFFE || purge == Integer.MAX_VALUE ? protoModel.getExtrapop() : purge + protoModel.getStackshift();
        }
    }

    private boolean isNoReturnInjection(Function f, String fixupname) {
        if (fixupname == null) {
            return false;
        }
        Program program = f.getProgram();
        InjectPayload callFixup = program.getCompilerSpec().getPcodeInjectLibrary().getPayload(1, fixupname, program, null);
        if (callFixup == null) {
            return false;
        }
        return !callFixup.isFallThru();
    }

    public int getNumParams() {
        if (this.localsyms != null) {
            return this.localsyms.getNumParams();
        }
        return this.params.length;
    }

    public HighParam getParam(int i) {
        if (this.localsyms != null) {
            return this.localsyms.getParam(i);
        }
        return null;
    }

    public ParameterDefinition[] getParameterDefinitions() {
        return this.params != null ? (ParameterDefinition[])this.params.clone() : null;
    }

    public boolean isBackedByLocalSymbolMap() {
        return this.localsyms != null;
    }

    public DataType getReturnType() {
        return this.returntype;
    }

    public VariableStorage getReturnStorage() {
        return this.returnstorage;
    }

    public int getExtraPop() {
        return this.extrapop;
    }

    public boolean isVarArg() {
        return this.dotdotdot;
    }

    public boolean isInline() {
        return this.isinline;
    }

    public boolean hasNoReturn() {
        return this.noreturn;
    }

    public boolean hasThisPointer() {
        return this.hasThis;
    }

    public boolean isConstructor() {
        return this.isConstruct;
    }

    public boolean isDestructor() {
        return this.isDestruct;
    }

    public String getModelName() {
        return this.modelname;
    }

    public GenericCallingConvention getGenericCallingConvention() {
        return this.gconv;
    }

    public void buildPrototypeXML(StringBuilder res, PcodeDataTypeManager dtmanage) {
        res.append("<prototype");
        if (this.extrapop == 32768) {
            SpecXmlUtils.encodeStringAttribute((StringBuilder)res, (String)"extrapop", (String)"unknown");
        } else {
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)res, (String)"extrapop", (long)this.extrapop);
        }
        SpecXmlUtils.encodeStringAttribute((StringBuilder)res, (String)"model", (String)this.modelname);
        if (this.modellock) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"modellock", (boolean)this.modellock);
        }
        if (this.dotdotdot) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"dotdotdot", (boolean)this.dotdotdot);
        }
        if (this.voidinputlock) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"voidlock", (boolean)this.voidinputlock);
        }
        if (this.isinline) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"inline", (boolean)this.isinline);
        }
        if (this.noreturn) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"noreturn", (boolean)this.noreturn);
        }
        if (this.custom) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"custom", (boolean)this.custom);
        }
        if (this.hasThis) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"hasthis", (boolean)this.hasThis);
        }
        if (this.isConstruct) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"constructor", (boolean)this.isConstruct);
        }
        if (this.isDestruct) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"destructor", (boolean)this.isDestruct);
        }
        res.append(">\n");
        res.append("  <returnsym");
        if (this.outputlock) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"typelock", (boolean)this.outputlock);
        }
        res.append(">\n   ");
        int sz = this.returntype.getLength();
        if (sz < 0) {
            Msg.warn((Object)this, (Object)"Bad returntype size");
            sz = 1;
        }
        if (this.returnstorage != null && this.returnstorage.isValid() && !this.returnstorage.isVoidStorage()) {
            int logicalsize = 0;
            if (sz != this.returnstorage.size()) {
                logicalsize = sz;
            }
            String addrstring = Varnode.buildXMLAddress(this.returnstorage.getVarnodes(), logicalsize);
            res.append(addrstring).append("\n   ");
        } else {
            res.append("<addr/>\n   ");
        }
        res.append((CharSequence)dtmanage.buildTypeRef(this.returntype, sz));
        res.append("  </returnsym>\n");
        if (this.injectname != null) {
            res.append("<inject>");
            res.append(this.injectname);
            res.append("</inject>\n");
        }
        if (this.params != null) {
            res.append("<internallist>\n");
            for (ParameterDefinition param : this.params) {
                res.append("<param");
                String name = param.getName();
                DataType dt = param.getDataType();
                boolean namelock = false;
                if (name != null && name.length() > 0) {
                    res.append(" name=\"").append(name).append('\"');
                    namelock = true;
                }
                res.append(" typelock=\"true\" namelock=\"");
                res.append(namelock ? "true" : "false");
                res.append("\">\n");
                res.append("  <addr/>\n  ");
                sz = dt.getLength();
                if (sz < 0) {
                    sz = 1;
                }
                res.append((CharSequence)dtmanage.buildTypeRef(dt, sz));
                res.append("</param>\n");
            }
            res.append("</internallist>\n");
        }
        res.append("</prototype>\n");
    }

    public void readPrototypeXML(XmlPullParser parser, PcodeDataTypeManager dtmanage) throws PcodeXMLException {
        XmlElement node = parser.start(new String[]{"prototype"});
        this.modelname = node.getAttribute("model");
        String val = node.getAttribute("extrapop");
        this.extrapop = val.equals("unknown") ? 32768 : SpecXmlUtils.decodeInt((String)val);
        this.modellock = false;
        if (node.hasAttribute("modellock")) {
            this.modellock = SpecXmlUtils.decodeBoolean((String)node.getAttribute("modellock"));
        }
        this.dotdotdot = false;
        if (node.hasAttribute("dotdotdot")) {
            this.dotdotdot = SpecXmlUtils.decodeBoolean((String)node.getAttribute("dotdotdot"));
        }
        this.voidinputlock = false;
        if (node.hasAttribute("voidlock")) {
            this.voidinputlock = SpecXmlUtils.decodeBoolean((String)node.getAttribute("voidlock"));
        }
        this.isinline = false;
        if (node.hasAttribute("inline")) {
            this.isinline = SpecXmlUtils.decodeBoolean((String)node.getAttribute("inline"));
        }
        this.noreturn = false;
        if (node.hasAttribute("noreturn")) {
            this.noreturn = SpecXmlUtils.decodeBoolean((String)node.getAttribute("noreturn"));
        }
        this.custom = false;
        if (node.hasAttribute("custom")) {
            this.custom = SpecXmlUtils.decodeBoolean((String)node.getAttribute("custom"));
        }
        this.hasThis = false;
        if (node.hasAttribute("hasthis")) {
            this.hasThis = SpecXmlUtils.decodeBoolean((String)node.getAttribute("hasthis"));
        }
        this.isConstruct = false;
        if (node.hasAttribute("constructor")) {
            this.isConstruct = SpecXmlUtils.decodeBoolean((String)node.getAttribute("constructor"));
        }
        this.isDestruct = false;
        if (node.hasAttribute("destructor")) {
            this.isDestruct = SpecXmlUtils.decodeBoolean((String)node.getAttribute("destructor"));
        }
        XmlElement retel = parser.start(new String[]{"returnsym"});
        this.outputlock = false;
        if (retel.hasAttribute("typelock")) {
            this.outputlock = SpecXmlUtils.decodeBoolean((String)retel.getAttribute("typelock"));
        }
        parser.discardSubTree();
        this.returnstorage = null;
        this.returntype = dtmanage.readXMLDataType(parser);
        parser.end(retel);
        XmlElement peeknode = parser.peek();
        if (peeknode != null && peeknode.isStart()) {
            parser.discardSubTree();
        }
        parser.end(node);
    }
}

