/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public final class ProcessorContextImpl
implements ProcessorContext {
    Map<Register, byte[]> values = new HashMap<Register, byte[]>();
    Register[] registers;
    Register baseContextRegister;

    public ProcessorContextImpl(ProcessorContext context) {
        this(context.getRegisters());
        for (Register register : this.registers) {
            RegisterValue value;
            if (!register.isBaseRegister()) continue;
            if (register.isProcessorContext()) {
                this.baseContextRegister = register;
            }
            if ((value = context.getRegisterValue(register)) == null) continue;
            this.setRegisterValue(value);
        }
    }

    public ProcessorContextImpl(Register[] registers) {
        this.registers = registers;
    }

    @Override
    public Register getBaseContextRegister() {
        return this.baseContextRegister;
    }

    @Override
    public Register getRegister(String name) {
        for (Register register : this.registers) {
            if (!register.getName().equals(name)) continue;
            return register;
        }
        return null;
    }

    @Override
    public Register[] getRegisters() {
        return this.registers;
    }

    @Override
    public RegisterValue getRegisterValue(Register register) {
        byte[] bytes = this.values.get(register.getBaseRegister());
        if (bytes == null) {
            return null;
        }
        return new RegisterValue(register, bytes);
    }

    @Override
    public BigInteger getValue(Register register, boolean signed) {
        byte[] bytes = this.values.get(register.getBaseRegister());
        if (bytes == null) {
            return null;
        }
        RegisterValue value = new RegisterValue(register, bytes);
        return signed ? value.getSignedValue() : value.getUnsignedValue();
    }

    @Override
    public boolean hasValue(Register register) {
        return this.getValue(register, false) != null;
    }

    @Override
    public void setValue(Register register, BigInteger value) {
        this.setRegisterValue(new RegisterValue(register, value));
    }

    @Override
    public void setRegisterValue(RegisterValue value) {
        Register baseRegister = value.getRegister().getBaseRegister();
        byte[] currentBytes = this.values.get(baseRegister);
        if (currentBytes != null) {
            RegisterValue currentValue = new RegisterValue(baseRegister, currentBytes);
            RegisterValue combinedValue = currentValue.combineValues(value);
            this.values.put(baseRegister, combinedValue.toBytes());
        } else {
            this.values.put(baseRegister, value.toBytes());
        }
    }

    @Override
    public void clearRegister(Register register) {
        Register baseRegister = register.getBaseRegister();
        byte[] currentBytes = this.values.remove(baseRegister);
        if (currentBytes != null) {
            RegisterValue currentValue = new RegisterValue(baseRegister, currentBytes);
            if ((currentValue = currentValue.clearBitValues(register.getBaseMask())).hasAnyValue()) {
                this.values.put(baseRegister, currentValue.toBytes());
            }
        }
    }

    public void clearAll() {
        this.values.clear();
    }
}

