/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.lang.DynamicVariableStorage;
import ghidra.program.model.lang.ParamListStandard;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;

public class ParamListStandardOut
extends ParamListStandard {
    @Override
    public void assignMap(Program prog, DataType[] proto, boolean isinput, ArrayList<VariableStorage> res, boolean addAutoParams) {
        int[] status = new int[this.numgroup];
        for (int i = 0; i < this.numgroup; ++i) {
            status[i] = 0;
        }
        VariableStorage store = this.assignAddress(prog, proto[0], status, false, false);
        if (!store.isUnassignedStorage()) {
            res.add(store);
            return;
        }
        Pointer pointer = prog.getDataTypeManager().getPointer(proto[0]);
        store = this.assignAddress(prog, pointer, status, false, false);
        try {
            if (store.isValid()) {
                store = new DynamicVariableStorage(prog, true, store.getVarnodes());
                res.add(store);
            }
            if (addAutoParams) {
                res.add(VariableStorage.UNASSIGNED_STORAGE);
            }
        }
        catch (InvalidInputException e) {
            store = VariableStorage.UNASSIGNED_STORAGE;
            res.add(store);
        }
    }
}

