/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

public final class OperandType {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int INDIRECT = 4;
    public static final int IMMEDIATE = 8;
    public static final int RELATIVE = 16;
    public static final int IMPLICIT = 32;
    public static final int CODE = 64;
    public static final int DATA = 128;
    public static final int PORT = 256;
    public static final int REGISTER = 512;
    public static final int LIST = 1024;
    public static final int FLAG = 2048;
    public static final int TEXT = 4096;
    public static final int ADDRESS = 8192;
    public static final int SCALAR = 16384;
    public static final int BIT = 32768;
    public static final int BYTE = 65536;
    public static final int WORD = 131072;
    public static final int QUADWORD = 262144;
    public static final int SIGNED = 524288;
    public static final int FLOAT = 0x100000;
    public static final int COP = 0x200000;
    public static final int DYNAMIC = 0x400000;

    public static boolean doesRead(int operandType) {
        return (operandType & 1) != 0;
    }

    public static boolean doesWrite(int operandType) {
        return (operandType & 2) != 0;
    }

    public static boolean isIndirect(int operandType) {
        return (operandType & 4) != 0;
    }

    public static boolean isImmediate(int operandType) {
        return (operandType & 8) != 0;
    }

    public static boolean isRelative(int operandType) {
        return (operandType & 0x10) != 0;
    }

    public static boolean isImplicit(int operandType) {
        return (operandType & 0x20) != 0;
    }

    public static boolean isCodeReference(int operandType) {
        return (operandType & 0x40) != 0;
    }

    public static boolean isDataReference(int operandType) {
        return (operandType & 0x80) != 0;
    }

    public static boolean isPort(int operandType) {
        return (operandType & 0x100) != 0;
    }

    public static boolean isRegister(int operandType) {
        return (operandType & 0x200) != 0;
    }

    public static boolean isList(int operandType) {
        return (operandType & 0x400) != 0;
    }

    public static boolean isFlag(int operandType) {
        return (operandType & 0x800) != 0;
    }

    public static boolean isText(int operandType) {
        return (operandType & 0x1000) != 0;
    }

    public static boolean isAddress(int operandType) {
        return (operandType & 0x2000) != 0;
    }

    public static boolean isScalar(int operandType) {
        return (operandType & 0x4000) != 0;
    }

    public static boolean isBit(int operandType) {
        return (operandType & 0x8000) != 0;
    }

    public static boolean isByte(int operandType) {
        return (operandType & 0x10000) != 0;
    }

    public static boolean isWord(int operandType) {
        return (operandType & 0x20000) != 0;
    }

    public static boolean isQuadWord(int operandType) {
        return (operandType & 0x40000) != 0;
    }

    public static boolean isSigned(int operandType) {
        return (operandType & 0x80000) != 0;
    }

    public static boolean isFloat(int operandType) {
        return (operandType & 0x100000) != 0;
    }

    public static boolean isCoProcessor(int operandType) {
        return (operandType & 0x200000) != 0;
    }

    public static boolean isScalarAsAddress(int operandType) {
        return OperandType.isAddress(operandType) && OperandType.isScalar(operandType);
    }

    public static String toString(int operandType) {
        StringBuffer buf = new StringBuffer();
        if (OperandType.isAddress(operandType)) {
            OperandType.append(buf, "ADDR");
        }
        if (OperandType.isScalar(operandType)) {
            OperandType.append(buf, "SCAL");
        }
        if (OperandType.isPort(operandType)) {
            OperandType.append(buf, "PORT");
        }
        if (OperandType.isRegister(operandType)) {
            OperandType.append(buf, "REG ");
        }
        if (OperandType.isList(operandType)) {
            OperandType.append(buf, "LIST");
        }
        if (OperandType.isFlag(operandType)) {
            OperandType.append(buf, "FLAG");
        }
        if (OperandType.isText(operandType)) {
            OperandType.append(buf, "TEXT");
        }
        if (OperandType.isCodeReference(operandType)) {
            OperandType.append(buf, "CODE");
        }
        if (OperandType.isDataReference(operandType)) {
            OperandType.append(buf, "DATA");
        }
        if (OperandType.isBit(operandType)) {
            OperandType.append(buf, "BIT ");
        }
        if (OperandType.isByte(operandType)) {
            OperandType.append(buf, "BYTE");
        }
        if (OperandType.isWord(operandType)) {
            OperandType.append(buf, "WORD");
        }
        if (OperandType.isQuadWord(operandType)) {
            OperandType.append(buf, "QUAD");
        }
        if (OperandType.isSigned(operandType)) {
            OperandType.append(buf, "SIGN");
        }
        if (OperandType.isFloat(operandType)) {
            OperandType.append(buf, "FLT ");
        }
        if (OperandType.isIndirect(operandType)) {
            OperandType.append(buf, "IND ");
        }
        if (OperandType.isImmediate(operandType)) {
            OperandType.append(buf, "IMM ");
        }
        if (OperandType.isRelative(operandType)) {
            OperandType.append(buf, "REL ");
        }
        if (OperandType.isImplicit(operandType)) {
            OperandType.append(buf, "IMPL");
        }
        if (OperandType.doesRead(operandType)) {
            OperandType.append(buf, "READ");
        }
        if (OperandType.doesWrite(operandType)) {
            OperandType.append(buf, "WRTE");
        }
        if (OperandType.isCoProcessor(operandType)) {
            OperandType.append(buf, "COP ");
        }
        return buf.toString();
    }

    private static void append(StringBuffer buf, String str) {
        if (buf.length() > 0) {
            buf.append(" | ");
        }
        buf.append(str);
    }
}

