/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.docking.settings.Settings;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.CompositeAlignmentHelper;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeComponentImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.GenericDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.InvalidNameException;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.NotYetImplementedException;

public abstract class CompositeDataTypeImpl
extends GenericDataType
implements Composite {
    private static final long serialVersionUID = 1L;
    private String description = "";
    protected boolean aligned = false;
    protected Composite.AlignmentType alignmentType = Composite.AlignmentType.DEFAULT_ALIGNED;
    protected int packingValue = 0;
    protected int externalAlignment = 0;

    CompositeDataTypeImpl(CategoryPath path, String name, UniversalID universalID, SourceArchive sourceArchive, long lastChangeTime, long lastChangeTimeInSourceArchive, DataTypeManager dtm) {
        super(path != null ? path : CategoryPath.ROOT, name, universalID, sourceArchive, lastChangeTime, lastChangeTimeInSourceArchive, dtm);
    }

    CompositeDataTypeImpl(CategoryPath path, String name, DataTypeManager dtm) {
        super(path != null ? path : CategoryPath.ROOT, name, dtm);
    }

    protected int getPreferredComponentLength(DataType dataType, int length) {
        if ((this.isInternallyAligned() || this instanceof Union) && !(dataType instanceof Dynamic)) {
            length = -1;
        }
        int dtLength = dataType.getLength();
        if (length <= 0) {
            length = dtLength;
        } else if (dtLength > 0 && dtLength < length) {
            length = dtLength;
        }
        if (length <= 0) {
            throw new IllegalArgumentException("Positive length must be specified for " + dataType.getDisplayName() + " component");
        }
        return length;
    }

    @Override
    public boolean isDynamicallySized() {
        return this.isInternallyAligned();
    }

    @Override
    public boolean isPartOf(DataType dataTypeOfInterest) {
        return DataTypeUtilities.isSecondPartOfFirst(this, dataTypeOfInterest);
    }

    protected void checkAncestry(DataType dataType) {
        if (this.equals(dataType)) {
            throw new IllegalArgumentException("Data type " + this.getDisplayName() + " can't contain itself.");
        }
        if (DataTypeUtilities.isSecondPartOfFirst(dataType, this)) {
            throw new IllegalArgumentException("Data type " + dataType.getDisplayName() + " has " + this.getDisplayName() + " within it.");
        }
    }

    protected void validateDataType(DataType dataType) {
        Dynamic dynamicDataType;
        if (this.isInternallyAligned() && dataType == DataType.DEFAULT) {
            throw new IllegalArgumentException("The DEFAULT data type is not allowed in an aligned composite data type.");
        }
        if (dataType instanceof FactoryDataType) {
            throw new IllegalArgumentException("The \"" + dataType.getName() + "\" data type is not allowed in a composite data type.");
        }
        if (dataType instanceof Dynamic && !(dynamicDataType = (Dynamic)dataType).canSpecifyLength()) {
            throw new IllegalArgumentException("The \"" + dataType.getName() + "\" data type is not allowed in a composite data type.");
        }
    }

    protected boolean updateBitFieldDataType(DataTypeComponentImpl bitfieldComponent, DataType oldDt, DataType newDt) throws InvalidDataTypeException {
        if (!bitfieldComponent.isBitFieldComponent()) {
            throw new AssertException("expected bitfield component");
        }
        BitFieldDataType bitfieldDt = (BitFieldDataType)bitfieldComponent.getDataType();
        if (bitfieldDt.getBaseDataType() != oldDt) {
            return false;
        }
        if (newDt != null) {
            BitFieldDataType.checkBaseDataType(newDt);
            int maxBitSize = 8 * newDt.getLength();
            if (bitfieldDt.getBitSize() > maxBitSize) {
                throw new InvalidDataTypeException("Replacement datatype too small for bitfield");
            }
        }
        try {
            BitFieldDataType newBitfieldDt = new BitFieldDataType(newDt, bitfieldDt.getDeclaredBitSize(), bitfieldDt.getBitOffset());
            bitfieldComponent.setDataType(newBitfieldDt);
            oldDt.removeParent(this);
            newDt.addParent(this);
        }
        catch (InvalidDataTypeException e) {
            throw new AssertException("unexpected");
        }
        return true;
    }

    @Override
    public void setDescription(String desc) {
        this.description = desc == null ? "" : desc;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    public void setValue(MemBuffer buf, Settings settings, int length, Object value) {
        throw new NotYetImplementedException("setValue() not implemented");
    }

    @Override
    public final DataTypeComponent add(DataType dataType) {
        return this.add(dataType, -1, null, null);
    }

    @Override
    public final DataTypeComponent add(DataType dataType, int length) {
        return this.add(dataType, length, null, null);
    }

    @Override
    public final DataTypeComponent add(DataType dataType, String fieldName, String comment) {
        return this.add(dataType, -1, fieldName, comment);
    }

    @Override
    public final DataTypeComponent insert(int ordinal, DataType dataType, int length) {
        return this.insert(ordinal, dataType, length, null, null);
    }

    @Override
    public final DataTypeComponent insert(int ordinal, DataType dataType) {
        return this.insert(ordinal, dataType, -1, null, null);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.getDisplayName();
    }

    @Override
    public void setName(String name) throws InvalidNameException {
        this.checkValidName(name);
        this.name = name;
    }

    @Override
    public int getPackingValue() {
        return this.packingValue;
    }

    @Override
    public void setPackingValue(int packingValue) {
        if (packingValue < 0) {
            packingValue = 0;
        }
        this.aligned = true;
        this.packingValue = packingValue;
        this.adjustInternalAlignment();
    }

    @Override
    public int getMinimumAlignment() {
        if (this.alignmentType == Composite.AlignmentType.MACHINE_ALIGNED) {
            return this.getMachineAlignment();
        }
        if (this.alignmentType == Composite.AlignmentType.DEFAULT_ALIGNED) {
            return 0;
        }
        return this.externalAlignment;
    }

    @Override
    public void setMinimumAlignment(int externalAlignment) {
        if (externalAlignment < 1) {
            this.externalAlignment = 0;
            this.alignmentType = Composite.AlignmentType.DEFAULT_ALIGNED;
        } else {
            this.externalAlignment = externalAlignment;
            this.alignmentType = Composite.AlignmentType.ALIGNED_BY_VALUE;
        }
        this.aligned = true;
        this.adjustInternalAlignment();
    }

    private int getMachineAlignment() {
        return this.getDataOrganization().getMachineAlignment();
    }

    @Override
    public boolean isInternallyAligned() {
        return this.aligned;
    }

    @Override
    public boolean isDefaultAligned() {
        return this.alignmentType == Composite.AlignmentType.DEFAULT_ALIGNED;
    }

    @Override
    public boolean isMachineAligned() {
        return this.alignmentType == Composite.AlignmentType.MACHINE_ALIGNED;
    }

    @Override
    public void setInternallyAligned(boolean aligned) {
        if (this.aligned != aligned) {
            this.aligned = aligned;
            if (!aligned) {
                this.alignmentType = Composite.AlignmentType.DEFAULT_ALIGNED;
                this.packingValue = 0;
            }
        }
        this.adjustInternalAlignment();
    }

    @Override
    public void setToDefaultAlignment() {
        this.aligned = true;
        this.alignmentType = Composite.AlignmentType.DEFAULT_ALIGNED;
        this.adjustInternalAlignment();
    }

    @Override
    public void setToMachineAlignment() {
        this.aligned = true;
        this.alignmentType = Composite.AlignmentType.MACHINE_ALIGNED;
        this.adjustInternalAlignment();
    }

    protected void notifyAlignmentChanged() {
        DataType[] parents;
        for (DataType dataType : parents = this.getParents()) {
            if (!(dataType instanceof Composite)) continue;
            Composite composite = (Composite)dataType;
            composite.dataTypeAlignmentChanged(this);
        }
    }

    protected abstract void adjustInternalAlignment();

    @Override
    public int getAlignment() {
        return CompositeAlignmentHelper.getAlignment(this.getDataOrganization(), this);
    }

    protected void setAlignment(Composite composite) {
        this.aligned = composite.isInternallyAligned();
        if (composite.isDefaultAligned()) {
            this.alignmentType = Composite.AlignmentType.DEFAULT_ALIGNED;
        } else if (composite.isMachineAligned()) {
            this.alignmentType = Composite.AlignmentType.MACHINE_ALIGNED;
        } else {
            if (this.alignmentType != Composite.AlignmentType.ALIGNED_BY_VALUE) {
                this.alignmentType = Composite.AlignmentType.ALIGNED_BY_VALUE;
            }
            this.externalAlignment = composite.getMinimumAlignment();
        }
        this.packingValue = composite.getPackingValue();
        this.adjustInternalAlignment();
    }

    protected void dumpComponents(StringBuilder buffer, String pad) {
        for (DataTypeComponent dtc : this.getComponents()) {
            DataType dataType = dtc.getDataType();
            buffer.append(pad + dtc.getOffset());
            buffer.append(pad + dataType.getDisplayName());
            if (dataType instanceof BitFieldDataType) {
                BitFieldDataType bfDt = (BitFieldDataType)dataType;
                buffer.append("(");
                buffer.append(Integer.toString(bfDt.getBitOffset()));
                buffer.append(")");
            }
            buffer.append(pad + dtc.getLength());
            buffer.append(pad + dtc.getFieldName());
            String comment = dtc.getComment();
            if (comment == null) {
                comment = "";
            }
            buffer.append(pad + "\"" + comment + "\"");
            buffer.append("\n");
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append(this.getPathName() + "\n");
        stringBuffer.append(this.getAlignmentSettingsString() + "\n");
        stringBuffer.append(this.getTypeName() + " " + this.getDisplayName() + " {\n");
        this.dumpComponents(stringBuffer, "   ");
        stringBuffer.append("}\n");
        stringBuffer.append("Size = " + this.getLength() + "   Actual Alignment = " + this.getAlignment() + "\n");
        return stringBuffer.toString();
    }

    private String getTypeName() {
        if (this instanceof Structure) {
            return "Structure";
        }
        if (this instanceof Union) {
            return "Union";
        }
        return "";
    }

    private String getAlignmentSettingsString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isInternallyAligned()) {
            stringBuffer.append("Unaligned");
        } else if (this.isDefaultAligned()) {
            stringBuffer.append("Aligned");
        } else if (this.isMachineAligned()) {
            stringBuffer.append("Machine aligned");
        } else {
            long alignment = this.getMinimumAlignment();
            stringBuffer.append("align(" + alignment + ")");
        }
        stringBuffer.append(this.getPackingString());
        return stringBuffer.toString();
    }

    private String getPackingString() {
        if (!this.isInternallyAligned()) {
            return "";
        }
        if (this.packingValue == 0) {
            return "";
        }
        return " pack(" + this.packingValue + ")";
    }
}

